/****************************************************************************/
/*  Projekt:  EuroSpeed                                                     */
/*	Programm: Sample														*/
/*  Datei:    Dialog.C                                                      */
/*                                                                          */
/*  Funktionen: DlgAbout()                                                  */
/*				DlgVerbindung()												*/
/*																			*/
/****************************************************************************/
/*                                                                          */
/*	Torsten Schulz	 -	 Acotec GmbH Berlin   -    17.12.1992				*/
/*                                                                          */
/****************************************************************************/

/*
 * Includes
 */

#include <dos.h>
#include <Windows.H>
#include <CommDlg.H>
#include <DdeMl.H>
#include "Help.H"
#include "Sample.H"

/*
 * Defines
 */

#define _WINDOWS
#define NOCOMM


/*
 * Functions
 */

/****************************************************************************/
/* DlgAbout                                                                 */
/****************************************************************************/
BOOL FAR PASCAL DlgAbout(   HWND    hDlg,
							WORD    message,
							WORD    wParam,
							LONG    lParam  )
{
	char	 szBuffer[ MAX_TEXT ];
	char	 szSmallBuf[ 80 ];
	DWORD	 dwWinflags, dwFreeSpace;
	unsigned drive;
	unsigned uAX, uDX;

	lParam = lParam;

	switch (message)
	{
	case WM_INITDIALOG:
		CenterDialog( hDlg );
		if (!(SetTimer( hDlg, 1, 200, NULL )))
		{
			ErrorBox( hDlg, IDERR_TIMER );
		}
		return TRUE;

	case WM_TIMER:
		KillTimer ( hDlg, 1 );

		/* Text */
		LoadString( hInst, IDSTR_ABOUT, szBuffer, MAX_TEXT );
		SetDlgItemText ( hDlg, ID_ABOUT, (LPSTR) szBuffer);

		/* Mode */
		dwWinflags = GetWinFlags();
		szBuffer[0] = '\0';
		if (dwWinflags & WF_ENHANCED)
			lstrcat( szBuffer, "386 Enhanced Mode\n");
		else
			lstrcat( szBuffer, "Standard Mode\n");

		/* Space */
		dwFreeSpace = GetFreeSpace( 0 );
		wsprintf( szSmallBuf, "%ld", dwFreeSpace / 1024 );
		lstrcat( szBuffer, "Conventional Memory:\t");
		lstrcat( szBuffer, szSmallBuf );
		lstrcat( szBuffer, " KB Free\n");

		/* Co processor */
		if (dwWinflags & WF_80x87)
			lstrcat( szBuffer, "Math Co-processor:\tPresent\n");
		else
			lstrcat( szBuffer, "Math Co-processor:\tNone\n");

		/* Disk space */
		_dos_getdrive( &drive );
		wsprintf( szSmallBuf, "%c", 'A' + drive - 1 );
		lstrcat( szBuffer, "Disk Space on ");
		lstrcat( szBuffer, szSmallBuf );
		_asm
		{
			mov     dx, drive           ; Set Current Drive
			mov     ah, 36h
			int     21h
			cmp     ax, 0ffffh          ; bogus drive?
			je      error
			mul     cx
			mul     bx
			jmp     done                ; DX:AX contains free space
error:
			mov     dx, ax              ; return dx:ax = -1L
done:
			mov     uAX, ax             ; set uAX
			mov     uDX, dx             ; set uDX
		}
		if ( uAX != -1 )
			dwFreeSpace = (((unsigned long) uDX << 16) | uAX) / 1024;
		else
			dwFreeSpace = -1;
		wsprintf( szSmallBuf, ":\t\t%ld KB Free", dwFreeSpace );
		lstrcat( szBuffer, szSmallBuf );

		SetDlgItemText ( hDlg, ID_OPTIONS, (LPSTR) szBuffer);

		return TRUE;

	case WM_COMMAND:
		switch (wParam)
		{
		case IDOK:
		case ID_OK:
		case IDCANCEL:
			EndDialog( hDlg, wParam );
			return TRUE;

		}
		return TRUE;

	}
	return FALSE;
}

/****************************************************************************/
/* DlgVerbindung																 */
/****************************************************************************/
BOOL FAR PASCAL DlgVerbindung(	 HWND	 hDlg,
								 WORD	 message,
								 WORD	 wParam,
								 LONG	 lParam  )
{
	HANDLE	hData;
	LPLOCAL	lpData;
	char	szNumber[MAX_NUMBER];
	char	szBuffer[ MAX_TEXT ];

	lParam = lParam;

	switch (message)
	{
	case WM_INITDIALOG:
		CenterDialog( hDlg );

		LoadString( hInst, IDSTR_BITTE, szBuffer, MAX_TEXT );
		SetDlgItemText ( hDlg, ID_BITTE, (LPSTR) szBuffer);

		GetProfileString("EuroDDE", "NUMBER", "", szNumber, MAX_NUMBER );
		SetDlgItemText ( hDlg, ID_NUMMER, (LPSTR) szNumber );

		hData = GetProp( GetParent(hDlg), "hLocal" );
		lpData = (LPLOCAL) GlobalLock( hData );
		lstrcpy( lpData->szNumber, szNumber );
		GlobalUnlock (hData);

		return TRUE;


	case WM_COMMAND:
		switch (wParam)
		{
		case IDOK:
		case ID_OK:
			GetDlgItemText ( hDlg, ID_NUMMER, (LPSTR) szNumber, MAX_NUMBER );

			hData = GetProp( GetParent(hDlg), "hLocal" );
			lpData = (LPLOCAL) GlobalLock( hData );
			lstrcpy( lpData->szNumber, szNumber );
			if ( &lpData->szFile == 0 )
			{
				WriteProtokoll( GetParent(hDlg), "keine Datei", TRUE);
				GlobalUnlock (hData);
				break;
			}
			wsprintf( szBuffer, "Select: %s", (LPSTR) szNumber );
			WriteProtokoll( GetParent(hDlg), (LPSTR) szBuffer, TRUE);
			GlobalUnlock (hData);

			WriteProfileString("EuroDDE", "NUMBER", szNumber );

			EndDialog( hDlg, TRUE );
			break;

		case IDCANCEL:
		case ID_CANCEL:
			EndDialog( hDlg, FALSE );
			break;

		case ID_HELP:
			WinHelp( hDlg, "Sample.HLP", HELP_CONTEXT, HlpSenden );
			break;

		}
		return TRUE;

	}
	return FALSE;
}
