/****************************************************************************/
/*	Projekt:  EuroSpeed														*/
/*	Programm: Sample														*/
/*	Datei:	  DDE.H															*/
/*																			*/
/****************************************************************************/
/*																			*/
/*	Torsten Schulz	 -	 Acotec GmbH Berlin	  -	   17.12.1992				*/
/*																			*/
/****************************************************************************/

/*
 * Defines
 */

/*
 * Prototyp
 */
HDDEDATA EXPENTRY DdeCallback ( WORD		wTransType,
								WORD        wClipFmt,
								HCONV       hConv,
								HSZ         hsz1,
								HSZ         hsz2,
								HDDEDATA    hDataIn,
								DWORD       dwData1,
								DWORD       dwData2     );

HCONV TestDDEConnect          ( HWND        hWnd );
int Clip2Cmd(		   WORD 					wClipFmt);
void ConnectStateProc( HWND 					hWnd,
					   HCONV					hConv,
					   connect_state_t far		*lpConnectState );
void SaveStateProc(    HWND						hWnd,
					   HCONV					hConv,
					   save_state_t far			*lpSaveState );
void DisconnStateProc( HWND						hWnd,
					   disconnect_state_t far	*lpDisconnState );
void ServerStateProc(  HWND						hWnd,
					   server_state_t far		*lpServerState );

/*
 * Tables
 */
HCONV Conversations[MAX_TOPICS];

BYTE HotItems[MAX_HOTITEMS][MAX_ITEM_LEN] =
{
	SZDDE_ITEM_CONNECT_STATE, 
	SZDDE_ITEM_DISCONNECT_STATE,
	SZDDE_ITEM_DIR_PROTECT_RESP,
  	SZDDE_ITEM_SAVE_STATE,
	SZDDE_ITEM_LOAD_STATE,

	SZDDE_ITEM_DIR_STATE,
	SZDDE_ITEM_RENAME_STATE, 
	SZDDE_ITEM_DELETE_STATE,
	SZDDE_ITEM_SERVER_STATE,
	SZDDE_ITEM_REMOTE_TREE_STATE,

  	SZDDE_ITEM_CHPASSWD_STATE,
	SZDDE_ITEM_TYPED_DATA_IND,
	SZDDE_ITEM_INFO_IND,
	SZDDE_ITEM_MKDIR_STATE,
	SZDDE_ITEM_RMDIR_STATE,

	SZDDE_ITEM_PUBLICDIR_STATE
};

WORD HotFormats[MAX_HOTITEMS] =
{
	C_CONNECT_STATE,
	C_DISCONNECT_STATE,
	C_DIR_PROTECT_RESP,
	C_SAVE_STATE,
	C_LOAD_STATE,

	C_DIR_STATE,
	C_RENAME_STATE,
	C_DELETE_STATE,
	C_SERVER_STATE,
	C_REMOTE_TREE_STATE,

	C_CHPASSWD_STATE,
	C_TYPED_DATA_IND,
	C_INFO_IND,
	C_MKDIR_STATE,
	C_RMDIR_STATE,

	C_PUBLICDIR_STATE
};

FORMATINFO aFormats[MAX_FORMATS] =
{
    {0, "TEXT"},
    {0, SZDDE_FMT_LOCAL_LOGBOOK},
    {0, SZDDE_FMT_LOCAL_LOGNAME},
    {0, SZDDE_FMT_LOCAL_CHANNELMODE},
    {0, SZDDE_FMT_DIR_PROTECT_REQ},

    {0, SZDDE_FMT_DIR_PROTECT_RESP},
    {0, SZDDE_FMT_DIR_PROTECT_UPDATE},
    {0, SZDDE_FMT_SYS_PROTECT_GET},
    {0, SZDDE_FMT_SYS_PROTECT_DELETE},
    {0, SZDDE_FMT_SYS_PROTECT_ADD},

    {0, SZDDE_FMT_CONNECT_REQ},
    {0, SZDDE_FMT_CONNECT_STATE},
    {0, SZDDE_FMT_DISCONNECT_REQ},
    {0, SZDDE_FMT_DISCONNECT_STATE},
    {0, SZDDE_FMT_SAVE_REQ},

    {0, SZDDE_FMT_SAVE_STATE},
    {0, SZDDE_FMT_LOAD_REQ},
    {0, SZDDE_FMT_LOAD_STATE},
    {0, SZDDE_FMT_DIR_REQ},
    {0, SZDDE_FMT_DIR_STATE},

    {0, SZDDE_FMT_RENAME_REQ},
    {0, SZDDE_FMT_RENAME_STATE},
    {0, SZDDE_FMT_DELETE_REQ},
    {0, SZDDE_FMT_DELETE_STATE},
    {0, SZDDE_FMT_CHPASSWD_REQ},

    {0, SZDDE_FMT_CHPASSWD_STATE},
    {0, SZDDE_FMT_VERSION_GET},
	{0, SZDDE_FMT_ABORT_REQ},
	{0, SZDDE_FMT_SERVER_STATE},
	{0, SZDDE_FMT_REMOTE_TREE_REQ},

	{0, SZDDE_FMT_REMOTE_TREE_STATE},
	{0, SZDDE_FMT_LISTEN_REQ},
	{0, SZDDE_FMT_TYPED_DATA_REQ},
	{0, SZDDE_FMT_TYPED_DATA_IND},
	{0, SZDDE_FMT_INFO_REQ},

	{0, SZDDE_FMT_INFO_IND},
	{0, SZDDE_FMT_MKDIR_REQ},
	{0, SZDDE_FMT_MKDIR_STATE},
	{0, SZDDE_FMT_RMDIR_REQ},
	{0, SZDDE_FMT_RMDIR_STATE},

	{0, SZDDE_FMT_PUBLICDIR_REQ},
	{0, SZDDE_FMT_PUBLICDIR_STATE}
};
