/***********************************************************************
** Copyright Classification:
**
** Copyright (C) International Business Machines Corp., 1994.             
**                                                                        
**                                                                        
** DISCLAIMER OF WARRANTIES:                                              
** -------------------------                                              
** The following [enclosed] code is sample code created by IBM            
** Corporation.  This sample code is not part of any standard IBM product 
** and is provided to you solely for the purpose of assisting you in the  
** development of your applications.  The code is provided "AS IS",       
** without warranty of any kind.  IBM shall not be liable for any damages 
** arising out of your use of the sample code, even if they have been     
** advised of the possibility of such damages.                            
**                                                                        
** Purpose: class sws_txtp Methods
**    Spec: Simple text part
**          ESCAPE key switches drawing modes to LEAVEALONE from
**          OVERPAINT
**--------------------------------------------------------------------
**
** Change Activity:  
**   15May94 Created: redpath
***********************************************************************/
#include "string.h"                   
#include "swstxtp.hpp"                    //class sws_txtp


//-----------------------------------------------------------
// CreatePart: Standard Exported entry point to create part
//             instance but no persistent storage associated
//             with it yet for OpenDoc. InitPart is used to
//             create persistent storage and setup OpenDoc
//             structures that the part needs.
//------------------------------------------------------------
extern "C" XMPPart* EXPENTRY CreatePart()
{
   return new sws_txtp();
}



//-----------------------------------------------------------
// sws_txtp: Constructor for Text Part Class. Create instance of part
//           allocated and initialize the data to indicate that
//           OpenDoc setup has not been obtained yet.
//-----------------------------------------------------------
sws_txtp::sws_txtp()
{
  _fInitialized   = kXMPFalse;
  _fswstxtpSU     = 0;
  _fDisplayFrames = 0;
  _proxy          = 0;
}



//-----------------------------------------------------------
// sws_txtp: destructor for Text Part Class
//-----------------------------------------------------------
sws_txtp::~sws_txtp()
{
  if (_proxy)
     delete(_proxy);
  XMPDeleteObject(_fDisplayFrames);// Release the display frames collection.
                          // Deletion of memory used by the object will be
                          // reclaimed when the shell deletes the
                          // instantiation.
  XMPReleaseObject(_fswstxtpSU);
}



//-----------------------------------------------------------
// QueryText: Used to get the Text Part text if anyone should 
//            subclass this class and need the text.
//-----------------------------------------------------------
void sws_txtp::QueryText(char *text)
{
 strcpy(text,_proxy->gettextbuffer());
}


//-----------------------------------------------------------
// SetText: Used to set the Text Part text
//-----------------------------------------------------------
void sws_txtp::SetText(char *text)
{
 _proxy->settext(text);
}



//-----------------------------------------------------------
// resize: Used for resize requirements
//-----------------------------------------------------------
void sws_txtp::resize(XMPFrame *frame)
{HRGN  hrgnFrame;
 RECTL rclFrame;
 HPS   screenps;

 hrgnFrame= (HRGN)frame->GetFrameShape()->GetPlatformShape(kXMPOS2PM);
 screenps = WinGetScreenPS(HWND_DESKTOP);
 GpiQueryRegionBox(screenps,hrgnFrame,&rclFrame);
 _proxy->size(&rclFrame);

}


//-----------------------------------------------------------
// IncrementRefCount: Increments the reference count of the
//                    container XMPContainer.
//-----------------------------------------------------------
void sws_txtp::IncrementRefCount()
{
  XMPRefCntObject::IncrementRefCount();
}



//-----------------------------------------------------------
// Release: Release decrements the container ref count. If the
//          ref count is zero get storage unit draft and
//          release the part.
//-----------------------------------------------------------
void sws_txtp::Release()
{
   XMPRefCntObject::Release();
   if (this->GetRefCount() == 0)
      this->GetStorageUnit()->GetDraft()->ReleasePart(this);
}



//-----------------------------------------------------------
// Initialize: Convenience function to initialize a OpenDoc
//             instance of the text part from creating a new one
//             or from a dormant instance from storage.
//       Spec: The session must be obtained already
//-----------------------------------------------------------
void sws_txtp:: Initialize()
{
   this->_fInitialized = kXMPTrue;
   _fDisplayFrames = new OrderedCollection;   // Create an empty collection 
                                             // for storing the list 
   _fSelectionFocus    = _fSession->Tokenize(kXMPSelectionFocus);
   _fMenuFocus         = _fSession->Tokenize(kXMPMenuFocus);
   _fKeyFocus          = _fSession->Tokenize(kXMPKeyFocus);

   _fFocusSet          = new XMPFocusSet();
   _fFocusSet->InitFocusSet();
   _fFocusSet->Add(_fSelectionFocus);
   _fFocusSet->Add(_fMenuFocus);
   _fFocusSet->Add(_fKeyFocus);

   _proxy = new sws_txtd(); 
}




//-----------------------------------------------------------
// InitPart: Called to create a storage instance of the
//           Text Part in OpenDoc after the class instance
//           has been constructed.
//-----------------------------------------------------------
void sws_txtp::InitPart(XMPStorageUnit* storageUnit)
{
   if (_fInitialized)
      return;

   XMPPersistentObject::InitPersistentObject(storageUnit);
   _fSession = storageUnit->GetSession();
   this->Initialize();

   storageUnit->AddProperty(kXMPPropContents)->AddValue(kXMPKindswstxtp);   
   _fswstxtpSU = storageUnit->GetDraft()->CreateStorageUnit();
   _fswstxtpSU->AddProperty(kXMPPropDisplayFrames)->AddValue(kXMPID);        
}





//-----------------------------------------------------------
// InitPartFromStorage: Called to wakeup a dormant part
//                      It will obtain the storage unit.
//-----------------------------------------------------------
void sws_txtp::InitPartFromStorage(XMPStorageUnit* storageUnit)
{
   if (_fInitialized)
      return;

   XMPPersistentObject::InitPersistentObjectFromStorage(storageUnit);

   _fSession = storageUnit->GetSession();
   this-> Initialize();

   XMPULong valueSize, offset;
   XMPStorageUnitRef aSURef;
   XMPFrame* aFrame;
   XMPStorageUnit* su;

   su = this->GetStorageUnit();
   su->Focus(kXMPPropContents,kXMPPosSame,kXMPKindswstxtp,1,kXMPPosFirstSib);
   su->GetValue(sizeof(XMPStorageUnitRef),&aSURef);
   _fswstxtpSU = 
        su->GetDraft()->GetStorageUnit(su->GetIDFromStorageUnitRef(aSURef));
   su = _fswstxtpSU;
   
   su->Focus(kXMPPropDisplayFrames,kXMPPosUndefined,0,1,kXMPPosFirstSib);
   valueSize = su->GetSize();
   for (offset = 0; offset < valueSize; offset += sizeof(XMPStorageUnitRef))
   {
      su->SetOffset(offset);
      su->GetValue(sizeof(XMPStorageUnitRef), (XMPValue)&aSURef);
      
      TRY
      
         aFrame = su->GetDraft()->GetFrame(su->GetIDFromStorageUnitRef(aSURef));
         _fDisplayFrames->AddLast((ElementType)aFrame);
         this->resize(aFrame);
      
      CATCH_ALL
      
         aFrame = kXMPNULL;

      ENDTRY
   }
   
 // We should minimize the frame shape here, but we can't because I think that
 // the fPart and fPartInfo for the frame hasn't been set up yet.
 // this->MinimizeFrameShape(dispFrame);   
}




//*********From Imaging protocol****************8

void sws_txtp::display(XMPFacet* facet)
{HPS       hps;
 HRGN      hrgnClip;
 XMPShape* clipShape = new XMPShape;
 POINTL    ptl;
 HWND hwnd= facet->GetWindow()->GetPlatformWindow();

 hwnd = WinWindowFromID(hwnd,FID_CLIENT);         //For Now

 hps = facet->GetCanvas()->GetPlatformCanvas();
 clipShape->CopyFrom(facet->GetAggregateClipShape());
 hrgnClip = clipShape->Transform(facet->GetContentTransform())->GetQDRegion();
 ptl= facet->GetContentTransform()->TransformPoint(XMPPoint(0,0)).AsPOINTL();

  GpiSavePS(hps);
 _proxy->draw(hwnd,hps,&ptl,hrgnClip);
  GpiRestorePS(hps,-1);
  delete clipShape;
}


//-------------------------------------------------------------------------
// Draw: XMPFacet method, invalidShape is in frame coordinates
//-------------------------------------------------------------------------
void sws_txtp:: Draw(XMPFacet* facet, XMPShape* invalidShape)
{
 this->display(facet);
}





//-------------------------------------------------------------------------
// ContainingPartPropertiesChanged:
//-------------------------------------------------------------------------
void sws_txtp::ContainingPartPropertiesChanged(XMPFrame* displayFrame,
                                     XMPStorageUnit* propertyUnit)
{
 XMPUnused(displayFrame);
 XMPUnused(propertyUnit);
}


//-------------------------------------------------------------------------
// GetContainingPartProperties: XMPPart method, inform changes of
//                              content properties of its proxy for this
//                              part.
//-------------------------------------------------------------------------
XMPStorageUnit* sws_txtp::GetContainingPartProperties(XMPFrame* displayFrame)
{
   XMPUnused(displayFrame);
   THROW(kXMPErrCannotEmbed);
   return nil;
}



//-------------------------------------------------------------------------
// RevealFrame: XMPPart method, asking a part to make an embedded frame
//              visible.
//-------------------------------------------------------------------------
void sws_txtp::RevealFrame(XMPFrame* embeddedFrame)
{
 XMPUnused(embeddedFrame);

  THROW(kXMPErrCannotEmbed);
}


//-------------------------------------------------------------------------
// EmbeddedFrameSpec: XMPPart method, create object specifier for embedded
//                    frame.
//-------------------------------------------------------------------------
void sws_txtp::EmbeddedFrameSpec(XMPFrame* embeddedFrame, XMPObjectSpec* spec)
{
  XMPUnused(embeddedFrame);
  XMPUnused(spec);

  THROW(kXMPErrCannotEmbed);
}


//-------------------------------------------------------------------------
// CreateEmbeddedFrameIterator: XMPPart method,
//                              Create an object which will iterate all
//                              embedded frame sof this part.
//-------------------------------------------------------------------------
XMPEmbeddedFramesIterator* sws_txtp::CreateEmbeddedFramesIterator()
{
   THROW(kXMPErrCannotEmbed);
   // return new XMPEmbeddedFramesIterator(this);
   return nil;
}


//-------------------------------------------------------------------------
// AddDisplayFrame:  No documentation?
//-------------------------------------------------------------------------
void sws_txtp::AddDisplayFrame(XMPFrame* frame)
{
   PartInfoRec* pInfo = new PartInfoRec;
   if (frame->IsRoot())
      pInfo->_fNeedsActivating = kXMPTrue;

   frame->SetPartInfo((XMPInfoType) pInfo);

   _fDisplayFrames->AddLast(frame);
   frame->IncrementRefCount();
}





//-------------------------------------------------------------------------
// AttachSourceFrame:   No documentation?
//-------------------------------------------------------------------------
void sws_txtp::AttachSourceFrame(XMPFrame* frame, XMPFrame* sourceFrame)
{
 XMPUnused(frame);
 XMPUnused(sourceFrame);
}



//-------------------------------------------------------------------------
// RemoveDisplayFrame:   No documentation?
//-------------------------------------------------------------------------
void sws_txtp::RemoveDisplayFrame(XMPFrame* frame)
{
   if (_fDisplayFrames->Contains(frame))
   {
      PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
      frame->SetPartInfo((XMPInfoType) kXMPNULL);
      delete pInfo;
      _fDisplayFrames->Remove(frame);
      frame->Release();
   }
   else
      THROW(kXMPErrInvalidFrame);
}



//-------------------------------------------------------------------------
// CloseDisplayFrame:  No documentation?
//-------------------------------------------------------------------------
void sws_txtp::CloseDisplayFrame(XMPFrame* frame)
{
   if (_fDisplayFrames->Contains(frame))
   {
      _fSession->GetArbitrator()->RelinquishFocusSet(_fFocusSet, frame);

      PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
      frame->SetPartInfo((XMPInfoType) kXMPNULL);
      delete pInfo;
      _fDisplayFrames->Remove(frame);
      XMPReleaseObject(frame);
   }
   else
      THROW(kXMPErrInvalidFrame);
}


//-------------------------------------------------------------------------
// FrameShapeChanged:  No documentation?
//-------------------------------------------------------------------------
void sws_txtp::FrameShapeChanged(XMPFrame* frame)
{
  this->resize( frame);
  XMPFrameFacetIterator* facets = frame->CreateFacetIterator();
  for (XMPFacet* facet = facets->First();
     facets->IsNotComplete();
     facet = facets->Next())
  {
     XMPShape* activeShape = new XMPShape;
     activeShape->CopyFrom(frame->GetUsedShape());
     facet->ChangeActiveShape(activeShape);
  }
  delete facets;
}





//-------------------------------------------------------------------------
// ViewTypeChanged:
//-------------------------------------------------------------------------
void sws_txtp::ViewTypeChanged(XMPFrame* frame)
{
 XMPUnused(frame);
}



//-------------------------------------------------------------------------
// PresentationChanged:
//-------------------------------------------------------------------------
void sws_txtp::PresentationChanged(XMPFrame* frame)
{
XMPUnused(frame);
}



//-------------------------------------------------------------------------
// 
//-------------------------------------------------------------------------
void sws_txtp::WritePartInfo(XMPPtr partInfo,
                        XMPStorageUnitView* storageUnitView)
{char text[256];

 if (!partInfo)
    return;
 XMPBoolean needsActivating = ((PartInfoRec*)partInfo)->_fNeedsActivating ||
                              ((PartInfoRec*)partInfo)->_fIsActive;
 storageUnitView->SetValue(sizeof(XMPBoolean),
                          (XMPValue)&needsActivating);
 strcpy(text,_proxy->gettextbuffer());
 unsigned len = strlen(text)+1;
 storageUnitView->SetValue(sizeof(unsigned),
                          (XMPValue)&len);
 storageUnitView->SetValue(len,
                          (XMPValue)text);
}



//-------------------------------------------------------------------------
// 
//-------------------------------------------------------------------------
XMPPtr sws_txtp::ReadPartInfo(XMPFrame* frame, 
                              XMPStorageUnitView* storageUnitView)
{PartInfoRec* partInfo;
 XMPBoolean   needsActivating;
 unsigned     len;
 char         text[256];

   XMPUnused(frame);
   if (!storageUnitView->GetSize())
      return ((XMPPtr)kXMPNULL);
   partInfo = new PartInfoRec;
   storageUnitView->GetValue(sizeof(XMPBoolean),
                             (XMPValue)&(needsActivating));
   storageUnitView->GetValue(sizeof(unsigned),
                             (XMPValue)&len);
   storageUnitView->GetValue(len,
                             (XMPValue)text);
   partInfo->_fNeedsActivating = needsActivating;
   this->SetText(text);
   return partInfo;
}


//-------------------------------------------------------------------------
// 
//-------------------------------------------------------------------------
XMPID sws_txtp::Open(XMPFrame* frame)
{
   XMPUnused(frame);
   return 0;
}





//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
XMPBoolean sws_txtp::BeginRelinquishFocus(XMPTypeToken focus,
                                 XMPFrame* ownerFrame,
                                 XMPFrame* proposedFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
XMPUnused(proposedFrame);

   return kXMPTrue;
}



//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_txtp::CommitRelinquishFocus(XMPTypeToken focus,
                              XMPFrame* ownerFrame,
                              XMPFrame* proposedFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
XMPUnused(proposedFrame);
   this-> FocusLost( focus, ownerFrame);
}


//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_txtp::AbortRelinquishFocus(XMPTypeToken focus,
                             XMPFrame* ownerFrame,
                             XMPFrame* proposedFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
XMPUnused(proposedFrame);
}


//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_txtp::FocusAcquired(XMPTypeToken focus, XMPFrame* oldOwner)
{
   if (focus == _fSelectionFocus) {
     PartInfoRec* pInfo = (PartInfoRec*) oldOwner->GetPartInfo();
     pInfo->_fIsActive = kXMPTrue;
   }
}


//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_txtp::FocusLost(XMPTypeToken focus, XMPFrame* oldOwner)
{
   if (focus == _fSelectionFocus) {
     PartInfoRec* pInfo = (PartInfoRec*) oldOwner->GetPartInfo();
     pInfo->_fIsActive = kXMPFalse;

     XMPFrameFacetIterator *facets = oldOwner->CreateFacetIterator();
     HWND hwndFrame = facets->First()->GetWindow()->GetPlatformWindow();
     HWND hwnd = WinWindowFromID(hwndFrame, FID_CLIENT);
     if (WinShowCursor(hwnd, FALSE))
        WinDestroyCursor(hwnd);
   }
}





//************ From UI Events protocol***************


XMPBoolean sws_txtp::HandleKeyDown(XMPFrame* focusFrame, XMPEventData event)
{HPS       hps;
 HRGN      hrgnClip;
 XMPFacet  *facet;
 XMPShape* clipShape = new XMPShape;
 XMPFrameFacetIterator *iter= focusFrame->CreateFacetIterator();
 POINTL    ptl;


   XMPUnused(focusFrame);
   XMPUnused(event);
   // cursor keys? !!!
   facet=iter->First();
   hps = facet->GetCanvas()->GetPlatformCanvas();
   clipShape->CopyFrom(facet->GetAggregateClipShape());
 hrgnClip = clipShape->Transform(facet->GetContentTransform())->GetQDRegion();
 ptl= facet->GetContentTransform()->TransformPoint(XMPPoint(0,0)).AsPOINTL();
   GpiSavePS(hps);  
  _proxy->processkey(hps,
                     &ptl,
                     hrgnClip,
                     event->mp1,event->mp2);
   GpiRestorePS(hps,-1);
   delete iter;
   delete clipShape;
   return kXMPFalse;
}

void sws_txtp::ActivateFrame(XMPFrame* frame)
{
   PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();

   if (!(pInfo->_fIsActive))
   {
      XMPBoolean succeeded = false;

      succeeded = _fSession->GetArbitrator()->RequestFocusSet(_fFocusSet,
                                                              frame);

      if (succeeded)
      {
         this->FocusAcquired(_fSelectionFocus, frame);
         this->FocusAcquired(_fMenuFocus, frame);
         this->FocusAcquired(_fKeyFocus, frame);
      }
   }
}



//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
XMPBoolean sws_txtp::HandleEvent(XMPEventData event, 
                                 XMPFrame* frame, 
                                 XMPFacet* facet)
{ XMPUnused(facet);
  XMPBoolean handled = kXMPFalse;

  switch( event-> what) {
     case kXMPEvtKeyDown:
     case kXMPEvtAutoKey:
         handled = this->HandleKeyDown(frame, event);
         return(handled);
     case kXMPEvtMouseDown: 
        {HPS       hps;
         HRGN      hrgnClip;
         XMPShape* clipShape = new XMPShape;
         POINTL    ptl;

         if (event->msg != WM_BUTTON1DOWN)        
             break;

         hps = facet->GetCanvas()->GetPlatformCanvas();
         clipShape->CopyFrom(facet->GetAggregateClipShape());
         hrgnClip = 
            clipShape->Transform(facet->GetContentTransform())->GetQDRegion();
         ptl= facet->GetContentTransform()->
                         TransformPoint(XMPPoint(0,0)).AsPOINTL();
         GpiSavePS(hps);
        _proxy->setcursor(LOUSHORT(event->mp1),hps,&ptl,hrgnClip);
         GpiRestorePS(hps,-1);
        }
       if (!facet->GetWindow()->IsActive())
          facet->GetWindow()->Select();
       this->ActivateFrame(frame);
     break;
  case kXMPEvtActivate:
    {
     PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
     if (SHORT1FROMMP(event->mp1) != 0){
        if (pInfo->_fNeedsActivating){
           this->ActivateFrame(frame);
           pInfo->_fNeedsActivating = kXMPFalse;
        }
      }
     else{
      if (frame==_fSession->GetArbitrator()->GetFocusOwner(_fSelectionFocus))
         pInfo->_fNeedsActivating = kXMPTrue;
      else
        pInfo->_fNeedsActivating = kXMPFalse;
      }
     }
     break;
  default :
     break;
   }
   return kXMPFalse;
}



//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_txtp::MouseEnter(XMPFacet* facet, XMPPoint where)
{
XMPUnused(facet);
XMPUnused(where);
}





//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_txtp::MouseWithin(XMPFacet* facet, XMPPoint where)
{
XMPUnused(facet);
XMPUnused(where);
}



//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_txtp::MouseLeave(XMPFacet* facet)
{
XMPUnused(facet);
}



//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_txtp::AdjustMenus(XMPFrame* frame)
{
  XMPUnused(frame);
}

