/******************************************************************************

9/27/88 jbl:  The keys are converted to a new numbering scheme for PM.
We made heavy use of the scan code before, but that's unreliable under PM.
It was even getting clumsy under DOS as we invented scan codes for pseudo-keys,
and handled them as special cases in mapkey().

PM gives us four bytes of data with a key.  A WM_CHAR message comes with
scan code, char code, and 16 bits of flags.  But it turns out that we can still
identify all keys uniquely with two bytes.  We ignore the scan code; instead
we use the char code (onw byte) if it's a character and the virutal code if
it's a virtual key.  That's one byte.  Plus the lower 8 bits only of the flags;
the higher bits are useless to us.  Actually we don't care about all the lower
8 bits; we mask with KC_CHAR | KC_VIRTUALKEY | KC_SHIFT | KC_CTRL | KC_ALT
or 0x3B.

That gives us a new keycode scheme:

   high byte of keycode = lower byte of flags & 0x3B
   if KC_VIRTUALKEY flag is on,
      low byte of keycode = virtual code
   else
      low byte of keycode = char    code

Note that some keys, like BS and TAB, are labelled as both char and virtual;
both the 1 and 2 bits are set.  The above algorithm treats those as virtual,
because it tests for the KC_VIRTUALKEY flag first.  Actually we don't need the
KC_CHAR flag bit at all; we can mask with 0x3A with the same effect.  Makes
things a little less ambiguous.

For example, 'a' gives char code 0061, virtual 0,  flags 5.  ==> keycode= 0061
            c_f1 gives char code 5E00, virtual 20, flags 16. ==> keycode= 1220

But then there's the caps-lock problem:
   shift-a            = 0841
   A with CapsLock on = 0041
We want both of those to represent 'A'.
A related problem:
   alt-w       = 2177
   alt-shift-w = 2977
We want both of those to be alt-w.
So the KC_SHIFT flag is useful only in one case, shift-virtual keys.  In all
other cases we ignore the KC_SHIFT bit.  That makes the algorithm:

   if KC_VIRTUALKEY flag is on,
      if KC_SHIFT bit is on, and KC_ALT and KC_CTRL are off,
         high byte of keycode = 0x0A.  (Shift-virtuals, leave shift bit.)
      else  -- ignore shift
         high byte of keycode = lower byte of flags & 0x32 (ignore KC_SHIFT)
      endif
      low byte of keycode  = virtual code
   else  (character)
      high byte of keycode = lower byte of flags & 0x32
      low byte of keycode  = char code
   endif


To minimize table space for the binding of keys, old E kept two one-dimensional
arrays of p-code offsets, one for extended keys and one for ASCII keys:
   typedef struct keyset_td {
      ofs_t  f[MAXSCAN-MINSCAN+1];
      ofs_t  ctrl[MAXASCII];
   } keyset_t, far *keyset_tp;

Now we keep 8 such arrays, one for each possible flag combination.  This extra
differentiation is what's really preventing the collisions and special cases we
had before.

   typedef struct keyset_td {
      ofs_t  bc[MAXCHAR-MINCHAR+1]; -- base char keys, KC_CHAR only
      ofs_t  bv[MAXVIRT];           -- base virt keys, KC_VIRTUALKEY only
      ofs_t  sv[MAXVIRT];           -- shft virt keys, KC_VIRTUALKEY and KC_SHIFT
      ofs_t  cc[MAXCHAR-MINCHAR+1]; -- ctrl char keys, KC_CHAR and KC_CTRL
      ofs_t  cv[MAXVIRT];           -- ctrl virt keys, KC_VIRTUALKEY and KC_CTRL
      ofs_t  ac[MAXCHAR-MINCHAR+1]; -- alt  char keys, KC_CTRL and KC_ALT
      ofs_t  av[MAXVIRT];           -- alt  virt keys, KC_VIRTUALKEY and KC_ALT
   } keyset_t, far *keyset_tp;

where MAXCHAR=127, MINCHAR=33 and MAXVIRT = 55 (highest virtual key =
VK_F24 = 0x37).

Note:  For simplicity we allocate the same sizes for all the character arrays.
We don't need that much space in cc[] and ac[]; there's no difference between
Ctrl-lowercase-a and Ctrl-uppercase-A.  But that would complicate the code
to save only about 120 bytes of data space.  Maybe we'll correct this later
in EPM where we'll have multiple keysets and the savings are greater.

Note 2:  The algorithm might seem kind of complex at first reading.  Understand
that the complexity comes from the fact that PM gives us many keys with very
similar codes.  It is not caused by our choice of multiple arrays, as opposed
to a tree.  Actually we ARE doing a kind of tree, with seven branches in the
top layer and 95 or 55 leaves on each branch.  The algorithm describes how
to select the branch.

Negative effect:  We can't tell PADSTAR from '*' now.  P.M. treats both as
a base character code.  (P.M. does treat ENTER and PADENTER as two
different virtual keys.)  If P.M. doesn't treat 'em different, we don't!
We could separate them if we were willing to do special cases based on scan
code as we did before, but that's messy.  Or we could go to 3-byte keycodes
by adding the scan code, but that seems like overkill just to separate 5 keys.

(Later in EPM we can solve this by adding a flag of our own to differentiate
 the pad keys, without being too special-casey.  If the scan code is 0xE0 (F0?),
 set an unused bit in the flags byte to mean "pad" virtual key.
 Add 3 small arrays, bp[MAXIPAD], cp[MAXIPAD], and ap[MAXIPAD]     :-)
 where MAXIPAD is about 15.)


Negative effect 2:  The bc[] array is smaller than its previous size 255, so
a macro can't bind one of the high graphic keys like:  def ''.  No big loss!

******************************************************************************/

#define K_SLASH            0x002F
#define K_BACKSPACE        0x0205            /* bv keys ... */
#define K_TAB              0x0206            /* .  */

/* It's tempting to rename this to K_NEWLINE since that's the name used in */
/* the PM include files.  But E has always used Enter and PadEnter.        */
#define K_ENTER            0x0208

#define K_ESC              0x020F
#define K_SPACE            0x0210
#define K_PGUP             0x0211
#define K_PGDN             0x0212
#define K_END              0x0213
#define K_HOME             0x0214
#define K_LEFT             0x0215
#define K_UP               0x0216
#define K_RIGHT            0x0217
#define K_DOWN             0x0218
#define K_PRTSC            0x0219
#define K_INS              0x021A
#define K_DEL              0x021B
#define K_PADENTER         0x021E
#define K_F1               0x0220
#define K_F2               0x0221
#define K_F3               0x0222
#define K_F4               0x0223
#define K_F5               0x0224
#define K_F6               0x0225
#define K_F7               0x0226
#define K_F8               0x0227
#define K_F9               0x0228
#define K_F10              0x0229
#define K_F11              0x022A
#define K_F12              0x022B
#define K_F13              0x022C
#define K_F14              0x022D
#define K_F15              0x022E
#define K_F16              0x022F
#define K_F17              0x0230
#define K_F18              0x0231
#define K_F19              0x0232
#define K_F20              0x0233
#define K_F21              0x0234
#define K_F22              0x0235
#define K_F23              0x0236            /* .  */
#define K_F24              0x0237            /* bv */
#define K_S_BACKSPACE      0x0A05   /* sv */
#define K_S_TAB            0x0A07   /* .  */
#define K_S_ENTER          0x0A08            /* P.M. doesn't produce this one*/
#define K_S_ESC            0x0A0F
#define K_S_SPACE          0x0A10
#define K_S_PGUP           0x0A11
#define K_S_PGDN           0x0A12
#define K_S_END            0x0A13
#define K_S_HOME           0x0A14
#define K_S_LEFT           0x0A15
#define K_S_UP             0x0A16
#define K_S_RIGHT          0x0A17
#define K_S_DOWN           0x0A18
#define K_S_PRTSC          0x0A19
#define K_S_INS            0x0A1A
#define K_S_DEL            0x0A1B
#define K_S_PADENTER       0x0A1E
#define K_S_F1             0x0A20
#define K_S_F2             0x0A21
#define K_S_F3             0x0A22
#define K_S_F4             0x0A23
#define K_S_F5             0x0A24
#define K_S_F6             0x0A25
#define K_S_F7             0x0A26
#define K_S_F8             0x0A27
#define K_S_F9             0x0A28
#define K_S_F10            0x0A29
#define K_S_F11            0x0A2A
#define K_S_F12            0x0A2B
#define K_S_F13            0x0A2C
#define K_S_F14            0x0A2D
#define K_S_F15            0x0A2E
#define K_S_F16            0x0A2F
#define K_S_F17            0x0A30
#define K_S_F18            0x0A31
#define K_S_F19            0x0A32
#define K_S_F20            0x0A33
#define K_S_F21            0x0A34
#define K_S_F22            0x0A35
#define K_S_F23            0x0A36   /* .  */
#define K_S_F24            0x0A37   /* sv */

/* Note:  We don't use any form of pad5, base, ctrl or alt.  Its base code
 * 0x0000, so we'd have to extend the origin of our character arrays all
 * the way down to 0 instead of 33, wasting 33*2*3 bytes per keyset.  Later
 * in EPM we can waste that space, or invent new "pad" keys as noted above.
 */
#define K_C_PAD5           0x1000            /* cc */
#define K_C_QUOTE          0x1027            /* .  */
#define K_C_COMMA          0x102C
#define K_C_MINUS          0x102D   /* Same as C_PADMINUS now. */
#define K_C_PERIOD         0x102E
#define K_C_SLASH          0x102F
#define K_C_0              0x1030
#define K_C_1              0x1031
#define K_C_2              0x1032
#define K_C_3              0x1033
#define K_C_4              0x1034
#define K_C_5              0x1035
#define K_C_6              0x1036
#define K_C_7              0x1037
#define K_C_8              0x1038
#define K_C_9              0x1039
#define K_C_SEMICOLON      0x103B
#define K_C_EQUAL          0x103D
#define K_C_LEFTBRACKET    0x105B
#define K_C_BACKSLASH      0x105C
#define K_C_RIGHTBRACKET   0x105D
#define K_C_A              0x1061
#define K_C_B              0x1062
#define K_C_C              0x1063
#define K_C_D              0x1064
#define K_C_E              0x1065
#define K_C_F              0x1066
#define K_C_G              0x1067
#define K_C_H              0x1068
#define K_C_I              0x1069
#define K_C_J              0x106A
#define K_C_K              0x106B
#define K_C_L              0x106C
#define K_C_M              0x106D
#define K_C_N              0x106E
#define K_C_O              0x106F
#define K_C_P              0x1070
#define K_C_Q              0x1071
#define K_C_R              0x1072
#define K_C_S              0x1073
#define K_C_T              0x1074
#define K_C_U              0x1075
#define K_C_V              0x1076
#define K_C_W              0x1077
#define K_C_X              0x1078
#define K_C_Y              0x1079            /* .  */
#define K_C_Z              0x107A            /* cc */
#define K_C_BACKSPACE      0x1205   /* cv */
#define K_C_TAB            0x0206   /* .  */
#define K_C_ENTER          0x1208
#define K_C_PGUP           0x1211
#define K_C_PGDN           0x1212
#define K_C_END            0x1213
#define K_C_HOME           0x1214
#define K_C_LEFT           0x1215
#define K_C_UP             0x1216
#define K_C_RIGHT          0x1217
#define K_C_DOWN           0x1218
#define K_C_PRTSC          0x1219
#define K_C_INS            0x121A
#define K_C_DEL            0x121B
#define K_C_PADENTER       0x121E
#define K_C_F1             0x1220
#define K_C_F2             0x1221
#define K_C_F3             0x1222
#define K_C_F4             0x1223
#define K_C_F5             0x1224
#define K_C_F6             0x1225
#define K_C_F7             0x1226
#define K_C_F8             0x1227
#define K_C_F9             0x1228
#define K_C_F10            0x1229
#define K_C_F11            0x122A
#define K_C_F12            0x122B
#define K_C_F13            0x122C
#define K_C_F14            0x122D
#define K_C_F15            0x122E
#define K_C_F16            0x122F
#define K_C_F17            0x1230
#define K_C_F18            0x1231
#define K_C_F19            0x1232
#define K_C_F20            0x1233
#define K_C_F21            0x1234
#define K_C_F22            0x1235
#define K_C_F23            0x1236   /* .  */
#define K_C_F24            0x1237   /* cv */
#define K_A_QUOTE          0x2027            /* ac */
#define K_A_PERIOD         0x202C            /* .  */
#define K_A_MINUS          0x202D
#define K_A_COMMA          0x202E
#define K_A_SLASH          0x202F
#define K_A_PADSLASH       0x202F
#define K_A_0              0x2030
#define K_A_1              0x2031
#define K_A_2              0x2032
#define K_A_3              0x2033
#define K_A_4              0x2034
#define K_A_5              0x2035
#define K_A_6              0x2036
#define K_A_7              0x2037
#define K_A_8              0x2038
#define K_A_9              0x2039
#define K_A_SEMICOLON      0x203B
#define K_A_EQUAL          0x203D
#define K_A_LEFTBRACKET    0x205B
#define K_A_BACKSLASH      0x205C
#define K_A_RIGHTBRACKET   0x205D
#define K_A_A              0x2061
#define K_A_B              0x2062
#define K_A_C              0x2063
#define K_A_D              0x2064
#define K_A_E              0x2065
#define K_A_F              0x2066
#define K_A_G              0x2067
#define K_A_H              0x2068
#define K_A_I              0x2069
#define K_A_J              0x206A
#define K_A_K              0x206B
#define K_A_L              0x206C
#define K_A_M              0x206D
#define K_A_N              0x206E
#define K_A_O              0x206F
#define K_A_P              0x2070
#define K_A_Q              0x2071
#define K_A_R              0x2072
#define K_A_S              0x2073
#define K_A_T              0x2074
#define K_A_U              0x2075
#define K_A_V              0x2076
#define K_A_W              0x2077
#define K_A_X              0x2078
#define K_A_Y              0x2079            /* .  */
#define K_A_Z              0x207A            /* ac */
#define K_A_BACKSPACE      0x2205   /* av */
#define K_A_TAB            0x2206   /* .  */
#define K_A_ENTER          0x2208
#define K_A_SPACE          0x2210
#define K_A_PGUP           0x2211
#define K_A_PGDN           0x2212
#define K_A_END            0x2213
#define K_A_HOME           0x2214
#define K_A_LEFT           0x2215
#define K_A_UP             0x2216
#define K_A_RIGHT          0x2217
#define K_A_DOWN           0x2218
#define K_A_PRTSC          0x2219
#define K_A_INS            0x221A
#define K_A_DEL            0x221B
#define K_A_PADENTER       0x221E
#define K_A_F1             0x2220
#define K_A_F2             0x2221
#define K_A_F3             0x2222
#define K_A_F4             0x2223
#define K_A_F5             0x2224
#define K_A_F6             0x2225
#define K_A_F7             0x2226
#define K_A_F8             0x2227
#define K_A_F9             0x2228
#define K_A_F10            0x2229
#define K_A_F11            0x222A
#define K_A_F12            0x222B
#define K_A_F13            0x222C
#define K_A_F14            0x222D
#define K_A_F15            0x222E
#define K_A_F16            0x222F
#define K_A_F17            0x2230
#define K_A_F18            0x2231
#define K_A_F19            0x2232
#define K_A_F20            0x2233
#define K_A_F21            0x2234
#define K_A_F22            0x2235
#define K_A_F23            0x2236   /* .  */
#define K_A_F24            0x2237   /* av */

/*
Ŀ
 What does it do :  The following definitions define pseudo-keys that are   
                    used to integrate mouse action into the Presentation    
                    Manager verion of the E editor.                         
                                                                            
 Discribe it     :                                                          
                                                                            
 KEY                 PM Message       Definition                            
 ----------------    -------------    ---------------------                 
 MOUSE_MOVE          WM_MOUSEMOVE     Mouse has been moved in client window.
 MOUSE_BUT1DOWN      WM_BUTTON1DOWN   Left button of mouse is down.         
 MOUSE_BUT1UP        WM_BUTTON1UP      "     "    "    "    " up.           
 MOUSE_BUT1DCLK      WM_BUTTON1DBLCLK Left button double clicked.           
 MOUSE_BUT2DOWN      WM_BUTTON2DOWN   Right button of mouse is down.        
 MOUSE_BUT2UP        WM_BUTTON2UP       "     "    "    "    " up.          
 MOUSE_BUT2DCLK      WM_BUTTON2DBLCLK Right button double clicked.          
 MOUSE_BUT3DOWN      WM_BUTTON3DOWN   Middle button ( I have not encountered
 MOUSE_BUT3UP        WM_BUTTON3UP                     a mouse with 3 buttons
 MOUSE_BUT3DCLK      WM_BUTTON3DBLCLK            yet but we have support.)  
                                                                            
 Who and when    : Gennaro (Jerry) Cuomo   6-88                             

*/
#define MOUSE_MOVE      0x0400
#define MOUSE_BUT1DOWN  0x0500
#define MOUSE_BUT1UP    0x0600
#define MOUSE_BUT1DCLK  0x0700
#define MOUSE_BUT2DOWN  0x0800
#define MOUSE_BUT2UP    0x0900
#define MOUSE_BUT2DCLK  0x0A00
#define MOUSE_BUT3DOWN  0x0B00
#define MOUSE_BUT3UP    0x0C00
#define MOUSE_BUT3DCLK  0x0D00

