/*************************************************************************
** Copyright Classification:
**
** Copyright (C) International Business Machines Corp., 1994.             
**                                                                        
**                                                                        
** DISCLAIMER OF WARRANTIES:                                              
** -------------------------                                              
** The following [enclosed] code is sample code created by IBM            
** Corporation.  This sample code is not part of any standard IBM product 
** and is provided to you solely for the purpose of assisting you in the  
** development of your applications.  The code is provided "AS IS",       
** without warranty of any kind.  IBM shall not be liable for any damages 
** arising out of your use of the sample code, even if they have been     
** advised of the possibility of such damages.                            
**
** Purpose: class sws_txtd Methods
**    Spec: draw class for text data
**          ESCAPE key switches drawing modes to LEAVEALONE from
**          OVERPAINT
**--------------------------------------------------------------------
**
** Change Activity:  
**   15May94 Created: redpath
***********************************************************************/
#include "swstxtd.hpp"
#include "swstxtks.h"               //Keys defined

#include <stdio.h>
#include <memory.h>
#include <string.h>

extern void  myprintf(char *format);
ULONG painttype=BM_OVERPAINT;

#ifdef _BORLAND_
extern int _multidll=1;
#endif

static void reverse(char     *in,
                   char     *out,
                   int      len)
{int i,j;                                          /*                      */
                                                   /*                      */
 j = len;                                          /*                      */
 out[j--] = 0;                                     /*                      */
 for (i=0; i<len; i++)                             /*For loop through.     */
    out[j--]=in[i];                                /*                      */
}                                                  /*                      */





void replacecaret(HWND          hwnd,
                  USHORT        stylebits,
                  unsigned int  width,
                  unsigned int  height,
                  unsigned int  x,
	          unsigned int  y)
{HWND client;

 if (WinShowCursor( WinQueryFocus(HWND_DESKTOP),FALSE) )
        WinDestroyCursor(WinQueryFocus(HWND_DESKTOP));

 WinSetFocus( HWND_DESKTOP, hwnd );
 WinCreateCursor(hwnd,
                 x,y,
                 width,height,
                 stylebits,
                 (PRECTL)0);
 WinShowCursor(hwnd,TRUE);
}



void  gettextlength(TEXTAREA *textarea,
                     char     *string,
                     int      len,
                     int      *width,
                     int      *height)

{POINTL      point[5];

 GpiQueryTextBox(textarea->hps,
                 (LONG)len, 
                 (PCH)string,
                 (LONG)5L,
                 (PPOINTL)point);
 *width  = point[2].x- point[0].x;
 *height = point[0].y- point[3].y;
}






/*************************************************
 [Abstract]
   _HeightWidthText: Find height and width of a
                     text string.
   SPECS: returns the width and height in a unsigned
          long, HPS should be setup with font.
*************************************************/
ULONG  _HeightWidthText(TEXTAREA *textarea,
                        char     *string,
                        int      first,    
                        int      last)     
{ULONG   size;  
 int     h,w;


    if (last-first > 0)                           /*Is there more than one*/
       gettextlength(textarea,                    /*character and if so   */
                      string+first,               /*get the text width    */
                      last-first,                 /*and height            */
                      &w,   
                      &h);  
    else                                           /*A single character    */
       {                                           /*get its size          */
        w =0;
        h=textarea->fm.lMaxDescender + textarea->fm.lMaxAscender;
      }                                            /*                      */
  size= MAKEULONG(w,h);
  return(size);                                    /*Return the width and  */
}                                                  /*height in a long.     */





/**************************************************  
 [Abstract]
    _CountChars: Count characters to fit in a 
                 pixel boxed area.
**************************************************/
int _CountChars(TEXTAREA *textarea,
                char     *string,
                int       start, int pixels,int mode) 
                                                   /* mode = 1 : increase  */
                                                   /* mode = 0 : decrease  */
{int    i;                                         /*                      */
 ULONG  size=0;                                    /*                      */
                                                   /*Set starting place of */
  i = start;                                       /*string. If mode is 1  */
  if (mode){                                       /*go forward otherwise  */
    do {                                           /*go backwards.         */
      if (string[i]==0)
         break;
      size=_HeightWidthText(textarea,string,start,i++);
    } while (LOUSHORT(size) < pixels );            /*                      */
  } else {                                         /*                      */
    do {                                           /*                      */
      if (start==0)
         break;
      size=_HeightWidthText(textarea,string,start--,i);
    } while (LOUSHORT(size) < pixels );            /*                      */
  }                                                /*                      */
                                                   /*Return the total      */
  return(i - start -2);                            /*number of chars that  */
}                                                  /*will fit in box.      */





void movecursor(TEXTAREA *textarea)
{ULONG          size; 
 HWND           client;

  size=_HeightWidthText(textarea,                  /*Compute Cursor        */
                        textarea->userbuffer,      /*Coordinate position.  */
                        textarea->first_pos,       /*                      */
                        textarea->curr_pos);       /*                      */
  client=textarea->hwnd;

  if (textarea->rightleft)                         /*If right-to-left mode */
     WinCreateCursor(client,                       /*Put cursor from right */
          textarea->origx +textarea->box.xRight-LOUSHORT(size)-2, 
          textarea->origy +2,
                     (textarea->insertmode)?6:3,
       (textarea->box.yTop-textarea->box.yBottom)/(textarea->insertmode+1),
                     CURSOR_SETPOS,                /*                      */
                     (PRECTL)0);                   /*                      */
  else                                             /*Otherwise just put    */
     WinCreateCursor(client,                       /*cursor from left.     */
          textarea->origx +LOUSHORT(size)+2, 
          textarea->origy +2,
                     (textarea->insertmode)?6:3,
       (textarea->box.yTop-textarea->box.yBottom)/(textarea->insertmode+1),
                     CURSOR_SETPOS,                /*                      */
                     (PRECTL)0);                   /*                      */
  WinShowCursor(client,TRUE);                      /*Show the cursor,      */
}





/***************************************************
[ABSTRACT]
   InputKey: A key has been given to TextArea 
***************************************************/
                                                  /*                      */
int InputKey(TEXTAREA *textarea, 
             UINT      key)
{POINTL         point;                             /*                      */
 int            i, printlen, reprint = 1, maxlen;  /*                      */
 ULONG          size;                              /*                      */
 HWND           client;
 ULONG          length;                            /*                      */
 RECTL          update;
                                                   /*                      */
                                                   /*                      */
/**********
Does Not Work Well:
    insertmode =  WinQueryKeyState(HWND_DESKTOP,VK_INSERT) & 0x0001;
************/
                                                   /*                      */


  if ( (key==K_S_SPACE) ||   
       (key == K_SPACE)    )                       /*If a space key was    */
      key = 0x0020;                                /*pressed assign it one */
                                                   /*value to represent a  */
                                                   /*space key.            */
                                                   /*                      */
  if ( (textarea->rightleft) &&                    /*Reverse right and left*/
       ( (key==K_LEFT) || (key==K_RIGHT) )         /*keys if text area has */
     )                                             /*right-to-left on to   */
    {                                              /*give the right-left   */
      if (key==K_LEFT) key = K_RIGHT;              /*results.              */
      else                                         /*                      */
          if (key==K_RIGHT) key = K_LEFT;          /*                      */
     }                                             /*                      */
                                                   /*                      */
  switch (key) {                                   /*Switch on the key.    */
    case 0:  
       break;
    case K_ESC:  
       painttype=(painttype==BM_LEAVEALONE)?BM_OVERPAINT:BM_LEAVEALONE;
       break;
    case K_LEFT:                                   /*If left key,          */
       if (textarea->curr_pos > 0)                 /*and position is       */
          {                                        /*greater than zero.    */
           textarea->curr_pos--;                   /*so move left in the   */
           if (textarea->curr_pos < textarea->first_pos)  /*text buffer.   */
               textarea->first_pos--;              /*                      */
           else                                    /*                      */
               reprint = 0;                        /*                      */
          }                                        /*                      */
       else                                        /*Cannot move left      */
          return(1);                               /*already at start of   */
       break;                                      /*buffer.               */
    case K_RIGHT:                                  /*If Right Arrow Key    */
        if (textarea->curr_pos < textarea->buffer_len_p) /*move right     */
           {                                       /*at end of text buffer */
            textarea->curr_pos++;                  /*buffer already        */
            if ( LOUSHORT(_HeightWidthText(textarea,
                                           textarea->userbuffer,
                                           textarea->first_pos,
                                   textarea->curr_pos)) < textarea->area_len )
                   reprint = 0;                    /*                      */
            }                                      /*                      */
        else                                       /*                      */
          return(1);                               /*                      */
        break;                                     /*                      */
    case K_HOME:                                   /*current buffer positio*/
        textarea->curr_pos  = 0;                   /*n to zero.            */
        textarea->first_pos = 0;                   /*                      */
        break;                                     /*                      */
    case K_END:                                    /*Jump to end of buffer.*/
        textarea->curr_pos  = textarea->buffer_len_p; 
        textarea->first_pos = textarea->curr_pos - _CountChars(textarea,
                                                       textarea->userbuffer,
                                                       textarea->curr_pos,
                                                       textarea->area_len,
                                                       0);
        if (textarea->first_pos < 0)               /*                      */
             textarea->first_pos = 0;              /*                      */
        break;                                     /*                      */
    case K_INS:                                    /*                      */
        size = _HeightWidthText(textarea,          /*                      */
                                textarea->userbuffer,
                                textarea->first_pos, 
                                textarea->curr_pos); 
        if (textarea->rightleft)                   /*                      */
           length = textarea->box.xRight-LOUSHORT(size)-2; 
        else                                       /*                      */
           length = LOUSHORT(size)+2;              /*                      */
        textarea->insertmode = (textarea->insertmode)?0:1; /*Tog insertmode */
                                                   /*flag and reset the    */
                                                   /*thickness of the      */
                                                   /*cursor to reflect the */
                                                   /*the mode.             */
        replacecaret(textarea->hwnd,
                     CURSOR_SOLID|CURSOR_FLASH,    
                     (textarea->insertmode)?6:3,
       (textarea->box.yTop-textarea->box.yBottom)/(textarea->insertmode+1),
                     textarea->origx+length,textarea->origy+2);
        return(1);                                 /*                      */
    case K_DEL:                                    /*Remove a character in */ 
        if (textarea->curr_pos < textarea->buffer_len_p)/*text buffer by  */
           {                                       /*copying over it with  */
            (textarea->buffer_len_p)--;           /*FOR loop.             */
            for (i = textarea->curr_pos; i < textarea->buffer_len_p; i++)
                 textarea->userbuffer[i] = textarea->userbuffer[i+1];
            textarea->userbuffer[textarea->buffer_len_p]=0; /*NULL term it*/
            }                                      /*                      */
        else                                       /*                      */
          return(1);                               /*                      */
        break;                                     /*                      */
    case K_S_BACKSPACE:
    case K_BACKSPACE:                              /*BACKSPACE key,        */
        if (textarea->curr_pos > 0)                /*If current position is*/
           {                                       /*greater than zero.    */
            (textarea->buffer_len_p)--;           /*Then backspace can be */
             textarea->curr_pos--;                 /*done. Copy buffer onto*/
             for (i = textarea->curr_pos; i < textarea->buffer_len_p; i++)
                 textarea->userbuffer[i] = textarea->userbuffer[i+1];
                                                   /*NULL term it          */
                                                   /*itself remove the     */
                                                   /*character.            */
             textarea->userbuffer[textarea->buffer_len_p]=0;
             if (textarea->curr_pos <=textarea->first_pos){
                textarea->first_pos-=_CountChars(textarea,
                                             textarea->userbuffer,
                                             textarea->curr_pos,
                                             textarea->area_len,0);
                if (textarea->first_pos>=textarea->curr_pos)
                    textarea->first_pos=0;
                }
             if (textarea->first_pos < 0)          /*Set first position to */
                 textarea->first_pos = 0;          /*start displaying of   */
           }                                       /*buffer.               */
        break;                                     /*                      */
    default:
             if (HIBYTE(key)!=0)                   /*Not an Editing Key.   */
                  return(0);                       /*Check the VK code  to */
                                                   /*see if its an ASCII   */
                                                   /*key. Add Key to buffer*/
                                                   /*                      */
                                                   /*                      */
                                                   /*Someone updated the   */
if (textarea->curr_pos>textarea->buffer_len_p)    /*buffer so correct for */
    {                                              /*it.                   */
     textarea->curr_pos  = textarea->buffer_len_p;/*Jump to end of buffer.*/
     textarea->first_pos = textarea->curr_pos - _CountChars(textarea,
                                                    textarea->userbuffer,
                                                    textarea->curr_pos,
                                                    textarea->area_len,
                                                    0);
     if (textarea->first_pos < 0)                  /*                      */
         textarea->first_pos = 0;                  /*                      */
    }                                              /*                      */

if ( (textarea->insertmode) || 
     (textarea->curr_pos == textarea->buffer_len_p) )
   {                                                /*if the buffer is not  */
    if (textarea->buffer_len_p == textarea->buffermax){
       DosBeep(100,100);                           /*BEEP for              */
       return(1);                                  /*full already.         */
      }
    (textarea->buffer_len_p)++;                   /*                      */
    textarea->userbuffer[textarea->buffer_len_p]=0; /*NULL terminate*/
    if (textarea->insertmode)                      /*If insert mode add it */
                                                   /*at position,          */
      for (i = textarea->buffer_len_p; i > textarea->curr_pos; i--)
         textarea->userbuffer[i] = textarea->userbuffer[i-1];
   }                                   /*Put character in Buf  */
  textarea->userbuffer[textarea->curr_pos++] = LOUCHAR(key); /*Fill buf*/
}                                                  /* END OF SWITCH        */
                                                   /*                      */
                                                   /*                      */
                                                   /*                      */
                                                   /*Display the buffer    */
 if (LOUSHORT(_HeightWidthText(textarea,           /*Check if Text is >    */
                             textarea->userbuffer, /*than the display      */
                              textarea->first_pos, /*window. If it is      */
                              textarea->curr_pos)) >= textarea->area_len)
      textarea->first_pos = textarea->curr_pos -   /*Count how many chars  */
                       _CountChars(textarea,       /*that can fit to       */
                               textarea->userbuffer,/*display the text.     */
                               textarea->curr_pos, /*                      */
                               textarea->area_len, /*                      */
                               0);                 /*                      */
                                                   /*                      */
  size=_HeightWidthText(textarea,                  /*Get size of Text      */
                        textarea->userbuffer,      /*string to display.    */
                        textarea->first_pos,       /*                      */
                        textarea->curr_pos);       /*                      */
                                                   /*                      */
  if (reprint)                                     /*If reprint flag was   */
     {                                             /*set, redisplay the    */
      maxlen = LOUSHORT(_HeightWidthText(textarea, /*text.                 */
                                       textarea->userbuffer,
                                       textarea->first_pos,
                                       textarea->buffer_len_p));
      if (maxlen > textarea->area_len)             /*Compute How Many      */
          printlen = _CountChars(textarea,          /*characters you can    */
                              textarea->userbuffer, /*display.              */
                              textarea->first_pos,  /*                      */
                              textarea->area_len,   /*                      */
                              1);                   /*                      */
      else                                         /*                      */
          printlen =                               /*                      */
             (textarea->buffer_len_p)-textarea->first_pos;
                                                   /*                      */
                                                   /*                      */
      client=textarea->hwnd;
      WinShowCursor(client,FALSE);                 /*HIDE the cursor       */
      update=textarea->box;
      update.xRight+= textarea->origx;
      update.xLeft += textarea->origx;
      update.yTop  += textarea->origy;
      update.yBottom+=textarea->origy;


      if (painttype==BM_LEAVEALONE){
        if (key!=0){
           WinInvalidateRect(textarea->hwnd,&update,TRUE); //Kerning  you
           movecursor(textarea);                           //must inval all
           return(1);
          }     
        }
      else
        WinFillRect(textarea->hps,&update,CLR_WHITE);

       point.y= textarea->origy;
       if (textarea->rightleft)                   /*If right-to-left      */
         {                                         /*reverse the string    */
#ifdef NOWAY
          reverse(textarea->userbuffer+textarea->first_pos,
                  (char far *)out, 
                  printlen);       
          length = (unsigned int)                  /*Get the height of the */
                   _HeightWidthText(textarea,      /*string (low word of   */
                                    (PSZ)out,      /*long).                */
                                    0,             /*                      */
                                    printlen);     /*                      */
          point.x = textarea->box.xRight-length-2; /*Set coordinates up.   */
          GpiCharStringAt( hps, (PPOINTL)&point,   /*Draw the string.      */
                           (LONG)printlen,         /*                      */
                           (PSZ)out);              /*                      */
#endif
         }                                         /*                      */
        else                                       /*Do not reverse string */
         {                                         /*just redraw it,       */
          point.x = textarea->origx; 
          point.y=  textarea->origy;  
          GpiCharStringAt( textarea->hps,
                          (PPOINTL)&point,         /*                      */
                          (LONG)printlen,          /*                      */
                          (PSZ)(textarea->userbuffer + textarea->first_pos) );
         }                                         /*                      */
  }                                                /*                      */
  movecursor(textarea);
  return(1);                                       /*                      */
}                                                  /*                      */
                                                   /*                      */
                                                   /*                      */




unsigned int KeyPad(UCHAR flags,
                    UCHAR chr)
{
  if (flags&KC_CHAR)
     {
      if ( (chr>=0x30) && (chr<=0x39))
         return(chr);
      if (chr==0x2E)
         return(chr);
     }
  return(0);
}




void sws_txtd::processkey(HPS       hps,
                          POINTL   *ptl,
                          HRGN      hrgnClip,
                          MPARAM    pm1,
                          MPARAM    pm2)
{UCHAR            flags, chr, virt;
 UCHAR            highbyte, lowbyte;
 static UINT      keycode;                        /*Remember key.     */
 static UINT      repeat=0;                       /*Static to cause   */

  if (((ULONG)pm1)&KC_KEYUP)          /*upstate and ignore*/
      return;

  flags = LOUCHAR(LOUSHORT(pm1));
  chr   = LOUCHAR(LOUSHORT(pm2));
  virt  = (UCHAR)HIUSHORT(pm2);
  if (flags & KC_VIRTUALKEY) {
     if ( (flags & (KC_SHIFT|KC_ALT|KC_CTRL)) == KC_SHIFT ) 
       highbyte = 0x0A;
     else 
       highbyte = flags & (KC_ALT | KC_CTRL | KC_VIRTUALKEY);
       lowbyte = virt;
     }
  else 
    {
     highbyte = flags & (KC_ALT | KC_CTRL | KC_VIRTUALKEY);
     lowbyte = chr;
    }
  if ((keycode=KeyPad(flags,chr))==0)
     keycode = (highbyte<<8) | lowbyte;

    repeat  = LOUCHAR(HIUSHORT(pm1))-1;
{HRGN   hrgnSave;
 SIZEF size;

   _textarea.origx= ptl->x;
   _textarea.origy= ptl->y;
   _textarea.hps  = hps;

   GpiSetClipRegion(hps,hrgnClip,&hrgnSave);
   GpiCreateLogColorTable(hps,0,LCOLF_RGB,0,0,(PLONG)0);
   GpiCreateLogFont(hps,(PSTR8)0,1,&_textarea.fat);
   GpiSetBackMix(hps,(LONG)painttype);
   GpiSetColor(hps,_textarea.colortext);
   GpiSetBackColor(hps,_textarea.backtext);
   GpiSetCharSet(hps,1);
   size.cx = MAKEFIXED(_textarea.box.yTop,0);
   size.cy = MAKEFIXED(_textarea.box.yTop,0);
   GpiSetCharBox(hps,&size);
   GpiSetTextAlignment(hps,TA_NORMAL_HORIZ,TA_BOTTOM);
   InputKey(&_textarea,keycode);
   GpiSetClipRegion(hps,hrgnSave,&hrgnClip);
  }
}






/****************************************************************
 DefaultOutlineFont: Find an outline font and one which is
                     proportional so it can be resized in the
                     edit text box and also demonstrate proportional
                     support.
****************************************************************/
void DefaultOutlineFont(TEXTAREA *textarea)
{static FONTMETRICS fm[80];
 LONG ltemp=0;
 LONG cFonts=0;
 int     i;
 
 memset(&textarea->fat,0,sizeof(FATTRS));
 GpiLoadFonts(WinQueryAnchorBlock(HWND_DESKTOP),"helv");
 cFonts= GpiQueryFonts(textarea->hps,QF_PUBLIC|QF_PRIVATE,"Helv",&ltemp,
               sizeof(FONTMETRICS),(PFONTMETRICS)0);
 if (cFonts>sizeof(fm)/sizeof(FONTMETRICS))
   cFonts=sizeof(fm)/sizeof(FONTMETRICS);
 GpiQueryFonts(textarea->hps,QF_PUBLIC|QF_PRIVATE,"Helv",&cFonts,
               sizeof(FONTMETRICS),fm);
 for (i=0; (!(fm[i].fsDefn&FM_DEFN_OUTLINE)) &&     //find outline and
           (!(fm[i].fsType&FM_TYPE_KERNING))  &&    //kerned if can
           (i<cFonts); i++);
 if (i==cFonts)
   for (i=0; (!(fm[i].fsDefn&FM_DEFN_OUTLINE))&&  // Find outline atleast
             (i<cFonts); i++);
 if (i==cFonts)
   i=0;
 textarea->fm                 = fm[i];
 textarea->fat.usRecordLength =sizeof(FATTRS);
 textarea->fat.lMatch         =fm[i].lMatch;
 textarea->fat.lMatch         =0;
 textarea->fat.fsFontUse      = FATTR_FONTUSE_OUTLINE;
 strcpy(textarea->fat.szFacename,fm[i].szFacename);
}




sws_txtd::sws_txtd(void)
{
  memset(&_textarea,0,sizeof(_textarea));
 _textarea.buffermax        = sizeof(_textarea.userbuffer);
 _textarea.colortext        = RGB_BLACK;
 _textarea.backtext         = RGB_WHITE;
 _textarea.hps              = WinGetScreenPS(HWND_DESKTOP);
  DefaultOutlineFont(&_textarea);
  strcpy(_textarea.userbuffer,"r");
 _textarea.curr_pos    = 1;
 _textarea.buffer_len_p= 1;
  this->_textarea.hwnd = HWND_DESKTOP;
}


sws_txtd::~sws_txtd(void)
{
}


void sws_txtd::size(RECTL *rclFrame)
{
  memcpy(&_textarea.box,rclFrame,sizeof(RECTL));
 _textarea.area_len= _textarea.box.xRight-_textarea.box.xLeft;
  if (_textarea.hwnd)
    WinShowCursor(_textarea.hwnd,FALSE);       /*HIDE the cursor       */
}



void sws_txtd::draw(HWND    hwnd,
                    HPS     hps,
                    POINTL *ptl,
                    HRGN    hrgnClip)
{HRGN   hrgnSave;
 SIZEF size;
 char buffer[100];

   _textarea.origx= ptl->x;
   _textarea.origy= ptl->y;
   _textarea.hps  = hps;
   _textarea.hwnd = hwnd;

   GpiCreateLogColorTable(hps,0,LCOLF_RGB,0,0,(PLONG)0);
   GpiCreateLogFont(hps,(PSTR8)0,1,&_textarea.fat);
   GpiSetBackMix(hps,(LONG)painttype);
   GpiSetColor(hps,_textarea.colortext);
   GpiSetBackColor(hps,_textarea.backtext);
   GpiSetCharSet(hps,1);
   size.cx = MAKEFIXED(_textarea.box.yTop,0);
   size.cy = MAKEFIXED(_textarea.box.yTop,0);
   GpiSetCharBox(hps,&size);
   GpiSetClipRegion(hps,hrgnClip,&hrgnSave);
   GpiSetTextAlignment(hps,TA_NORMAL_HORIZ,TA_BOTTOM);
   InputKey(&_textarea,0);
   GpiSetClipRegion(hps,hrgnSave,&hrgnClip);
}


void sws_txtd::setcursor(int     x,
                         HPS     hps,
                         POINTL *ptl,
                         HRGN    hrgnClip)
{HRGN   hrgnSave;
 SIZEF sizef;
 ULONG  length;
 HWND client;
 int  pos,maxlen;

   _textarea.origx= ptl->x;
   _textarea.origy= ptl->y;
   _textarea.hps  = hps;

   GpiCreateLogColorTable(hps,0,LCOLF_RGB,0,0,(PLONG)0);
   GpiCreateLogFont(hps,(PSTR8)0,1,&_textarea.fat);
   GpiSetBackMix(hps,(LONG)painttype);
   GpiSetColor(hps,_textarea.colortext);
   GpiSetBackColor(hps,_textarea.backtext);
   GpiSetCharSet(hps,1);
   sizef.cx = MAKEFIXED(_textarea.box.yTop,0);
   sizef.cy = MAKEFIXED(_textarea.box.yTop,0);
   GpiSetCharBox(hps,&sizef);
   GpiSetClipRegion(hps,hrgnClip,&hrgnSave);
   GpiSetTextAlignment(hps,TA_NORMAL_HORIZ,TA_BOTTOM);

   if (_textarea.rightleft) {
      x = _textarea.box.xRight-x; 
      if (x<0) 
         x=0;
      }
    x -= _textarea.origx;
    pos    = _textarea.first_pos;
    maxlen = LOUSHORT(_HeightWidthText(&_textarea,
                                       _textarea.userbuffer,
                                       _textarea.first_pos,
                                       _textarea.buffer_len_p));
     do {
          length = _HeightWidthText(&_textarea,
                                  _textarea.userbuffer,
                                  _textarea.first_pos,
                                  pos++);
       } while ( (LOUSHORT(length)+2 < x) && (LOUSHORT(length)+2 < maxlen) ); 
      length = LOUSHORT(_HeightWidthText(&_textarea,
                              _textarea.userbuffer,
                              _textarea.first_pos,
                              pos-1))+2;

     replacecaret(_textarea.hwnd,
                  CURSOR_SOLID|CURSOR_FLASH,    
                  (_textarea.insertmode)?6:3,
       (_textarea.box.yTop-_textarea.box.yBottom)/(_textarea.insertmode+1),
                  _textarea.origx+length,_textarea.origy+2);
   _textarea.curr_pos = pos-1;
   GpiSetClipRegion(hps,hrgnSave,&hrgnClip);
}


char *sws_txtd::gettextbuffer()
{
 return(_textarea.userbuffer);
}


void sws_txtd::settext(char *text)
{RECTL update;

  strcpy(_textarea.userbuffer,text);
 _textarea.curr_pos=0;
 _textarea.buffer_len_p=strlen(text);
   update=_textarea.box;
   update.xRight+= _textarea.origx;
   update.xLeft += _textarea.origx;
   update.yTop  += _textarea.origy;
   update.yBottom+=_textarea.origy;
  WinInvalidateRect(_textarea.hwnd,&update,TRUE);
 }
