/*************************************************************************
** Copyright Classification:
**
**
** Copyright (C) International Business Machines Corp., 1994.             
**                                                                        
**                                                                        
** DISCLAIMER OF WARRANTIES:                                              
** -------------------------                                              
** The following [enclosed] code is sample code created by IBM            
** Corporation.  This sample code is not part of any standard IBM product 
** and is provided to you solely for the purpose of assisting you in the  
** development of your applications.  The code is provided "AS IS",       
** without warranty of any kind.  IBM shall not be liable for any damages 
** arising out of your use of the sample code, even if they have been     
** advised of the possibility of such damages.                            
**                                                                        
**
** Purpose: class sws_glbd Methods
**    Spec: Globe class for data
**--------------------------------------------------------------------
**
** Change Activity:  
**      15May94 Created: redpath
***********************************************************************/
#include "swsglbd.hpp"

#include <stdio.h>
#include <memory.h>
#include <string.h>

extern void  myprintf(char *format);


void  gettextlength(HPS  hps,
                     char     *string,
                     int      len,
                     int      *width,
                     int      *height)

{POINTL      point[5];

 GpiQueryTextBox(hps,
                 (LONG)len, 
                 (PCH)string,
                 (LONG)5L,
                 (PPOINTL)point);
 *width  = point[2].x- point[0].x;
 *height = point[0].y- point[3].y;
}


/****************************************************************
 DefaultOutlineFont: Find an outline font and one which is
                     will enable a clip region. You must has HPS
                     ready
****************************************************************/
void sws_glbd::DefaultOutlineFont()

{static FONTMETRICS fm[80];
 LONG               ltemp=0;
 LONG               cFonts=0;
 int                i;
 
 memset(&_fat,0,sizeof(FATTRS));
 GpiLoadFonts(WinQueryAnchorBlock(HWND_DESKTOP),"helv");
 cFonts= GpiQueryFonts(_hps,QF_PUBLIC|QF_PRIVATE,"Helv",&ltemp,
               sizeof(FONTMETRICS),(PFONTMETRICS)0);
 if (cFonts>sizeof(fm)/sizeof(FONTMETRICS))
   cFonts=sizeof(fm)/sizeof(FONTMETRICS);
 GpiQueryFonts(_hps,QF_PUBLIC|QF_PRIVATE,"Helv",&cFonts,
               sizeof(FONTMETRICS),fm);
 for (i=0; (!(fm[i].fsDefn&FM_DEFN_OUTLINE)) &&     //find outline and
           (!(fm[i].fsType&FM_TYPE_KERNING))  &&    //kerned if can
           (i<cFonts); i++);
 if (i==cFonts)
   for (i=0; (!(fm[i].fsDefn&FM_DEFN_OUTLINE))&&  // Find outline atleast
             (i<cFonts); i++);
 if (i==cFonts)
   i=0;
 _fat.usRecordLength =sizeof(FATTRS);
 _fat.lMatch         =fm[i].lMatch;
 _fat.lMatch         =0;
 _fat.fsFontUse      = FATTR_FONTUSE_OUTLINE;
 strcpy(_fat.szFacename,fm[i].szFacename);
}



sws_glbd::sws_glbd(void)
{
  _hwnd=0;
}

sws_glbd::sws_glbd(HWND hwnd)
{
  _hwnd=hwnd;
  memset(&_box,0,sizeof(RECTL));
  _hps = WinGetScreenPS(HWND_DESKTOP);
  this->DefaultOutlineFont();
}


sws_glbd::~sws_glbd(void)
{
}


void sws_glbd::size(POINTL *ptl,
                    RECTL *rclFrame,
                    HRGN  *hrgnFrame)
{HPS hps;
 SIZEF size;
 POINTL center;
 unsigned IBMh  =rclFrame->yTop/3;
 HRGN  hrgnTemp;
 int rad,width,height;

  rad = IBMh-IBMh/3;
  center.x= rclFrame->xRight/2+ptl->x;
  center.y= IBMh+IBMh+ptl->y;

  memcpy(&_box,rclFrame,sizeof(RECTL));
  hps = WinGetScreenPS(HWND_DESKTOP);
  GpiCreateLogFont(hps,(PSTR8)0,1,&_fat);
  GpiSetBackMix(hps,(LONG)BM_LEAVEALONE);
  GpiSetCharSet(hps,1);
  size.cx = MAKEFIXED(IBMh,0);
  size.cy = MAKEFIXED(IBMh,0);
  GpiSetCharBox(hps,&size);
  GpiSetTextAlignment(hps,TA_NORMAL_HORIZ,TA_BOTTOM);
  GpiBeginPath(hps,1);
    GpiSetCurrentPosition(hps , &center);
    GpiFullArc(hps , DRO_OUTLINE , MAKEFIXED (rad , 0 ) ) ;
    hrgnTemp = GpiPathToRegion(hps, 1, FPATH_ALTERNATE);  
#ifdef NOWAY
    gettextlength(HPS  hps,
                  "IBM",
                  3,
                  &width,
                  &height);
#endif
    GpiCharStringAt(hps,
                    (PPOINTL)ptl,
                    (LONG)3,
                    (PSZ)"IBM");
   GpiEndPath(hps);
   *hrgnFrame = GpiPathToRegion(hps, 1, FPATH_ALTERNATE);
   GpiCombineRegion(hps,*hrgnFrame,*hrgnFrame,hrgnTemp,CRGN_OR);
   GpiDestroyRegion(hps,hrgnTemp);
}



void sws_glbd::draw(HPS     hps,
                    POINTL *ptl,
                    HRGN    hrgnClip)
{HRGN   hrgnSave;
 SIZEF size;
 POINTL center;
 unsigned IBMh  =_box.yTop/3;
 int rad,width,height;

    rad = IBMh-IBMh/3;
    center.x= _box.xRight/2+ptl->x;
    center.y= IBMh+IBMh+ptl->y;

   _ptl.x= ptl->x;
   _ptl.y= ptl->y;
   _hps  = hps;

   GpiSetClipRegion(hps, hrgnClip, &hrgnSave);
   GpiCreateLogFont(hps,(PSTR8)0,1,&_fat);
   GpiSetBackMix(hps,(LONG)BM_LEAVEALONE);
   GpiSetCharSet(hps,1);
   size.cx = MAKEFIXED(IBMh,0);
   size.cy = MAKEFIXED(IBMh,0);
   GpiCreateLogColorTable(hps,0,LCOLF_RGB,0,0,(PLONG)0);
   GpiSetColor(hps,RGB_BLUE);
   GpiSetCharBox(hps,&size);
   GpiSetTextAlignment(hps,TA_NORMAL_HORIZ,TA_BOTTOM);
   GpiSetCurrentPosition(hps , &center);
   GpiFullArc(hps , DRO_OUTLINEFILL , MAKEFIXED (rad , 0 ) ) ;
   GpiBeginPath(hps,1);
     GpiCharStringAt(hps,
                     (PPOINTL)ptl,
                     (LONG)3,
                     (PSZ)"IBM");
   GpiEndPath(hps);
   GpiFillPath(hps,1,FPATH_ALTERNATE);
   GpiSetClipRegion(hps, hrgnSave, &hrgnSave);
}



void sws_glbd::globe(HPS     hps,
                    POINTL *ptl,
                    HRGN    hrgnClip)
{HRGN   hrgnSave;
 HRGN   hrgn;
 SIZEF size;
 HBITMAP hbm;
 HMODULE hmod;
 POINTL point;
 POINTL center;
 RECTL dest;
 unsigned IBMh  =_box.yTop/3;
 static int count=1;
 int rad;

    rad = IBMh-IBMh/3;
    center.x= _box.xRight/2+ptl->x;
    center.y= IBMh+IBMh+ptl->y;

   _ptl.x= ptl->x;
   _ptl.y= ptl->y;
   _hps  = hps;

   GpiCreateLogColorTable(hps,0,LCOLF_RGB,0,0,(PLONG)0);
   GpiSetColor(hps,RGB_BLUE);
   if (DosQueryModuleHandle("SWSGLBP.DLL",&hmod))
        return;
   hbm=GpiLoadBitmap(hps,hmod,count,32,32);
   if (++count>8)
     count=1;
   dest.xLeft= center.x-IBMh; 
   dest.xRight= dest.xLeft+IBMh+IBMh;
   dest.yBottom= center.y-rad;
   dest.yTop=dest.yBottom+rad+rad;
   GpiSetClipRegion(hps,hrgnClip,&hrgnSave);
   WinDrawBitmap(hps,
                 hbm,
                 (PRECTL)0,
                 (PPOINTL)&dest,
                 0L,0L,
                 DBM_STRETCH);
   GpiDeleteBitmap(hbm);
   GpiSetClipRegion(hps,hrgnSave,&hrgnClip);
}


