/******************************************************************************/
/*                                                                            */
/* COPYRIGHT:                                                                 */
/* ----------                                                                 */
/* Copyright (C) International Business Machines Corp., 1994.                 */
/* Copyright:(C) Apple Computer, Inc., 1994                                   */
/*                                                                            */  
/* DISCLAIMER OF WARRANTIES:                                                  */
/* -------------------------                                                  */
/* The following [enclosed] code is sample code created by IBM                */
/* Corporation.  This sample code is not part of any standard IBM product     */
/* and is provided to you solely for the purpose of assisting you in the      */
/* development of your applications.  The code is provided "AS IS",           */
/* without warranty of any kind.  IBM shall not be liable for any damages     */
/* arising out of your use of the sample code, even if they have been         */
/* advised of the possibility of such damages.                                */
/*                                                                            */
/******************************************************************************/

/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: somc/smmain.c
 */


/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitxtm: somc/smmain.c
 */

#define INCL_GPI
#define INCL_WINSTDDRAG

#include <AltPoint.h>

#ifndef _PLFMTYPE_
#include "PlfmType.h"
#endif

#ifndef _STDTYPES_
#include "StdTypes.h"
#endif

#ifndef _STDPROPS_
#include "StdProps.h"
#endif

#ifndef _INFO_
#include "Info.h"
#endif

#ifndef _ARBITRAT_
#include "Arbitrat.h"
#endif

#ifndef _FOCI_
#include "Foci.h"
#endif

#ifndef _FOCUSSET_
#include "FocusSet.h"
#endif

#ifndef _STORAGE_
#include "Storage.h"
#endif

#ifndef _WINSTAT_
#include "WinStat.h"
#endif

#ifndef _WINDOW_
#include "Window.h"
#endif

#ifndef _FRAME_
#include "Frame.h"
#endif

#ifndef _FACET_
#include "Facet.h"
#endif

#ifndef _STORAGEU_
#include "StorageU.h"
#endif

#ifndef _SUVIEW_
#include "SUView.h"
#endif

#ifndef _SUVIEW_
#include "SUView.h"
#endif

#ifndef _XMPSESSN_
#include "XMPSessn.h"
#endif

#ifndef _EXCEPT_
#include "Except.h"
#endif

#ifndef _SHAPE_
#include "shape.h"
#endif

#ifndef _CANVAS_
#include "canvas.h"
#endif

#ifndef _TRNSFORM_
#include "Trnsform.h"
#endif

#ifndef _XMPUTILS_
#include "XMPUtils.h"
#endif

#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif

#include <builtin.h>

#define SSimplePart_Class_Source
#include <SSmpPrt.xih>

//==============================================================================
// Constants
//==============================================================================
// #define SSREMOVEWORKAROUND
// Kind
#define kXMPKindSimple "Apple:Kind:Simple"

// ClassID
#define kDrawPartID "appl:drawpart$class,1.0.0"

// constants for drawing background grid
#define YGRID 32
#define XGRID 32

const char *apszColors[] = { "Gray", "Red", "Green", "Yellow", 
                             "Blue", "Magenta", "Cyan", "White" };

#define IDM_FRAME_BASE 2030
const XMPCommandID cXMPFrame = IDM_FRAME_BASE+1;
const XMPCommandID cXMPFreeze = IDM_FRAME_BASE+2;
const XMPCommandID cXMPDefrost = IDM_FRAME_BASE+3;

//==============================================================================
// 'ternalization 
//==============================================================================
      
const XMPPropertyName  kXMPPropFrameInfo       = "SimplePart:Property:FrameInfo";
const XMPPropertyName  kXMPPropMouseDownOffset = "SimplePart:Property:MouseDownOffset";

const XMPValueType     kQDPoint         = "SimplePart:Type:Point";
const XMPValueType     kXMPMacTPrintRec = "Macintosh:Type:TPrint Record";

const XMPType          kSimplePresNormal  = "SimplePart:Presentation:Normal";

//==============================================================================
// Types
//==============================================================================

class PartInfoRec
{
public:
   PartInfoRec() { fIsActive = kXMPFalse; fNeedsActivating = kXMPFalse; }
   virtual ~PartInfoRec() { }
   RGB bgColor;
   RgnHandle   bgClipRegion;
   XMPBoolean  fIsActive;  // Does this frame have its focus set?
   XMPBoolean  fNeedsActivating; // should this be activated when its window is activated?
};

SOM_Scope void  SOMLINK CommonInitSimplePart(SSimplePart *somSelf, 
                                              Environment *ev)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","CommonInitSimplePart");

    somThis-> fDisplayFrames = new OrderedCollection;
 
    RGB random;
    random.bRed = rand();
    random.bGreen = rand();
    random.bBlue = rand();
    somThis-> fDefaultColor = random;
 
    somThis-> fSession = somSelf-> GetStorageUnit( ev)->GetSession();
 
    somThis-> fSelectionFocus = somThis-> fSession->Tokenize(kXMPSelectionFocus);
    somThis-> fMenuFocus = somThis-> fSession->Tokenize(kXMPMenuFocus);
    somThis-> fKeyFocus = somThis-> fSession->Tokenize(kXMPKeyFocus);
    
    somThis-> fFocusSet = new XMPFocusSet();
    somThis-> fFocusSet->InitFocusSet();
    somThis-> fFocusSet->Add( somThis-> fSelectionFocus);
    somThis-> fFocusSet->Add( somThis-> fMenuFocus);
    somThis-> fFocusSet->Add( somThis-> fKeyFocus);
}

SOM_Scope void  SOMLINK ActivateFrame(SSimplePart *somSelf,  Environment *ev, 
                                      XMPFrame* frame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","ActivateFrame");

    if (frame != kXMPNULL) {
       PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
       if (!(pInfo->fIsActive))
       {
          XMPBoolean succeeded = false;
                         
          succeeded = somThis-> fSession->GetArbitrator()->RequestFocusSet(somThis-> fFocusSet,frame);
                
          if (succeeded)
          {
             somSelf->FocusAcquired( ev, somThis-> fSelectionFocus, frame);
             somSelf->FocusAcquired( ev, somThis-> fKeyFocus, frame);
          }
       }
    }
}

SOM_Scope void  SOMLINK DeActivateFrame(SSimplePart *somSelf, 
                                         Environment *ev, XMPFrame* frame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","DeActivateFrame");

    if (frame != kXMPNULL) {
       somThis-> fSession->GetArbitrator()->RelinquishFocusSet(somThis-> fFocusSet,frame);
       somSelf->FocusLost( ev, somThis-> fSelectionFocus, frame);
       somSelf->FocusLost( ev, somThis-> fKeyFocus, frame);
    }
}

SOM_Scope void  SOMLINK ActivatingWindow(SSimplePart *somSelf, 
                                          Environment *ev, XMPFrame* frame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","ActivatingWindow");

    PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
    if (pInfo->fNeedsActivating)
    {
       somSelf->ActivateFrame( ev, frame);
       pInfo->fNeedsActivating = kXMPFalse;
    }
}

SOM_Scope void  SOMLINK DeActivatingWindow(SSimplePart *somSelf, 
                                            Environment *ev, 
                                           XMPFrame* frame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","DeActivatingWindow");

    PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
    if (frame == somThis-> fSession->GetArbitrator()->GetFocusOwner(somThis-> fSelectionFocus))
    {
       pInfo->fNeedsActivating = kXMPTrue;
       //this->DeActivateFrame(frame);
    }
    else
       pInfo->fNeedsActivating = kXMPFalse;
}

SOM_Scope void  SOMLINK SetGrafPortOrigin(SSimplePart *somSelf, 
                                           Environment *ev, XMPFacet* facet)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","SetGrafPortOrigin");

    XMPTransform* localToGlobal = facet->GetContentTransform();
    HPS hps = facet->GetCanvas()->GetPlatformCanvas();
    PMATRIXLF mtx = (PMATRIXLF)facet->GetContentTransform()->GetPlatformTransform();
 
    // This is a hack until GetPlatformTransform() is fixed to return a 
    // valid MATRIXLF transform (i.e. uses FIXED values where required)
    MATRIXLF mtxTemp = *mtx;
    mtxTemp.fxM11 *= 0x10000;
    mtxTemp.fxM12 *= 0x10000;
    mtxTemp.fxM21 *= 0x10000;
    mtxTemp.fxM22 *= 0x10000;
 
    GpiSetModelTransformMatrix(hps, 9, &mtxTemp, TRANSFORM_REPLACE);
}


/*
 * SOM_Scope XMPWindow*  SOMLINK CreateWindow(SSimplePart *somSelf, 
 *                                             Environment *ev, 
 *                                            XMPFrame** sourceFrame)
 */

/*
 * The prototype for CreateWindow was replaced by the following prototype:
 */
SOM_Scope XMPWindow*  SOMLINK CreateWindow(SSimplePart *somSelf, 
                                            Environment *ev, 
                                           XMPFrame* sourceFrame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","CreateWindow");

    Rect windRect;
    XMPPlatformWindow platformWindow = kXMPNULL;
    XMPWindow* window = kXMPNULL;
    
    _interrupt(3);
    return window;
}

SOM_Scope XMPBoolean  SOMLINK HandleMouseDown(SSimplePart *somSelf, 
                                               Environment *ev, 
                                              XMPFacet* facet, 
                                              XMPPoint* where, 
                                              XMPEventData event)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","HandleMouseDown");

    if (!facet->GetWindow()->IsActive())
       facet->GetWindow()->Select();
    else
       somSelf-> ActivateFrame( ev, facet->GetFrame());
 
    Point mouse = facet->GetWindowContentTransform()->InvertPoint(*where).AsPOINTL();
 
    return kXMPTrue;
}

SOM_Scope void  SOMLINK somInit(SSimplePart *somSelf)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","somInit");

    SSimplePart_parent_OD_Part_somInit(somSelf);

    somThis-> fDisplayFrames = kXMPNULL;

    somThis-> fWindowID = 0;
 
    somThis-> fFrameGroupIDCounter = 1;
 
    somThis-> fFocusSet = kXMPNULL;
 
    somThis-> fPartSU = kXMPNULL;
    
    somThis-> fSession = kXMPNULL;
}

SOM_Scope void  SOMLINK somUninit(SSimplePart *somSelf)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","somUninit");

    if ( somThis-> fDisplayFrames != kXMPNULL)
       delete somThis-> fDisplayFrames;     // make sure it's empty first
 
    XMPReleaseObject( somThis-> fPartSU);

    SSimplePart_parent_OD_Part_somUninit( somSelf);
}

SOM_Scope void  SOMLINK Release(SSimplePart *somSelf,  Environment *ev)
{
    XMPFrame*   frame;
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","Release");

    SSimplePart_parent_OD_Part_Release(somSelf, ev);
    
    if (somSelf-> GetRefCount( ev) == 0) 
    {
       frame = (XMPFrame*) somThis-> fDisplayFrames->First();
       while (frame != kXMPNULL) 
       {
          somThis-> fDisplayFrames->Remove(frame);
          XMPReleaseObject(frame);
          frame = (XMPFrame*) somThis-> fDisplayFrames->First();
       }
       somSelf-> GetStorageUnit( ev)->GetDraft()->ReleasePart((XMPPart*)somSelf-> GetProxy( ev));
    }
}

SOM_Scope void  SOMLINK Externalize(SSimplePart *somSelf,  Environment *ev)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","Externalize");

    SSimplePart_parent_OD_Part_Externalize(somSelf, ev);
    
    XMPStorageUnit* su = somThis-> fPartSU;
    XMPStorageUnitRef aSURef;
    XMPULong offset;
    XMPFrame* frame;
    OrderedCollectionIterator aIter(somThis-> fDisplayFrames);

    MATRIXLF xform;
  
    su->Focus(kXMPPropDisplayFrames,kXMPPosUndefined,0,1,kXMPPosFirstSib);
    #ifndef SSREMOVEWORKAROUND
       su->Remove();
       su->AddProperty(kXMPPropDisplayFrames);
       su->AddValue(kXMPIDs);
    #else
       XMPULong oldValueSize = su->GetSize();;
    #endif
    offset = 0;
    for (frame = (XMPFrame*)aIter.First(); aIter.IsNotComplete();
          frame = (XMPFrame*)aIter.Next(), offset+=sizeof(XMPStorageUnitRef))
    {
       frame->Externalize();
       aSURef = su->GetWeakStorageUnitRef(frame->GetStorageUnit());
       su->SetOffset(offset);
       su->SetValue(sizeof(XMPStorageUnitRef), (XMPValue)&aSURef);
    }
    #ifdef SSREMOVEWORKAROUND
       if (oldValueSize > offset) su->DeleteValue(oldValueSize-offset);
    #endif
  
    su->Focus(kXMPPropFrameGroup,kXMPPosUndefined,0,1,kXMPPosFirstSib);
    su->SetValue(sizeof(somThis->fFrameGroupIDCounter), (XMPValue)&somThis->fFrameGroupIDCounter);
  
    su = somSelf->GetStorageUnit( ev);
    su->Focus(kXMPPropContents,kXMPPosSame,kXMPKindSimple,1,kXMPPosFirstSib);
    aSURef = su->GetStrongStorageUnitRef(somThis-> fPartSU);
    su->SetValue(sizeof(XMPStorageUnitRef),&aSURef);
}

SOM_Scope void  SOMLINK FulfillPromise(SSimplePart *somSelf, 
                                        Environment *ev, XMPStorageUnitView* promiseSUView)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","FulfillPromise");

    SSimplePart_parent_OD_Part_FulfillPromise(somSelf, ev, promiseSUView);
}

SOM_Scope void  SOMLINK DropCompleted(SSimplePart *somSelf,  Environment *ev, 
                                      XMPPart* destPart, XMPDropResult dropResult)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","DropCompleted");

    SSimplePart_parent_OD_Part_DropCompleted(somSelf, ev, destPart, 
                                             dropResult);
}

SOM_Scope XMPULong  SOMLINK DragEnter(SSimplePart *somSelf,  Environment *ev, 
                                      XMPDragItemIterator* dragInfo, 
                                      XMPFacet* facet, XMPPoint* where)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","DragEnter");

    return XMPULong(MRFROM2SHORT (DOR_NEVERDROP, DO_UNKNOWN));
}

SOM_Scope XMPULong  SOMLINK DragWithin(SSimplePart *somSelf, 
                                        Environment *ev, XMPDragItemIterator* dragInfo, 
                                       XMPFacet* facet, XMPPoint* where)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","DragWithin");

    return XMPULong(MRFROM2SHORT (DOR_NEVERDROP, DO_UNKNOWN));
}

SOM_Scope void  SOMLINK DragLeave(SSimplePart *somSelf,  Environment *ev, 
                                  XMPFacet* facet, XMPPoint* where)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","DragLeave");

    SSimplePart_parent_OD_Part_DragLeave(somSelf, ev, facet, 
                                         where);
}

SOM_Scope XMPDropResult  SOMLINK Drop(SSimplePart *somSelf,  Environment *ev, 
                                      XMPDragItemIterator* dropInfo, 
                                      XMPFacet* facet, XMPPoint* where)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","Drop");

    return kXMPDropFail;
}

SOM_Scope void  SOMLINK ContainingPartPropertiesChanged(SSimplePart *somSelf, 
                                                         Environment *ev, 
                                                        XMPFrame* frame, 
                                                        XMPStorageUnit* propertyUnit)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","ContainingPartPropertiesChanged");

    SSimplePart_parent_OD_Part_ContainingPartPropertiesChanged(somSelf, 
                                                               ev, 
                                                               frame, 
                                                               propertyUnit);
}

SOM_Scope XMPStorageUnit*  SOMLINK GetContainingPartProperties(SSimplePart *somSelf, 
                                                                Environment *ev, 
                                                               XMPFrame* frame)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","GetContainingPartProperties");

    return (SSimplePart_parent_OD_Part_GetContainingPartProperties(somSelf, 
                                                                   ev, 
                                                                   frame));
}

SOM_Scope void  SOMLINK RevealFrame(SSimplePart *somSelf,  Environment *ev, 
                                    XMPFrame* embeddedFrame)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","RevealFrame");

    SSimplePart_parent_OD_Part_RevealFrame(somSelf, ev, embeddedFrame);
}

SOM_Scope void  SOMLINK EmbeddedFrameSpec(SSimplePart *somSelf, 
                                           Environment *ev, XMPFrame* embeddedFrame, 
                                          XMPObjectSpec* spec)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","EmbeddedFrameSpec");

    SSimplePart_parent_OD_Part_EmbeddedFrameSpec(somSelf, ev, 
                                                 embeddedFrame, 
                                                 spec);
}

SOM_Scope XMPEmbeddedFramesIterator*  SOMLINK CreateEmbeddedFramesIterator(SSimplePart *somSelf, 
                                                                            Environment *ev)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","CreateEmbeddedFramesIterator");

    return (SSimplePart_parent_OD_Part_CreateEmbeddedFramesIterator(somSelf, 
                                                                    ev));
}

SOM_Scope void  SOMLINK AddDisplayFrame(SSimplePart *somSelf, 
                                         Environment *ev, XMPFrame* frame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","AddDisplayFrame");

 
    if (frame->GetPart() == (XMPPart*)somSelf-> GetProxy( ev))    // frame belongs to me
    {
       OrderedCollectionIterator  displayFramesIter(somThis-> fDisplayFrames);
       XMPFrame* displayFrame = (XMPFrame*) displayFramesIter.First();
 
       // !!! do something with viewType and partInfo...
       PartInfoRec* pInfo = new PartInfoRec;
       pInfo->bgColor = somThis-> fDefaultColor;
       if (frame->IsRoot())
          pInfo->fNeedsActivating = kXMPTrue;
 
       frame->SetPartInfo((XMPInfoType) pInfo);
       somThis-> fDisplayFrames->AddLast(frame);
       frame->IncrementRefCount();
       frame->SetDroppable(kXMPTrue);
       
       if (frame->GetViewType() == kXMPNullTypeToken)                 // if frame view is set don't change it
          frame->SetViewType(somThis-> fSession->Tokenize(kXMPViewAsFrame));    // if not, make it viewasframe
       if (frame->GetPresentation() == kXMPNullTypeToken)             
          frame->SetPresentation(somThis-> fSession->Tokenize(kSimplePresNormal));
       
       if (frame->GetContainingFrame() == kXMPNULL)
       {
          //Wrong place. this->ActivateFrame(frame);
       }
    }
    else
       THROW(kXMPErrInvalidFrame);
 
    // render in frame?
}

SOM_Scope void  SOMLINK AttachSourceFrame(SSimplePart *somSelf, 
                                           Environment *ev, XMPFrame* frame, 
                                          XMPFrame* sourceFrame)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","AttachSourceFrame");

    SSimplePart_parent_OD_Part_AttachSourceFrame(somSelf, ev, 
                                                 frame, sourceFrame);
}

SOM_Scope void  SOMLINK RemoveDisplayFrame(SSimplePart *somSelf, 
                                            Environment *ev, 
                                           XMPFrame* frame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","RemoveDisplayFrame");

    if (frame != kXMPNULL) {
       if (somThis-> fDisplayFrames->Contains(frame))
       {
          somThis-> fSession->GetArbitrator()->RelinquishFocusSet(somThis-> fFocusSet,frame);
    
          PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
          frame->SetPartInfo((XMPInfoType) kXMPNULL);
          delete pInfo;
          somThis-> fDisplayFrames->Remove(frame);
          frame->Release();
          
          OrderedCollectionIterator dIter(somThis-> fDisplayFrames);
          XMPFrame*   displayFrame = (XMPFrame*) dIter.First();
          if (dIter.IsNotComplete() == kXMPFalse) {
          }
       }
       else
          THROW(kXMPErrInvalidFrame);
    }
 
    // any display frames left?
}

SOM_Scope void  SOMLINK CloseDisplayFrame(SSimplePart *somSelf, 
                                           Environment *ev, XMPFrame* frame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","CloseDisplayFrame");

   if (somThis-> fDisplayFrames->Contains(frame))
   {
      
      somThis-> fSession->GetArbitrator()->RelinquishFocusSet(somThis-> fFocusSet, frame);

      PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
      frame->SetPartInfo((XMPInfoType) kXMPNULL);
      delete pInfo;
      somThis-> fDisplayFrames->Remove(frame);
      XMPReleaseObject(frame);
   }
   else
      THROW(kXMPErrInvalidFrame);
}

SOM_Scope void  SOMLINK FrameShapeChanged(SSimplePart *somSelf, 
                                           Environment *ev, XMPFrame* frame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","FrameShapeChanged");

    if (somThis-> fDisplayFrames->Contains(frame))
    {
       /// !!! should leave UsedShape and ActiveShape null to inherit FrameShape
    }
    else
       THROW(kXMPErrInvalidFrame);
}

SOM_Scope void  SOMLINK ViewTypeChanged(SSimplePart *somSelf, 
                                         Environment *ev, XMPFrame* frame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","ViewTypeChanged");

    if (somThis-> fDisplayFrames->Contains(frame))
       { /* !!! change viewType of frame */ }
    else
       THROW(kXMPErrInvalidFrame);
}

SOM_Scope void  SOMLINK PresentationChanged(SSimplePart *somSelf, 
                                             Environment *ev, 
                                            XMPFrame* frame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","PresentationChanged");

    if (somThis-> fDisplayFrames->Contains(frame))
       { /* !!! change presentation of frame */ }
    else
       THROW(kXMPErrInvalidFrame);
}

SOM_Scope void  SOMLINK WritePartInfo(SSimplePart *somSelf,  Environment *ev, 
                                      XMPPtr partInfo, XMPStorageUnitView* storageUnitView)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","WritePartInfo");

    if (partInfo)
    {
       storageUnitView->SetValue(sizeof(RGB), (XMPValue)&(((PartInfoRec*)partInfo)->bgColor));
       XMPBoolean needsActivating = ((PartInfoRec*)partInfo)->fNeedsActivating 
                            || ((PartInfoRec*)partInfo)->fIsActive;
       storageUnitView->SetValue(sizeof(XMPBoolean),
                            (XMPValue)&needsActivating);
    }
}

SOM_Scope XMPPtr  SOMLINK ReadPartInfo(SSimplePart *somSelf, 
                                        Environment *ev, XMPFrame* frame, 
                                       XMPStorageUnitView* storageUnitView)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","ReadPartInfo");

    if (storageUnitView->GetSize())
    {
       PartInfoRec* partInfo = new PartInfoRec;
       
       storageUnitView->GetValue(sizeof(RGB),
                            (XMPValue)&(partInfo->bgColor));
       XMPBoolean needsActivating;
       storageUnitView->GetValue(sizeof(XMPBoolean),
                            (XMPValue)&(needsActivating));
       partInfo->fNeedsActivating = needsActivating;
                            
       return partInfo;
    }
    else
       return ((XMPPtr)kXMPNULL);
}

SOM_Scope XMPID  SOMLINK Open(SSimplePart *somSelf,  Environment *ev, 
                              XMPFrame* frame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","Open");

    XMPWindow* window = kXMPNULL;
 
    if (frame) // Doing a View As Window
    {
       window = somThis-> fSession->GetWindowState()->GetWindow(somThis-> fWindowID);
       if (window)
          window->Select();
       else
       {
          window = somSelf->CreateWindow( ev, frame);
          somThis-> fWindowID = window->GetID();
          window->Open();
          window->Show();
          window->Select();       
       }
    }
    else
    {
       window = somSelf->CreateWindow( ev, frame);
       somThis-> fWindowID = window->GetID();
       window->Open();
       window->Show();
       window->Select();       
    }
    return window->GetID();
}

SOM_Scope XMPFrame*  SOMLINK CreateEmbeddedFrame(SSimplePart *somSelf, 
                                                  Environment *ev, 
                                                 XMPFrame* containingFrame, 
                                                 XMPShape* frameShape, 
                                                 XMPTransform* externalTransform, 
                                                 XMPPart* embedPart, 
                                                 XMPTypeToken viewType, 
                                                 XMPTypeToken presentation, 
                                                 XMPID frameGroupID, 
                                                 XMPBoolean isOverlaid)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","CreateEmbeddedFrame");

    return (SSimplePart_parent_OD_Part_CreateEmbeddedFrame(somSelf, 
                                                           ev, 
                                                           containingFrame, 
                                                           frameShape, 
                                                           externalTransform, 
                                                           embedPart, 
                                                           viewType, 
                                                           presentation, 
                                                           frameGroupID, 
                                                           isOverlaid));
}

SOM_Scope void  SOMLINK RemoveEmbeddedFrame(SSimplePart *somSelf, 
                                             Environment *ev, 
                                            XMPFrame* embeddedFrame)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","RemoveEmbeddedFrame");

    SSimplePart_parent_OD_Part_RemoveEmbeddedFrame(somSelf, ev, 
                                                   embeddedFrame);
}

SOM_Scope XMPShape*  SOMLINK RequestFrameShape(SSimplePart *somSelf, 
                                                Environment *ev, 
                                               XMPFrame* embeddedFrame, 
                                               XMPShape* frameShape)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","RequestFrameShape");

    return (SSimplePart_parent_OD_Part_RequestFrameShape(somSelf, 
                                                         ev, 
                                                         embeddedFrame, 
                                                         frameShape));
}

SOM_Scope void  SOMLINK UsedShapeChanged(SSimplePart *somSelf, 
                                          Environment *ev, XMPFrame* embeddedFrame)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","UsedShapeChanged");

    SSimplePart_parent_OD_Part_UsedShapeChanged(somSelf, ev, 
                                                embeddedFrame);
}

SOM_Scope XMPShape*  SOMLINK AdjustBorderShape(SSimplePart *somSelf, 
                                                Environment *ev, 
                                               XMPFrame* embeddedFrame, 
                                               XMPShape* shape)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","AdjustBorderShape");

    return (SSimplePart_parent_OD_Part_AdjustBorderShape(somSelf, 
                                                         ev, 
                                                         embeddedFrame, 
                                                         shape));
}

SOM_Scope void  SOMLINK FacetAdded(SSimplePart *somSelf,  Environment *ev, 
                                   XMPFacet* facet)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","FacetAdded");

    SSimplePart_parent_OD_Part_FacetAdded(somSelf, ev, facet);
}

SOM_Scope void  SOMLINK FacetRemoved(SSimplePart *somSelf,  Environment *ev, 
                                     XMPFacet* facet)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","FacetRemoved");

    SSimplePart_parent_OD_Part_FacetRemoved(somSelf, ev, facet);
}

SOM_Scope void  SOMLINK ClipShapeChanged(SSimplePart *somSelf, 
                                          Environment *ev, XMPFacet* facet)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","ClipShapeChanged");

    SSimplePart_parent_OD_Part_ClipShapeChanged(somSelf, ev, 
                                                facet);
}

SOM_Scope void  SOMLINK ExternalTransformChanged(SSimplePart *somSelf, 
                                                  Environment *ev, 
                                                 XMPFacet* facet)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","ExternalTransformChanged");

    SSimplePart_parent_OD_Part_ExternalTransformChanged(somSelf, 
                                                        ev, facet);
}

SOM_Scope void  SOMLINK Draw(SSimplePart *somSelf,  Environment *ev, 
                             XMPFacet* facet, XMPShape* invalidShape)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","Draw");

    XMPBoolean drawing = facet->GetCanvas()->IsDynamic();
    
    XMPFrame* displayFrame = facet->GetFrame();
    if (somThis-> fDisplayFrames->Contains(displayFrame))  
    {
       // transform grafport
 
       HPS hpsDraw = facet->GetCanvas()->GetPlatformCanvas();
       GpiSavePS(hpsDraw);
 
 
       PartInfoRec* pInfo = (PartInfoRec*) displayFrame->GetPartInfo();
 
       RgnHandle frameRgn = displayFrame->GetFrameShape()->GetQDRegion();
       Rect frameRect;
       GpiQueryRegionBox(hpsDraw, frameRgn, &frameRect);
 
       // set up clipping
       RgnHandle saveClip;
       XMPShape* clipShape = new XMPShape;
       clipShape->CopyFrom(facet->GetAggregateClipShape());
       clipShape->Transform(facet->GetContentTransform());
       RgnHandle clip = clipShape->GetQDRegion();
       GpiSetClipRegion(hpsDraw, clip, &saveClip);
       
       if (facet->GetFrame()->GetPresentation() == somThis-> fSession->Tokenize(kSimplePresNormal))
       {
          XMPTypeToken curView = facet->GetFrame()->GetViewType();
          
          if (curView == somThis-> fSession->Tokenize(kXMPViewAsFrame)) {
             // paint the background
          
             GpiResetPS(hpsDraw, GRES_ATTRS);
       
             somSelf->SetGrafPortOrigin( ev, facet);
 
             RGB bgRGB = pInfo->bgColor;
             ULONG ulRGB = (bgRGB.bRed << 16) + (bgRGB.bGreen << 8) + bgRGB.bBlue;
             ULONG lColorIndex = GpiQueryColorIndex(hpsDraw, 0, ulRGB);
             GpiSetColor(hpsDraw, lColorIndex);
             POINTL ptl = {frameRect.xRight, frameRect.yTop};
             GpiBox(hpsDraw, DRO_FILL, &ptl, 0, 0);
 
             GpiSetLineType(hpsDraw, LINETYPE_DASHDOUBLEDOT);
             GpiSetColor(hpsDraw, CLR_BLACK);
 
             for (int y = 0; y < frameRect.yTop; y += YGRID) {
                ptl.y = y;
                ptl.x = 0;
                GpiMove(hpsDraw, &ptl);
                ptl.x = frameRect.xRight;
                ptl.y += frameRect.xRight;
                GpiLine(hpsDraw, &ptl);
             }
       
             for (int x = XGRID; x < frameRect.xRight; x += XGRID) {
                ptl.x = x;
                ptl.y = 0;
                GpiMove(hpsDraw, &ptl);
                ptl.x += frameRect.yTop;
                ptl.y = frameRect.yTop;
                GpiLine(hpsDraw, &ptl);
             }
 
          }
       }
       GpiRestorePS(hpsDraw, -1);
    
       GpiSetClipRegion(hpsDraw, 0, &saveClip);
       delete clipShape;
    }
    else
    {
       // !!! signal error: invalid frame
    }
}

SOM_Scope void  SOMLINK CanvasUpdated(SSimplePart *somSelf,  Environment *ev, 
                                      XMPCanvas* canvas)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","CanvasUpdated");

    SSimplePart_parent_OD_Part_CanvasUpdated(somSelf, ev, canvas);
}

SOM_Scope void  SOMLINK HighlightChanged(SSimplePart *somSelf, 
                                          Environment *ev, XMPFrame* frame)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","HighlightChanged");

    SSimplePart_parent_OD_Part_HighlightChanged(somSelf, ev, 
                                                frame);
}

SOM_Scope XMPULong  SOMLINK GetPrintResolution(SSimplePart *somSelf, 
                                                Environment *ev, 
                                               XMPFrame* frame)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","GetPrintResolution");

    return (SSimplePart_parent_OD_Part_GetPrintResolution(somSelf, 
                                                          ev, 
                                                          frame));
}

SOM_Scope XMPLink*  SOMLINK CreateLink(SSimplePart *somSelf, 
                                        Environment *ev, XMPPtr data, 
                                       XMPULong size)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","CreateLink");

    return (SSimplePart_parent_OD_Part_CreateLink(somSelf, ev, 
                                                  data, size));
}

SOM_Scope void  SOMLINK LinkUpdated(SSimplePart *somSelf,  Environment *ev, 
                                    XMPLink* updatedLink, XMPChangeID id)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","LinkUpdated");

    SSimplePart_parent_OD_Part_LinkUpdated(somSelf, ev, updatedLink, 
                                           id);
}

SOM_Scope void  SOMLINK RevealLink(SSimplePart *somSelf,  Environment *ev, 
                                   XMPLinkSource* linkSource)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","RevealLink");

    SSimplePart_parent_OD_Part_RevealLink(somSelf, ev, linkSource);
}

SOM_Scope void  SOMLINK EmbeddedFrameChanged(SSimplePart *somSelf, 
                                              Environment *ev, 
                                             XMPFrame* frame, 
                                             XMPChangeID change)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","EmbeddedFrameChanged");

    SSimplePart_parent_OD_Part_EmbeddedFrameChanged(somSelf, 
                                                    ev, frame, 
                                                    change);
}

SOM_Scope void  SOMLINK LinkStatusChanged(SSimplePart *somSelf, 
                                           Environment *ev, XMPFrame* frame)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","LinkStatusChanged");

    SSimplePart_parent_OD_Part_LinkStatusChanged(somSelf, ev, 
                                                 frame);
}

SOM_Scope XMPBoolean  SOMLINK BeginRelinquishFocus(SSimplePart *somSelf, 
                                                    Environment *ev, 
                                                   XMPTypeToken focus, 
                                                   XMPFrame* ownerFrame, 
                                                   XMPFrame* proposedFrame)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","BeginRelinquishFocus");

    return (SSimplePart_parent_OD_Part_BeginRelinquishFocus(somSelf, 
                                                            ev, 
                                                            focus, 
                                                            ownerFrame, 
                                                            proposedFrame));
}

SOM_Scope void  SOMLINK CommitRelinquishFocus(SSimplePart *somSelf, 
                                               Environment *ev, 
                                              XMPTypeToken focus, 
                                              XMPFrame* ownerFrame, 
                                              XMPFrame* proposedFrame)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","CommitRelinquishFocus");

    somSelf->FocusLost( ev, focus, ownerFrame);
}

SOM_Scope void  SOMLINK AbortRelinquishFocus(SSimplePart *somSelf, 
                                              Environment *ev, 
                                             XMPTypeToken focus, 
                                             XMPFrame* ownerFrame, 
                                             XMPFrame* proposedFrame)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","AbortRelinquishFocus");

    SSimplePart_parent_OD_Part_AbortRelinquishFocus(somSelf, 
                                                    ev, focus, 
                                                    ownerFrame, 
                                                    proposedFrame);
}

SOM_Scope void  SOMLINK FocusAcquired(SSimplePart *somSelf,  Environment *ev, 
                                      XMPTypeToken focus, XMPFrame* ownerFrame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","FocusAcquired");

    if (focus == somThis-> fSelectionFocus) 
    {
       PartInfoRec* pInfo = (PartInfoRec*) ownerFrame->GetPartInfo();
       pInfo->fIsActive = kXMPTrue;
    }
}

SOM_Scope void  SOMLINK FocusLost(SSimplePart *somSelf,  Environment *ev, 
                                  XMPTypeToken focus, XMPFrame* ownerFrame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","FocusLost");

    if (focus == somThis-> fSelectionFocus) 
    {
       PartInfoRec* pInfo = (PartInfoRec*) ownerFrame-> GetPartInfo();
       pInfo->fIsActive = kXMPFalse;
    }
}

SOM_Scope void  SOMLINK CloneInto(SSimplePart *somSelf,  Environment *ev, 
                                  XMPDraftKey* key, XMPStorageUnit* storageUnit, 
                                  XMPStorageUnit* initiatingFrame)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","CloneInto");

   XMPStorageUnit*   su = somSelf->GetStorageUnit( ev);
   
   somSelf->Externalize( ev);
   XMPStorageUnit* destPartSU = somThis-> fPartSU->CloneTo(*key, storageUnit->GetDraft(), initiatingFrame); 
   
   storageUnit->AddProperty(kXMPPropContents);
   storageUnit->AddValue(kXMPKindSimple);
   XMPStorageUnitRef aSURef = storageUnit->GetStrongStorageUnitRef(destPartSU);
   storageUnit->SetValue(sizeof(XMPStorageUnitRef),&aSURef);
      
   destPartSU->Release();
   
   su->CloneInto( *key, storageUnit, initiatingFrame);
}

SOM_Scope void  SOMLINK ExternalizeKinds(SSimplePart *somSelf, 
                                          Environment *ev, XMPTypeSet* kindset)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","ExternalizeKinds");

    SSimplePart_parent_OD_Part_ExternalizeKinds(somSelf, ev, 
                                                kindset);
}

SOM_Scope void  SOMLINK ChangeKind(SSimplePart *somSelf,  Environment *ev, 
                                   XMPType kind)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","ChangeKind");

    SSimplePart_parent_OD_Part_ChangeKind(somSelf, ev, kind);
}


/*
 * SOM_Scope XMPBoolean  SOMLINK HandleEvent(SSimplePart *somSelf, 
 *                                            Environment *ev, XMPEventData* event, 
 *                                           XMPFrame* frame, XMPFacet* facet)
 */

/*
 * The prototype for HandleEvent was replaced by the following prototype:
 */
SOM_Scope XMPBoolean  SOMLINK HandleEvent(SSimplePart *somSelf, 
                                           Environment *ev, XMPEventData event, 
                                          XMPFrame* frame, XMPFacet* facet)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","HandleEvent");

    Point windowPoint;
    XMPBoolean handled = kXMPFalse;
    
    switch (event->what)
    {
       case kXMPEvtMouseDown:
          {
             windowPoint = event->where;
             XMPPoint windowXMPPoint(windowPoint);
             handled = somSelf->HandleMouseDown( ev, facet, &windowXMPPoint, event);
          }
          break;
          
       case kXMPEvtMouseUp:
          break;
         
       case kXMPEvtMouseMove:
          break;
          
       case kXMPEvtKeyDown:
       case kXMPEvtAutoKey:
          DosBeep(200,20);
          break;
    
       case kXMPEvtActivate:
          handled = true; // actually ignored by dispatcher
          if (SHORT1FROMMP(event->mp1) != 0)
             somSelf->ActivatingWindow( ev, frame);
          else
             somSelf->DeActivatingWindow( ev, frame);
          break;
       
       case kXMPEvtKeyUp:
          break;
                   
       case kHighLevelEvent:
          break;
 
       default:
          return kXMPFalse;
    }
    return handled;
}

SOM_Scope void  SOMLINK MouseEnter(SSimplePart *somSelf,  Environment *ev, 
                                   XMPFacet* facet, XMPPoint* where)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","MouseEnter");

    SSimplePart_parent_OD_Part_MouseEnter(somSelf, ev, facet, 
                                          where);
}

SOM_Scope void  SOMLINK MouseWithin(SSimplePart *somSelf,  Environment *ev, 
                                    XMPFacet* facet, XMPPoint* where)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","MouseWithin");

    SSimplePart_parent_OD_Part_MouseWithin(somSelf, ev, facet, 
                                           where);
}

SOM_Scope void  SOMLINK MouseLeave(SSimplePart *somSelf,  Environment *ev, 
                                   XMPFacet* facet)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","MouseLeave");

    SSimplePart_parent_OD_Part_MouseLeave(somSelf, ev, facet);
}

SOM_Scope void  SOMLINK AdjustMenus(SSimplePart *somSelf,  Environment *ev, 
                                    XMPFrame* frame)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","AdjustMenus");

    SSimplePart_parent_OD_Part_AdjustMenus(somSelf, ev, frame);
}

SOM_Scope void  SOMLINK UndoAction(SSimplePart *somSelf,  Environment *ev, 
                                   XMPActionData* actionState)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","UndoAction");

    SSimplePart_parent_OD_Part_UndoAction(somSelf, ev, actionState);
}

SOM_Scope void  SOMLINK RedoAction(SSimplePart *somSelf,  Environment *ev, 
                                   XMPActionData* actionState)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","RedoAction");

    SSimplePart_parent_OD_Part_RedoAction(somSelf, ev, actionState);
}

SOM_Scope void  SOMLINK DisposeActionState(SSimplePart *somSelf, 
                                            Environment *ev, 
                                           XMPActionData* actionState, 
                                           XMPDoneState* doneState)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","DisposeActionState");

    SSimplePart_parent_OD_Part_DisposeActionState(somSelf, ev, 
                                                  actionState, 
                                                  doneState);
}

SOM_Scope void  SOMLINK WriteActionState(SSimplePart *somSelf, 
                                          Environment *ev, XMPPtr actionState, 
                                         XMPStorageUnitView* storageUnitView)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","WriteActionState");

    SSimplePart_parent_OD_Part_WriteActionState(somSelf, ev, 
                                                actionState, 
                                                storageUnitView);
}

SOM_Scope XMPPtr  SOMLINK ReadActionState(SSimplePart *somSelf, 
                                           Environment *ev, XMPStorageUnitView* storageUnitView)
{
    /* SSimplePartData *somThis = SSimplePartGetData(somSelf); */
    SSimplePartMethodDebug("SSimplePart","ReadActionState");

    return (SSimplePart_parent_OD_Part_ReadActionState(somSelf, 
                                                       ev, storageUnitView));
}

SOM_Scope void  SOMLINK InitPart(SSimplePart *somSelf,  Environment *ev, 
                                 XMPStorageUnit* storageUnit)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","InitPart");

    if ( somSelf-> Initialized( ev) )
       return;
    
    somSelf-> InitPersistentObject( ev, storageUnit);
    
    somThis-> fSession = storageUnit->GetSession();
    
    somSelf-> CommonInitSimplePart( ev);
    
    XMPStorageUnit* msu = somSelf-> GetStorageUnit( ev);
    msu->AddProperty(kXMPPropContents)->AddValue(kXMPKindSimple);   
    somThis-> fPartSU = msu->GetDraft()->CreateStorageUnit();
 
    somThis-> fPartSU->AddProperty(kXMPPropDisplayFrames)->AddValue(kXMPIDs);        
    somThis-> fPartSU->AddProperty(kXMPPropFrameGroup)->AddValue(kXMPULong);         
    somThis-> fPartSU->AddProperty(kXMPPropContents)->AddValue(kXMPIDs);
}

SOM_Scope void  SOMLINK InitPartFromStorage(SSimplePart *somSelf, 
                                             Environment *ev, 
                                            XMPStorageUnit* storageUnit)
{
    SSimplePartData *somThis = SSimplePartGetData(somSelf);
    SSimplePartMethodDebug("SSimplePart","InitPartFromStorage");

    SSimplePart_parent_OD_Part_InitPartFromStorage(somSelf, ev, 
                                                   storageUnit);
    if ( somSelf-> Initialized(ev ) )
       return;
    
    somSelf-> InitPersistentObjectFromStorage( ev, storageUnit);
 
    somThis-> fSession = storageUnit->GetSession();
    
    somSelf-> CommonInitSimplePart( ev);
    
 
    XMPStorageUnit* su;
    XMPStorageUnitRef aSURef;
    XMPFrame* frame;
    XMPShape* newShape;
    XMPULong offset, offsetLimit;

    MATRIXLF xform;
    XMPTransform* transform;
 
    su = somSelf-> GetStorageUnit( ev);
    su->Focus(kXMPPropContents,kXMPPosSame,kXMPKindSimple,1,kXMPPosFirstSib);
    su->GetValue(sizeof(XMPStorageUnitRef),&aSURef);
    somThis-> fPartSU = su->GetDraft()->GetStorageUnit(su->GetIDFromStorageUnitRef(aSURef));
    su = somThis-> fPartSU;
 
    su->Focus(kXMPPropDisplayFrames, kXMPPosSame, 0, 1, kXMPPosFirstSib);
    offsetLimit = su->GetSize();
    for (offset = 0; offset < offsetLimit; offset += sizeof(XMPStorageUnitRef))
    {
       su->SetOffset(offset);
       su->GetValue(sizeof(XMPStorageUnitRef), (XMPValue)&aSURef);
       
       TRY
       
          frame = su->GetDraft()->GetFrame(su->GetIDFromStorageUnitRef(aSURef));
          somThis-> fDisplayFrames->AddLast((ElementType)frame);
          frame->SetDroppable(kXMPTrue);
          
       CATCH_ALL
       
          frame = kXMPNULL;
    
       ENDTRY
    }
 
    su->Focus(kXMPPropFrameGroup,kXMPPosSame,0,1,kXMPPosFirstSib);
    su->GetValue(sizeof(somThis-> fFrameGroupIDCounter),(XMPValue)&somThis-> fFrameGroupIDCounter);
}

