/******************************************************************************/
/*                                                                            */
/* COPYRIGHT:                                                                 */
/* ----------                                                                 */
/* Copyright (C) International Business Machines Corp., 1994.                 */
/* Copyright:(C) Apple Computer, Inc., 1994                                   */
/*                                                                            */  
/* DISCLAIMER OF WARRANTIES:                                                  */
/* -------------------------                                                  */
/* The following [enclosed] code is sample code created by IBM                */
/* Corporation.  This sample code is not part of any standard IBM product     */
/* and is provided to you solely for the purpose of assisting you in the      */
/* development of your applications.  The code is provided "AS IS",           */
/* without warranty of any kind.  IBM shall not be liable for any damages     */
/* arising out of your use of the sample code, even if they have been         */
/* advised of the possibility of such damages.                                */
/*                                                                            */
/******************************************************************************/
/*
   File:    SimplePart.h

   Contains:   definition for class SimplePart

   Written by: Jason Crawford

   Change History (most recent first):

*/

#ifndef _SIMPLPRT_
#define _SIMPLPRT_

#ifndef _PLFMTYPE_
   #include "PlfmType.h"
#endif

#ifndef _IBP_
   #include "ibp.h"
#endif

// define constants for type names of part classes
#ifndef _PARTTYPE_
   #include "PartType.h"
#endif                   

#define APPLEINCL_QuickDraw
#ifndef APPLEINCLUDED
   #include <Apple.h>
#endif

#ifndef __DRAWDEF__
   #include "DrawDef.h"
#endif
                

//==============================================================================
// Classes defined in this interface
//==============================================================================

class SimplePart;
//class DrawEmbeddedFramesIterator;

//==============================================================================
// Classes used by this interface
//==============================================================================

class OrderedCollection;
class OrderedCollectionIterator;
class XMPFacet;
class XMPFrame;
class XMPFocusSet;
class XMPSemanticInterface;
//class SimplePartPropAccessor;
class XMPDragItemIterator;
class XMPWindow;
class XMPSession;

   //--------------------------------------------------------------------------
   // Class Types
   //--------------------------------------------------------------------------


//==============================================================================
// Types
//==============================================================================

   typedef RGB RGBColor;

   class PartInfoRec
   {
   public:
      PartInfoRec() { fIsActive = kXMPFalse; fNeedsActivating = kXMPFalse; }
      virtual ~PartInfoRec() { }
      RGBColor bgColor;
      RgnHandle   bgClipRegion;
      XMPBoolean  fIsActive;  // Does this frame have its focus set?
      XMPBoolean  fNeedsActivating; // should this be activated when its window is activated?
   };

//==============================================================================
// SimplePart
//==============================================================================

extern "C" {
   XMPPart* EXPENTRY CreatePart(void);
}

class SimplePart : public ImplBasePart
{
   //--------------------------------------------------------------------------
   // Class Friends
   //--------------------------------------------------------------------------

   friend class XMPDraft;
// friend class SimplePartPropAccessor;

public:

   // -Extension-
   XMPMethod XMPBoolean    HasExtension(XMPType extensionName);
   XMPMethod XMPExtension* GetExtension(XMPType extensionName);

   // -Drag&Drop-
   XMPMethod void FulfillPromise(XMPStorageUnitView *promiseSUView);
   XMPMethod void DropCompleted(XMPPart* destPart, XMPDropResult dropResult);
   XMPMethod MRESULT DragEnter(XMPDragItemIterator* dragInfo, XMPFacet* facet, XMPPoint where);  //dwf
   XMPMethod MRESULT DragWithin(XMPDragItemIterator* dragInfo, XMPFacet* facet, XMPPoint where);   //dwf
   XMPMethod void DragLeave(XMPFacet* facet, XMPPoint where);
   XMPMethod XMPDropResult Drop(XMPDragItemIterator* dropInfo, XMPFacet* facet, XMPPoint where);

   // -Embedding-

   // -Frame-
   XMPMethod void AddDisplayFrame(XMPFrame* frame);
   XMPMethod void RemoveDisplayFrame(XMPFrame* frame);
   XMPMethod void CloseDisplayFrame(XMPFrame* frame);
   XMPMethod void FrameShapeChanged(XMPFrame* frame);
   XMPMethod void ViewTypeChanged(XMPFrame* frame);
   XMPMethod void PresentationChanged(XMPFrame* frame);
   XMPMethod void WritePartInfo(XMPPtr partInfo, XMPStorageUnitView* storageUnitView);
   XMPMethod XMPPtr ReadPartInfo(XMPFrame* frame, XMPStorageUnitView* storageUnitView);
   XMPMethod XMPID Open(XMPFrame* frame); //Override

   // -Facet-
   XMPMethod void ExternalTransformChanged(XMPFacet* facet);

   // -Imaging-
   XMPMethod void Draw(XMPFacet* facet, XMPShape* invalidShape);

   // -Memory Management-
   XMPMethod XMPSize Purge(XMPSize size);

   // -Part Activation-
   XMPMethod void CommitRelinquishFocus(XMPTypeToken focus,
                                XMPFrame* ownerFrame,
                                XMPFrame* proposedFrame);
   XMPMethod void FocusAcquired(XMPTypeToken focus, XMPFrame* ownerFrame);
   XMPMethod void FocusLost(XMPTypeToken focus, XMPFrame* ownerFrame);

   // -Storage-
   XMPMethod void Externalize();
   XMPMethod void CloneInto(XMPDraftKey key, XMPStorageUnit* storageUnit, XMPStorageUnit* initiatingFrameSU);

   // -UI Events-
   XMPMethod XMPBoolean HandleEvent(XMPEventData event, XMPFrame* frame, XMPFacet* facet);

   // -Undo-

      //PRIVATE BY CONVENTION -- needed by SimplePart's object accessors
   XMPMethod XMPSemanticInterface* GetSemanticInterface(){return fSemtIntf;}

protected:

   friend XMPPart* EXPENTRY CreatePart(void);
   // -constructor/destructor-
   SimplePart();
   virtual ~SimplePart();

   XMPMethod void InitPart(XMPStorageUnit* storageUnit);
   XMPMethod void InitPartFromStorage(XMPStorageUnit* storageUnit);
   XMPNVMethod void CommonInitSimplePart();

   XMPMethod void Release();

   // -Embedding-

   // -Imaging-

   // -UI Events-
   XMPMethod XMPBoolean HandleMouseDown(XMPFacet* facet,
                               XMPPoint where,
                               XMPEventData event);
   XMPMethod XMPBoolean HandleKeyDown(XMPFrame* focusFrame, XMPEventData event);


   // -utilities-
   XMPMethod void ActivateFrame(XMPFrame* frame);
   XMPMethod void DeActivateFrame(XMPFrame* frame);
   XMPMethod void ActivatingWindow(XMPFrame* frame);
   XMPMethod void DeActivatingWindow(XMPFrame* frame);
   XMPMethod void SetBGColor(XMPFrame* aFrame, XMPCommandID whichColor);
   XMPMethod void UserSetBGColor(XMPFrame* frame, RGBColor whichColor);
   XMPMethod void SetBGColor(XMPFrame* aFrame, RGBColor whichColor);
   XMPMethod void SetGrafPortOrigin(XMPFacet* facet);

   XMPMethod void GetBGColor(XMPUShort whichColor, RGBColor* newColor);
   XMPMethod XMPWindow* CreateWindow(XMPFrame* sourceFrame);

private:

   OrderedCollection*   fDisplayFrames;
   XMPID          fWindowID;        // ID of View As Window window

   XMPULong       fFrameGroupIDCounter;
   Point          fDragStart;

   RGBColor        fDefaultColor; // Initial background color of all display frames
   OrderedCollection*   fContents;

   XMPFocusSet*      fFocusSet;
   XMPTypeToken      fSelectionFocus;
   XMPTypeToken      fMenuFocus;
   XMPTypeToken      fKeyFocus;

   XMPSemanticInterface*   fSemtIntf;

   XMPStorageUnit*         fTestDrawSU;
};


#endif // _KEYBPART_
