/******************************************************************************/
/*                                                                            */
/* COPYRIGHT:                                                                 */
/* ----------                                                                 */
/* Copyright (C) International Business Machines Corp., 1994.                 */
/*                                                                            */
/*                                                                            */  
/* DISCLAIMER OF WARRANTIES:                                                  */
/* -------------------------                                                  */
/* The following [enclosed] code is sample code created by IBM                */
/* Corporation.  This sample code is not part of any standard IBM product     */
/* and is provided to you solely for the purpose of assisting you in the      */
/* development of your applications.  The code is provided "AS IS",           */
/* without warranty of any kind.  IBM shall not be liable for any damages     */
/* arising out of your use of the sample code, even if they have been         */
/* advised of the possibility of such damages.                                */
/*                                                                            */
/******************************************************************************/
/*
   File:    ClockPrt.cpp

   Contains:   Implementation of class ClockPrt

   Written by: Kirk Searls

   Change History (most recent first):

              5/20/94 CED      Fixes to externalize properly

*/

#define INCL_GPI
#define INCL_WIN

#ifndef _ALTPOINT_
#include "AltPoint.h"         // Use C++ savvy XMPPoint and XMPRect
#endif

#ifndef _ARBITRAT_
#include "Arbitrat.h"
#endif

#ifndef _STORAGE_
#include "Storage.h"
#endif

#ifndef _SUVIEW_
#include "SUView.h"
#endif

#ifndef _FRAME_
#include "Frame.h"
#endif

#ifndef _FACET_
#include "Facet.h"
#endif

#ifndef _STORAGEU_
#include "StorageU.h"
#endif

#ifndef _XMPSESSN_
#include "XMPSessn.h"
#endif

#ifndef _DISPTCH_
#include "Disptch.h"
#endif

#ifndef _DISPATCHM_
#include "DisptchM.h"
#endif

#ifndef _EXCEPT_
#include "Except.h"
#endif

#ifndef _WINDOW_
#include "Window.h"
#endif

#ifndef _FOCI_
#include "Foci.h"
#endif

#ifndef _FOCUSSET_
#include "FocusSet.h"
#endif

#ifndef _CMDDEFS_
#include "CmdDefs.h"
#endif

#ifndef _ARBITRAT_
#include "Arbitrat.h"
#endif

#ifndef _ISOSTRING_
#include "ISOStr.h"
#endif

#ifndef _SHAPE_
#include "shape.h"
#endif

#ifndef _CANVAS_
#include "canvas.h"
#endif

#ifndef _TRNSFORM_
#include "Trnsform.h"
#endif

#ifndef _CLOCKPRT_
#include "ClockPrt.h"
#endif

#ifndef _STDPROPS_
#include "StdProps.h"
#endif

#ifndef _STDTYPES_
#include "StdTypes.h"
#endif

#ifndef _XMPUTILS_
#include "XMPUtils.h"
#endif

#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif

//==============================================================================
// Constants
//==============================================================================
const char *pszClassName = "ClockTimerWindow";

//==============================================================================
// Function Prototypes
//==============================================================================
MRESULT EXPENTRY fnTimerWndProc(HWND hwnd, LONG msg, MPARAM mp1, MPARAM mp2);

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// ClockPrt
//==============================================================================

// "Standard" function to create instance of the part object.

extern "C"
XMPPart* EXPENTRY CreatePart()
{
   return new ClockPrt();
}

ClockPrt::ClockPrt()
{
  this-> fInitialized = kXMPFalse;
  this-> clock = 0;
  this-> fTestClockSU = 0;
  this-> fDisplayFrames = 0;
}

ClockPrt::~ClockPrt()
{
  delete this-> clock;
  XMPDeleteObject(fDisplayFrames);// Release the display frames collection.
                          // Deletion of memory used by the object will be
                          // reclaimed when the shell deletes the
                          // instantiation.
  XMPReleaseObject(fTestClockSU);

}

void ClockPrt::IncrementRefCount()
{
   XMPRefCntObject::IncrementRefCount();
}

void ClockPrt::Release()
{
   XMPRefCntObject::Release();
   if (this->GetRefCount() == 0)
      this->GetStorageUnit()->GetDraft()->ReleasePart(this);
}

void ClockPrt::InitPart(XMPStorageUnit* storageUnit)
{
   if (fInitialized)
      return;

   XMPPersistentObject::InitPersistentObject(storageUnit);

   fSession = storageUnit->GetSession();

   this-> Initialize();

   storageUnit->AddProperty(kXMPPropContents)->AddValue(kXMPKindTestClock);   

   fTestClockSU = storageUnit->GetDraft()->CreateStorageUnit();

   fTestClockSU->AddProperty(kXMPPropDisplayFrames)->AddValue(kXMPID);        
}

void ClockPrt:: Initialize()
{
   this-> fInitialized = kXMPTrue;

   fDisplayFrames = new OrderedCollection;      // Create an empty collection for storing the list 

   fSelectionFocus = fSession->Tokenize(kXMPSelectionFocus);
   fMenuFocus = fSession->Tokenize(kXMPMenuFocus);
   fKeyFocus = fSession->Tokenize(kXMPKeyFocus);

   fFocusSet = new XMPFocusSet();
   fFocusSet->InitFocusSet();
   fFocusSet->Add(fSelectionFocus);
   fFocusSet->Add(fMenuFocus);
   fFocusSet->Add(fKeyFocus);

   // Create a PS to use for when i need to frame things and don't have a PS.
   SIZEL sizlPage = {0, 0};
   hdcMem = DevOpenDC   (1 , OD_MEMORY, "*", 0L, NULL, (HDC)0) ;
   hpsMem = GpiCreatePS (1 , hdcMem, &sizlPage, PU_PELS      | GPIF_DEFAULT |
                                                GPIT_MICRO   | GPIA_ASSOC) ;
   clock = new Clock;

   // Create an object window to handle timer messages then start
   // a timer.

   HAB hab = 1;    // For now, until we have a defined way of getting a hab.
   CLASSINFO classInfo;

   if (!WinQueryClassInfo(hab, pszClassName, &classInfo))
   {
      WinRegisterClass(hab, pszClassName, (PFNWP)fnTimerWndProc, 0, 4);
   } 

   TimerWndCtlData ctlData = { sizeof(TimerWndCtlData), this};

   hwndTimerWindow = WinCreateWindow(
                      HWND_OBJECT,           // parent
                      pszClassName,          // window class
                      0,                     // window style
                      NULL,                  // name
                      0, 0, 0, 0,            // position & size
                      0,                     // owner
                      HWND_TOP,              // sibling
                      0,                     // id
                      &ctlData,              // control data
                      NULL);                 // presentation parameters
}

void ClockPrt::InitPartFromStorage(XMPStorageUnit* storageUnit)
{
   if (fInitialized)
      return;

   XMPPersistentObject::InitPersistentObjectFromStorage(storageUnit);

   fSession = storageUnit->GetSession();

   this-> Initialize();

   XMPULong valueSize, offset;
   XMPStorageUnitRef aSURef;
   XMPFrame* aFrame;
   XMPStorageUnit* su;

   su = this->GetStorageUnit();
   su->Focus(kXMPPropContents,kXMPPosSame,kXMPKindTestClock,1,kXMPPosFirstSib);
   su->GetValue(sizeof(XMPStorageUnitRef),&aSURef);
   fTestClockSU = su->GetDraft()->GetStorageUnit(su->GetIDFromStorageUnitRef(aSURef));
   su = fTestClockSU;
   
   su->Focus(kXMPPropDisplayFrames,kXMPPosUndefined,0,1,kXMPPosFirstSib);
   valueSize = su->GetSize();
   for (offset = 0; offset < valueSize; offset += sizeof(XMPStorageUnitRef))
   {
      su->SetOffset(offset);
      su->GetValue(sizeof(XMPStorageUnitRef), (XMPValue)&aSURef);
      
      TRY
      
         aFrame = su->GetDraft()->GetFrame(su->GetIDFromStorageUnitRef(aSURef));
         fDisplayFrames->AddLast((ElementType)aFrame);
         this->Resize(aFrame);
      
      CATCH_ALL
      
         aFrame = kXMPNULL;

      ENDTRY
   }
   
   // We should minimize the frame shape here, but we can't because I think that
   // the fPart and fPartInfo for the frame hasn't been set up yet.
   // this->MinimizeFrameShape(dispFrame);   
}

//-------------------------------------------------------------------------
// From DragAndDrop protocol
//-------------------------------------------------------------------------

// --- FulfillPromise ---

void ClockPrt::FulfillPromise(XMPStorageUnitView *promiseSUView)
{
XMPUnused(promiseSUView);
}

// --- DropCompleted ---

void ClockPrt::DropCompleted(XMPPart* destPart,
                        XMPDropResult dropResult)
{
XMPUnused(destPart);
XMPUnused(dropResult);
}

// --- DragEnter ---

MRESULT ClockPrt::DragEnter(XMPDragItemIterator* dragInfo,
                     XMPFacet* facet,
                     XMPPoint where)
{
XMPUnused(dragInfo);
XMPUnused(facet);
XMPUnused(where);
 return MRFROM2SHORT (DOR_NEVERDROP, DO_UNKNOWN);
}

// --- DragWithin ---

MRESULT ClockPrt::DragWithin(XMPDragItemIterator* dragInfo,
                     XMPFacet* facet,
                     XMPPoint where)
{
XMPUnused(dragInfo);
XMPUnused(facet);
XMPUnused(where);
 return MRFROM2SHORT (DOR_NEVERDROP, DO_UNKNOWN);
}

// --- DragLeave ---

void ClockPrt::DragLeave(XMPFacet* facet,
                     XMPPoint where)
{
XMPUnused(facet);
XMPUnused(where);
}

// --- Drop ---

XMPDropResult ClockPrt::Drop(XMPDragItemIterator* dropInfo,
                        XMPFacet* facet,
                        XMPPoint where)
{
XMPUnused(dropInfo);
XMPUnused(facet);
XMPUnused(where);
   return kXMPDropFail;
}

//-------------------------------------------------------------------------
// From Embedding protocol
//-------------------------------------------------------------------------

// --- ContainingPartPropertiesChanged ---

void ClockPrt::ContainingPartPropertiesChanged(XMPFrame* displayFrame,
                                     XMPStorageUnit* propertyUnit)
{
XMPUnused(displayFrame);
XMPUnused(propertyUnit);
}

   // ********* for containing parts *********

// --- GetContainingPartProperties ---

XMPStorageUnit* ClockPrt::GetContainingPartProperties(XMPFrame* displayFrame)
{
XMPUnused(displayFrame);
   THROW(kXMPErrCannotEmbed);
   return nil;
}

// --- RevealFrame ---

void ClockPrt::RevealFrame(XMPFrame* embeddedFrame)
{
XMPUnused(embeddedFrame);

   THROW(kXMPErrCannotEmbed);
}

// --- EmbeddedFrameSpec ---

void ClockPrt::EmbeddedFrameSpec(XMPFrame* embeddedFrame, XMPObjectSpec* spec)
{
XMPUnused(embeddedFrame);
XMPUnused(spec);

   THROW(kXMPErrCannotEmbed);
}

// --- CreateEmbeddedFramesIterator ---

XMPEmbeddedFramesIterator* ClockPrt::CreateEmbeddedFramesIterator()
{
   THROW(kXMPErrCannotEmbed);
   // return new XMPEmbeddedFramesIterator(this);
   return nil;
}


//-------------------------------------------------------------------------
// from Frame protocol:
//-------------------------------------------------------------------------

// --- AddDisplayFrame ---

void ClockPrt::AddDisplayFrame(XMPFrame* frame)
{
   PartInfoRec* pInfo = new PartInfoRec;
   if (frame->IsRoot())
      pInfo->fNeedsActivating = kXMPTrue;

   frame->SetPartInfo((XMPInfoType) pInfo);

   fDisplayFrames->AddLast(frame);
   frame->IncrementRefCount();
// this-> Resize( frame );
}

// --- AttachSourceFrame ---

void ClockPrt::AttachSourceFrame(XMPFrame* frame, XMPFrame* sourceFrame)
{
XMPUnused(frame);
XMPUnused(sourceFrame);
}

// --- RemoveDisplayFrame ---

void ClockPrt::RemoveDisplayFrame(XMPFrame* frame)
{
   if (fDisplayFrames->Contains(frame))
   {
      PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
      frame->SetPartInfo((XMPInfoType) kXMPNULL);
      delete pInfo;
      fDisplayFrames->Remove(frame);
      frame->Release();
   }
   else
      THROW(kXMPErrInvalidFrame);

}

// --- CloseDisplayFrame ---

void ClockPrt::CloseDisplayFrame(XMPFrame* frame)
{
   if (fDisplayFrames->Contains(frame))
   {
      fSession->GetArbitrator()->RelinquishFocusSet(fFocusSet, frame);

      PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
      frame->SetPartInfo((XMPInfoType) kXMPNULL);
      delete pInfo;
      fDisplayFrames->Remove(frame);
      XMPReleaseObject(frame);
   }
   else
      THROW(kXMPErrInvalidFrame);
}

// --- FrameShapeChanged ---

void ClockPrt::FrameShapeChanged(XMPFrame* frame)
{
   this-> Resize( frame);
   XMPFrameFacetIterator* facets = frame->CreateFacetIterator();
   for (XMPFacet* facet = facets->First();
      facets->IsNotComplete();
      facet = facets->Next())
   {
      XMPShape* activeShape = new XMPShape;
      activeShape->CopyFrom(frame->GetUsedShape());
      facet->ChangeActiveShape(activeShape);
   }
   delete facets;
}

void ClockPrt::Resize(XMPFrame* frame)
{
   HRGN  hrgnFrame;
   HRGN  hrgnUsed;
   RECTL rclFrame;
   LONG  cxFrame, cyFrame;

   hrgnFrame = (HRGN)frame-> GetFrameShape()->GetPlatformShape(kXMPOS2PM);

   /* square the frame (using device coords for now) */

   GpiQueryRegionBox(hpsMem, hrgnFrame, &rclFrame);
   cxFrame = rclFrame.xRight - rclFrame.xLeft;
   cyFrame = rclFrame.yTop - rclFrame.yBottom;
   if (cxFrame > cyFrame) 
      rclFrame.xRight = rclFrame.xLeft + cyFrame;
   else if (cxFrame < cyFrame)
      rclFrame.yTop = rclFrame.yBottom + cxFrame;

   /* request the new frame shape */

   XMPShape* requestedShape = new XMPShape;
   XMPRect frameRect(rclFrame);
   requestedShape->SetRectangle(&frameRect);
   frame->RequestFrameShape(requestedShape);
   requestedShape = kXMPNULL;      // shape now owned by frame

   /* Calculate the Used shape */

   hrgnFrame = (HRGN)frame-> GetFrameShape()->GetPlatformShape(kXMPOS2PM);
   GpiQueryRegionBox(hpsMem, hrgnFrame, &rclFrame);
   clock-> Size( rclFrame, &hrgnUsed);
   
   requestedShape = new XMPShape;
   requestedShape->SetQDRegion(hrgnUsed);
   frame->ChangeUsedShape(requestedShape);
}
// --- ViewTypeChanged ---

void ClockPrt::ViewTypeChanged(XMPFrame* frame)
{
XMPUnused(frame);
}

// --- PresentationChanged ---

void ClockPrt::PresentationChanged(XMPFrame* frame)
{
XMPUnused(frame);
}

// --- WritePartInfo ---

void ClockPrt::WritePartInfo(XMPPtr partInfo, XMPStorageUnitView* storageUnitView)
{
   if (partInfo)
   {
      XMPBoolean needsActivating = ((PartInfoRec*)partInfo)->fNeedsActivating 
                           || ((PartInfoRec*)partInfo)->fIsActive;
      storageUnitView->SetValue(sizeof(XMPBoolean),
                           (XMPValue)&needsActivating);
   }
}

// --- ReadPartInfo ---

XMPPtr ClockPrt::ReadPartInfo(XMPFrame* frame, XMPStorageUnitView* storageUnitView)
{
   XMPUnused(frame);
   if (storageUnitView->GetSize())
   {
      PartInfoRec* partInfo = new PartInfoRec;
      
      XMPBoolean needsActivating;
      storageUnitView->GetValue(sizeof(XMPBoolean),
                           (XMPValue)&(needsActivating));
      partInfo->fNeedsActivating = needsActivating;
                           
      return partInfo;
   }
   else
      return ((XMPPtr)kXMPNULL);
}

// --- Open ---

XMPID ClockPrt::Open(XMPFrame* frame)
{
   XMPUnused(frame);

   return 0;
}

   // ********* for containing parts *********

// --- CreateEmbeddedFrame ---

XMPFrame* ClockPrt::CreateEmbeddedFrame(XMPFrame* containingFrame,
                                XMPShape* frameShape,
                                XMPTransform* externalTransform,
                                XMPPart* embedPart,
                                XMPTypeToken viewType,
                                XMPTypeToken presentation,
                                XMPID frameGroupID,
                                XMPBoolean isOverlaid)
{
XMPUnused(containingFrame);
XMPUnused(frameShape);
XMPUnused(externalTransform);
XMPUnused(embedPart);
XMPUnused(viewType);
XMPUnused(presentation);
XMPUnused(frameGroupID);
XMPUnused(isOverlaid);

   THROW(kXMPErrCannotEmbed);
   return nil;
}

// --- RemoveEmbeddedFrame ---

void ClockPrt::RemoveEmbeddedFrame(XMPFrame* embeddedFrame)
{
XMPUnused(embeddedFrame);

   THROW(kXMPErrCannotEmbed);
}

// --- RequestFrameShape ---

XMPShape* ClockPrt::RequestFrameShape(XMPFrame* embeddedFrame, XMPShape* frameShape)
{
XMPUnused(embeddedFrame);
XMPUnused(frameShape);

   THROW(kXMPErrCannotEmbed);
   return nil;
}

// --- UsedShapeChanged ---

void ClockPrt::UsedShapeChanged(XMPFrame* embeddedFrame)
{
XMPUnused(embeddedFrame);
}

// --- AdjustBorderShape ---

XMPShape* ClockPrt::AdjustBorderShape(XMPFrame* embeddedFrame, XMPShape* shape)
{
XMPUnused(embeddedFrame);

   return shape;
}

//-------------------------------------------------------------------------
// From Facet protocol
//-------------------------------------------------------------------------

// --- FacetAdded ---

void ClockPrt::FacetAdded(XMPFacet* facet)
{
   XMPShape* activeShape = new XMPShape;
   activeShape->CopyFrom(facet->GetFrame()->GetUsedShape());
   facet->ChangeActiveShape(activeShape);
}

// --- FacetRemoved ---

void ClockPrt::FacetRemoved(XMPFacet* facet)
{
XMPUnused(facet);
}

// --- ClipShapeChanged ---

void ClockPrt::ClipShapeChanged(XMPFacet* facet)
{
XMPUnused(facet);
}

// --- ExternalTransformChanged ---

void ClockPrt::ExternalTransformChanged(XMPFacet* facet)
{
XMPUnused(facet);
}

//-------------------------------------------------------------------------
// From Imaging protocol
//-------------------------------------------------------------------------

// --- Draw ---

#define XGRID 60
#define YGRID 60

void ClockPrt:: Draw(XMPFacet* facet, XMPShape* invalidShape)
{
   DisplayClock( facet, drawClock);
}

void ClockPrt:: DisplayClock(XMPFacet* facet, DrawType whatToDraw)
{
   HPS hps = facet->GetCanvas()->GetPlatformCanvas();

   /* Get our clip region */
   XMPShape* clipShape = new XMPShape;
   clipShape->CopyFrom(facet->GetAggregateClipShape());
   HRGN hrgnClip = clipShape->Transform(facet->GetContentTransform())->GetQDRegion();

   /* Get the offset of the frame in the presentation space */
   POINTL ptl = facet->GetContentTransform()->TransformPoint(XMPPoint(0,0)).AsPOINTL();

   GpiSavePS(hps);

   // Don't delete clipShape until we reset the clip region

   // --- put drawing code here.

   if( whatToDraw == drawClock )
   {
     clock-> Draw( hps, &ptl, hrgnClip);
   }
   else
   {
      HRGN hrgnInvalid = clock-> Timer( hps, &ptl, hrgnClip);
      if (hrgnInvalid != kXMPNULL) 
      {
         XMPShape *invalidShape = new XMPShape;
         RECTL rcl;
         GpiQueryRegionBox(hps, hrgnInvalid, &rcl);
         invalidShape->SetRegion(hrgnInvalid);
         hrgnInvalid = kXMPNULL;              // shape owns region now
         facet->Invalidate(invalidShape);
         delete invalidShape;
      } 
   }

   delete clipShape;

   GpiRestorePS(hps, -1);
}

// --- CanvasUpdated ---

void ClockPrt::CanvasUpdated(XMPCanvas* canvas)
{
XMPUnused(canvas);
}

// --- HighlightChanged ---

void ClockPrt::HighlightChanged(XMPFrame* frame)
{
XMPUnused(frame);
}

// --- GetPrintResolution ---

XMPULong ClockPrt::GetPrintResolution(XMPFrame* frame)
{
XMPUnused(frame);

   return 0;
}

//-------------------------------------------------------------------------
// From Linking protocol
//-------------------------------------------------------------------------

// --- CreateLink ---

XMPLink* ClockPrt::CreateLink(XMPPtr data, XMPULong size)
{
XMPUnused(data);
XMPUnused(size);
   return nil;
}

// --- LinkUpdated ---

void ClockPrt::LinkUpdated(XMPLink* updatedLink, XMPChangeID id)
{
XMPUnused(updatedLink);
XMPUnused(id);
}

// --- RevealLink ---

void ClockPrt::RevealLink(XMPLinkSource* linkSource)
{
XMPUnused(linkSource);
}

void ClockPrt::EmbeddedFrameChanged(XMPFrame* frame, XMPChangeID change)
{
XMPUnused(change);
XMPUnused(frame);
}

void ClockPrt::LinkStatusChanged(XMPFrame* frame)
{
XMPUnused(frame);
}

//-------------------------------------------------------------------------
// From Memory Management protocol
//-------------------------------------------------------------------------

XMPSize ClockPrt::Purge(XMPSize size)
{
   return size; // return fStorageUnit->Purge(size);
}

//-------------------------------------------------------------------------
// From Part Activation protocol
//-------------------------------------------------------------------------

// --- BeginRelinquishFocus ---

XMPBoolean ClockPrt::BeginRelinquishFocus(XMPTypeToken focus,
                                 XMPFrame* ownerFrame,
                                 XMPFrame* proposedFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
XMPUnused(proposedFrame);

   return kXMPTrue;
}

// --- CommitRelinquishFocus ---

void ClockPrt::CommitRelinquishFocus(XMPTypeToken focus,
                              XMPFrame* ownerFrame,
                              XMPFrame* proposedFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
XMPUnused(proposedFrame);
   this-> FocusLost( focus, ownerFrame);
}

// --- AbortRelinquishFocus ---

void ClockPrt::AbortRelinquishFocus(XMPTypeToken focus,
                             XMPFrame* ownerFrame,
                             XMPFrame* proposedFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
XMPUnused(proposedFrame);
}

// --- FocusAcquired ---

void ClockPrt::FocusAcquired(XMPTypeToken focus, XMPFrame* ownerFrame)
{
   if (focus == fSelectionFocus) 
   {
      PartInfoRec* pInfo = (PartInfoRec*) ownerFrame->GetPartInfo();
      pInfo->fIsActive = kXMPTrue;
   }
}

// --- FocusLost ---

void ClockPrt::FocusLost(XMPTypeToken focus, XMPFrame* oldOwner)
{
   if (focus == fSelectionFocus) 
   {
      PartInfoRec* pInfo = (PartInfoRec*) oldOwner->GetPartInfo();
      pInfo->fIsActive = kXMPFalse;
   }
}

//-------------------------------------------------------------------------
// From Storage protocol
//-------------------------------------------------------------------------

// --- Externalize ---

void ClockPrt::Externalize()
{
   XMPPersistentObject::Externalize();

   XMPFrame* aFrame;
   XMPStorageUnitRef aSURef;
   XMPULong offset, offsetLimit;
   XMPStorageUnit* su = fTestClockSU;

   OrderedCollectionIterator aIter(fDisplayFrames);
   su->Focus(kXMPPropDisplayFrames,kXMPPosUndefined,0,1,kXMPPosFirstSib);
   offsetLimit = su->GetSize();
   offset = 0;
   for (aFrame = (XMPFrame*)aIter.First(); aIter.IsNotComplete();
                                 aFrame = (XMPFrame*)aIter.Next(),
                                 offset+=sizeof(XMPStorageUnitRef))
   {
      aSURef = su->GetWeakStorageUnitRef(aFrame->GetStorageUnit());
      su->SetOffset(offset);
      su->SetValue(sizeof(XMPStorageUnitRef), (XMPValue)&aSURef);
   }

   if (offset < offsetLimit)
      su->DeleteValue(offsetLimit - offset);
      
   su = this->GetStorageUnit();
   su->Focus(kXMPPropContents,kXMPPosSame,kXMPKindTestClock,1,kXMPPosFirstSib);
   aSURef = su->GetStrongStorageUnitRef(fTestClockSU);
   su->SetValue(sizeof(XMPStorageUnitRef),&aSURef);

}

// --- CloneTo ---

void ClockPrt::CloneInto(XMPDraftKey key, XMPStorageUnit* storageUnit, XMPStorageUnit* initiatingFrameSU)
{
   XMPStorageUnit*   su = this->GetStorageUnit();
   XMPDraft*      draft = su->GetDraft();

XMPVolatile(draft);

   this->Externalize();
   TRY

      su->CloneInto(key, storageUnit, initiatingFrameSU);

   CATCH_ALL

      draft->AbortClone(key);

   ENDTRY
}


//-------------------------------------------------------------------------
// From Binding protocol
//-------------------------------------------------------------------------

// --- ExternalizeKinds ---

void ClockPrt::ExternalizeKinds(XMPTypeSet* kindset)
{
XMPUnused(kindset);
   this->Externalize();
}

// --- ChangeKind ---

void ClockPrt::ChangeKind(XMPType kind)
{
XMPUnused(kind);
}

//-------------------------------------------------------------------------
// From UI Events protocol
//-------------------------------------------------------------------------


// --- HandleEvent ---

XMPBoolean ClockPrt::HandleEvent(XMPEventData event, XMPFrame* frame, XMPFacet* facet)
{
XMPUnused(facet);

  switch( event-> what)
  {
  case kXMPEvtMouseDown:
  {
     if (event->msg == WM_BUTTON1DOWN || event->msg == WM_BUTTON2DOWN)
     {
        if (!facet->GetWindow()->IsActive())
           facet->GetWindow()->Select();
        else
          this->ActivateFrame(frame);
     }
     break;
  }
  case kXMPEvtActivate:
  {
     PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
     if (SHORT1FROMMP(event->mp1) != 0)
     {
        if (pInfo->fNeedsActivating)
        {
           this->ActivateFrame(frame);
           pInfo->fNeedsActivating = kXMPFalse;
        }
     }
     else
     {
        if (frame == fSession->GetArbitrator()->GetFocusOwner(fSelectionFocus))
           pInfo->fNeedsActivating = kXMPTrue;
        else
           pInfo->fNeedsActivating = kXMPFalse;
     }
     break;
  }
  default :
     break;
  }
   return kXMPFalse;
}

// --- MouseEnter ---

void ClockPrt::MouseEnter(XMPFacet* facet, XMPPoint where)
{
XMPUnused(facet);
XMPUnused(where);
}

// --- MouseWithin ---

void ClockPrt::MouseWithin(XMPFacet* facet, XMPPoint where)
{
XMPUnused(facet);
XMPUnused(where);
}

// --- MouseLeave ---

void ClockPrt::MouseLeave(XMPFacet* facet)
{
XMPUnused(facet);
}

// --- AdjustMenus ---

void ClockPrt::AdjustMenus(XMPFrame* frame)
{
   XMPUnused(frame);
}

//-------------------------------------------------------------------------
// From Undo protocol
//-------------------------------------------------------------------------

// --- UndoAction ---

void ClockPrt::UndoAction(XMPActionData actionState)
{
XMPUnused(actionState);
}

// --- RedoAction ---

void ClockPrt::RedoAction(XMPActionData actionState)
{
XMPUnused(actionState);
}

// --- DisposeAction ---

void ClockPrt::DisposeActionState(XMPActionData actionState,
                           XMPDoneState doneState)
{
XMPUnused(actionState);
XMPUnused(doneState);
}


// --- WriteAction ---

void ClockPrt::WriteActionState(XMPPtr actionState,
                          XMPStorageUnitView* storageUnitView)
{
XMPUnused(actionState);
XMPUnused(storageUnitView);
}

// --- ReadAction ---

XMPPtr ClockPrt::ReadActionState(XMPStorageUnitView* storageUnitView)
{
XMPUnused(storageUnitView);
   return kXMPNULL;
}

//-------------------------------------------------------------------------
// private utilities
//-------------------------------------------------------------------------

// --- ActivateFrame ---

void ClockPrt::ActivateFrame(XMPFrame* frame)
{
   PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
   if (!(pInfo->fIsActive))
   {
      XMPBoolean succeeded = false;

      succeeded = fSession->GetArbitrator()->RequestFocusSet(fFocusSet,frame);

      if (succeeded)
      {
         this->FocusAcquired(fSelectionFocus, frame);
         this->FocusAcquired(fMenuFocus, frame);
         this->FocusAcquired(fKeyFocus, frame);
      }
   }
}

// --- Timer ---

void ClockPrt::Timer()
{
   OrderedCollectionIterator frames(fDisplayFrames);
   for (XMPFrame* frame = (XMPFrame*)frames.First(); 
      frames.IsNotComplete();
      frame = (XMPFrame*)frames.Next())
   {
      XMPFrameFacetIterator* facets = frame->CreateFacetIterator();
      for (XMPFacet* facet = facets->First();
         facets->IsNotComplete();
         facet = facets->Next())
      {
         this-> DisplayClock( facet, drawTimer );
      }
      delete facets;
   }
}

MRESULT EXPENTRY fnTimerWndProc(HWND hwnd, LONG msg, MPARAM mp1, MPARAM mp2)
{
   switch (msg) {
   case WM_CREATE:
      WinSetWindowPtr(hwnd, 0, ((TimerWndCtlData *)mp1)->part);
      WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 0, 1000);
      return 0;
   case WM_DESTROY:
      WinStopTimer(WinQueryAnchorBlock(hwnd), hwnd, 0);
      return 0;
   case WM_TIMER:
      {
      ClockPrt *part = (ClockPrt *)WinQueryWindowPtr(hwnd, 0);
      part->Timer();
      return 0;
      }
   default: 
      return WinDefWindowProc(hwnd, msg, mp1, mp2);
   } 
}
