/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    XMPUtils.h

  Contains:  utility functions

  Written by:  Tantek elik

*/

#ifndef _XMPUTILS_
#define _XMPUTILS_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif


class XMPStorageUnit;
class XMPStorageUnitView;


// The "do...while(0)" blocks wrapped around these macros are there to prevent syntactic
// problems if a macro call is immediately followed by an "else" statement, to keep
// the "else" from binding to the "if" in the macro body. The "while" loop is optimized
// out by the compiler and has no effect on the flow of control or code quality.  --Jens


#define  XMPDeleteObject(object)  \
  do{              \
    if (object!=kXMPNULL) {  \
      delete object;    \
      object = kXMPNULL;  \
    }            \
  }while(0)

#define  XMPReleaseObject(object) \
  do{              \
    if (object!=kXMPNULL) {  \
      object->Release();  \
      object = kXMPNULL;  \
    }            \
  }while(0)


XMPName*  XMPBlankName();
XMPName*  XMPGetName(XMPStorageUnitView* suView);
void    XMPSetName(XMPStorageUnitView* suView, XMPName* name);
void    XMPInsertName(XMPStorageUnitView* suView, XMPName* name);

void    XMPDeleteName(XMPName** name);

XMPPtr    XMPGetValuePtr(XMPStorageUnit* su);

#endif //_XMPUTILS_

