/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    XMPObj.h

  Contains:  Class definition for XMPObject

  Written by:  Joshua Susser

  Protocols:  Extensions

*/

#ifndef _XMPOBJ_
#define _XMPOBJ_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
  This file defines class XMPObject.  This class is the common base class
  for most XMP classes.  It provides for extensibility through the
  Extensions protocol.
*/

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPObject;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPExtension;

//==============================================================================
// XMPObject
//==============================================================================

#define kXMPObjectID "appl:object$class,1.0.0"

class XMPObject {

public:

  XMPObject();
  
  virtual ~XMPObject();

  XMPNVMethod  void  InitObject();
  
  //-------------------------------------------------------------------------
  // From Extensions protocol
  //-------------------------------------------------------------------------

  XMPVMethod XMPBoolean  HasExtension(XMPType extensionName);

    // answer whether this object supports the specified extension interface
  
  XMPVMethod XMPExtension*  GetExtension(XMPType extensionName);
  
    // return the specified extension interface

  XMPVMethod void      ReleaseExtension(XMPExtension* extension);

    // release resources associated with the specified extension interface.
    // may count references if necessary.

  //-------------------------------------------------------------------------
  // From Memory protocol
  //-------------------------------------------------------------------------
  
  XMPVMethod  XMPSize  Purge(XMPSize size)
    = 0;
  
    // Get rid of any unnecessary memory.
    
protected:
  XMPBoolean fInitialized;

// JSO BEGIN
// #if XMPDebug

private:

  static  XMPObject*  fFirst;
  XMPObject*      fNext;
  XMPObject*      fPrev;

public:  // private by convention

  XMPVMethod  XMPBoolean ValidateObject();
  XMPMethod  XMPObject*  GetNextObject() {return fNext;}
  XMPMethod  XMPObject*  GetPrevObject() {return fPrev;}
  static    XMPObject*  GetFirstObject();
  
// #endif

// JSO END
};


#endif // _XMPOBJ_
