/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    XMPNew.h

  Contains:  Inline versions of operator new and operator delete for OpenDoc

  Written by:  Nick Pilch

*/

#ifndef _XMPNEW_
#define _XMPNEW_

#ifndef _EXCEPT_
#include "Except.h"
#endif

#ifndef __LIBRARYMANAGER__
#include <LibraryManager.h>
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
These inline versions are supplemented by "out-line" versions in XMPNew.cp. You
only have to use this file if you want to use the new operator before
InitLibraryManager is called.

The ASLM default pool is used for memory allocations.
*/

//==============================================================================
// Constants
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// Classes defined in this interface
//==============================================================================

//==============================================================================
// Classes used by this interface
//==============================================================================

XMPPtr  XMPNewPtr( XMPULong );
void  XMPDisposePtr( XMPPtr );

//==============================================================================
// Global new and delete operators
//==============================================================================

//void* operator new(size_t size, TMemoryPool*);  // default size, from a pool
//void* operator new(size_t);            // from global pool
//void operator delete(void*);            // return memory to pool 

inline void* operator new(size_t size)
{
  return XMPNewPtr(size);
}

inline void operator delete(void* theMem)
{
  XMPDisposePtr(theMem);
}

#endif // _XMPNEW_