/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    XMPFile.h

  Contains:  Template for XMPFile header

  Written by:  Vincent Lo

*/

#ifndef _XMPFILE_
#define _XMPFILE_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _STORAGE_
#include "Storage.h"
#endif

//#ifndef _SESSION_
//#include "SessionM.h"
//#endif

#ifndef _NAMSPACE_  //  REMOVE THIS!!!!
#include "NamSpace.h"
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

//==============================================================================
// Constants
//==============================================================================
const  XMPSShort kXMPNoFileRefNum = 0;

//==============================================================================
// Scalar Types
//==============================================================================
typedef XMPSByte XMPFilePermission;

//==============================================================================
// Classes defined in this interface
//==============================================================================
class XMPClass;

//==============================================================================
// Classes used by this interface
//==============================================================================

//==============================================================================
// XMPFile
//==============================================================================

#define kXMPFileID "appl:xmpfile$class,1.0.0"

class XMPFile
{
public:

  XMPFile();
  virtual ~XMPFile();

  XMPMethod void Specify(XMPFileSpec* fileSpec);

  XMPMethod XMPBoolean IsStationery();

  XMPMethod void SetPermission(XMPFilePermission filePermission);

  XMPMethod void Create(XMPOSType creator, XMPOSType fileType, XMPScriptCode scriptCode);

  XMPMethod void Open();

  XMPMethod void Close();

  XMPMethod void Delete();

  XMPMethod void FlushVolume();

  XMPMethod void SetFilePos(XMPSShort posMode, XMPSLong posOff);

  XMPMethod XMPSLong GetFilePos();

  XMPMethod void Read(XMPSByte* buffer, XMPSLong* count);

  XMPMethod void Write(const XMPSByte* buffer, XMPSLong* count);

  XMPMethod XMPSLong GetEndOfFile();

  XMPMethod XMPName*  GetName();
  XMPMethod void    GetAsciiName(char* name,XMPULong maxLength);

  XMPMethod XMPOSType GetCreator();
  XMPMethod XMPOSType GetType();

  XMPMethod XMPContainerType GetContainerType();

  XMPMethod XMPFileSpec  GetFileSpec();

  XMPMethod XMPFileRefNum  GetFileRefNum();

  XMPMethod void CopyFrom( XMPFile* src );
  XMPMethod void MoveRename( XMPFileSpec* newSpec, XMPBoolean isDuplicate ) ;
  XMPMethod void Move( XMPSLong targetParID ) ;
  XMPMethod void Rename( Str63 name ) ;

private:

  XMPFileSpec      fFileSpec;
// KLS:  XMPSShort      fDataRefNum;
// KLS:  USE FILE POINTER AND fxxxx functions for now.
  FILE* fFile;
  XMPFilePermission  fPermission;
  XMPOSType      fCreator;
  XMPOSType      fFileType;
  XMPScriptCode    fScriptTag;
};

#endif // _XMPFILE_