/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    WinStatM.h

   Contains:   Interface to XMPMacWindowState class.

   Written by: Richard Rodseth

*/

#ifndef _WINSTATM_
#define _WINSTATM_

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPWindowState;            

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPSession;
class XMPDraft;
class XMPWindow;
class XMPFrame;
class XMPPart;
class LinkedList;
class XMPWindowIterator;            

//=====================================================================================
// XMPWindowState
//=====================================================================================

#define kXMPMacWindowStateID "appl:xmpmacwindowstate$class,1.0.0"

class XMPMacWindowState : public XMPAbsWindowState
{
  public:

   XMPMacWindowState();
      
   XMPVMethod ~XMPMacWindowState();
   
   XMPNVMethod void InitWindowState(XMPSession* session); 

   XMPMethod   XMPSize  Purge(XMPSize size); 
   
   XMPMethod XMPWindow*    CreateWindow(XMPPlatformWindow newWindow, 
                            XMPBoolean isRootWindow,
                            XMPBoolean isResizable,
                            XMPBoolean isFloating,
                            XMPBoolean shouldSave,
                            XMPPart* rootPart,
                            XMPTypeToken viewType,
                            XMPTypeToken presentation,
                            XMPFrame* sourceFrame);

   XMPMethod XMPWindow* GetWindow(XMPID id);
   
   XMPMethod void Internalize(XMPDraft* draft);
      
   XMPMethod void Externalize(XMPDraft* draft);
      
   XMPMethod void SetDefaultWindowTitles(XMPDraft* draft);
   
   XMPMethod void OpenWindows(XMPDraft* draft);
      
   XMPMethod void CloseWindows(XMPDraft* draft);
      
   XMPMethod XMPUShort GetWindowCount();
   
   XMPMethod XMPUShort GetRootWindowCount(XMPDraft* draft);
   
   XMPMethod XMPUShort GetTotalRootWindowCount();

   XMPBoolean IsXMPWindow(XMPPlatformWindow aWindow);

   XMPMethod XMPWindow* GetXMPWindow(XMPPlatformWindow aWindow);  
   
   XMPMethod XMPWindowIterator* CreateWindowIterator();
      
   XMPMethod XMPWindow* GetActiveWindow();
   
   XMPMethod void SetBaseMenuBar(XMPMenuBar* theMenuBar);
   
   XMPMethod XMPMenuBar* CopyBaseMenuBar();

   XMPMethod void AdjustPartMenus();

  public: // Macintosh-specific

#ifndef PLATFORM_OS2
   XMPMethod   void     DeactivateFrontWindows();
   XMPMethod   void     ActivateFrontWindows();
#endif
   XMPMethod   XMPWindow*  GetFrontWindow();
   XMPMethod   XMPWindow*  GetFrontFloatingWindow();
   XMPMethod   XMPWindow*  GetFrontRootWindow();
      
  public: // Private to UI Subsystem

   XMPMethod void SetCurrentMenuBar(XMPMenuBar* theMenuBar);
   XMPMethod XMPMenuBar* GetCurrentMenuBar();
   XMPMethod XMPWindow* AddWindow(XMPWindow* window);
   XMPMethod void RemoveWindow(XMPWindow* oldWindow);
      // Removes and disposes of the specified window
#ifndef PLATFORM_OS2
   XMPMethod XMPBoolean HandleAOCEMailerEvent(XMPEventData event);
   XMPMethod XMPBoolean HandleAOCEMailerCommand(XMPCommandID command);
   XMPMethod void UpdateAOCEMailerMenus();
   XMPMethod void SuspendResume(XMPEventData event);
   XMPMethod XMPWindow* FindXMPWindow(Point globalPoint);
#endif
   XMPMethod void ReleaseWindow(XMPWindow* window);
   XMPMethod void SelectXMPWindow(XMPWindow* window);
   XMPMethod void DragXMPWindow(XMPWindow* window, Point startPoint, Rect* draggingBounds);
   XMPMethod void ShowXMPWindow(XMPWindow* window);
   XMPMethod void HideXMPWindow(XMPWindow* window);
   XMPMethod LinkedList*   GetWindowList(); // for XMPWindowIterator
#ifndef PLATFORM_OS2
   
   // AOCE Mailer
   
   XMPMethod void SetTempMailerWindow( XMPPlatformWindow platWin ) ; 
   XMPMethod XMPPlatformWindow GetTempMailerWindow() ;   
   XMPMethod void SetMailerWindow( XMPWindow* window ) ; 
   XMPMethod void ClearMailerWindow() ;   
   XMPMethod XMPWindow* GetMailerWindow() ;
   XMPMethod XMPPlatformWindow FixUpMailerWindow( Rect* bounds,
                     Str255 title,
                     XMPSShort procID,
                     XMPBoolean hasCloseBox,
                     XMPSLong refCon) ;
#endif
#ifdef TO_BE_DELETED
   XMPMethod XMPPlatformWindow GetMailerWindow() ; 
#endif // TO_BE_DELETED

  protected:
   
   void ActivateWindow(WindowPtr platformWindow);
   void DeactivateWindow(WindowPtr platformWindow);
   void HighlightAndActivateWindow(WindowPtr platformWindow, XMPBoolean activate);
   WindowPtr   GetLastFloatingPlatformWindow();
   WindowPtr   GetFrontPlatformWindow();

  protected:

   XMPSession* fSession;
   LinkedList* fWindowList;
   XMPID    fNextID;
   
   XMPMenuBar* fBaseMenuBar;
   XMPMenuBar* fCurrentMenuBar;
#ifndef PLATFORM_OS2   
   XMPPlatformWindow fTempMailerWindow ;
   XMPWindow*        fMailerWindow ;   // the one window that has the mailer
#endif

};

#endif // _WINSTATM_
