/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    XMPWindowState.h

   Contains:   Interface to XMPAbsWindowState class.

   Written by: Richard Rodseth

*/

#ifndef _WINSTAT_
#define _WINSTAT_

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPWindowState;            // The list of XMPWindows

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPSession;
class XMPDraft;
class XMPWindow;
class XMPMenuBar;
class XMPWindowIterator;            
class XMPFrame;

//=====================================================================================
// XMPWindowState
//=====================================================================================

class XMPAbsWindowState : public XMPObject
{
  public:

   XMPAbsWindowState() {} 

   XMPVMethod ~XMPAbsWindowState() {}     
         
   XMPVMethod  XMPSize  Purge(XMPSize size)
      = 0;
   
   XMPVMethod XMPWindow*   CreateWindow(XMPPlatformWindow newWindow, 
                            XMPBoolean isRootWindow,
                            XMPBoolean isResizable,
                            XMPBoolean isFloating,
                            XMPBoolean shouldSave,
                            XMPPart* rootPart,
                            XMPTypeToken viewType,
                            XMPTypeToken presentation,
                            XMPFrame* sourceFrame)
      = 0;

   XMPVMethod XMPWindow*   GetWindow(XMPID id)
      = 0;
      
   XMPVMethod void Internalize(XMPDraft* draft)
      = 0;
      
   XMPVMethod void Externalize(XMPDraft* draft)
      = 0;
      
   XMPMethod void SetDefaultWindowTitles(XMPDraft* draft)
      = 0;

   XMPVMethod void OpenWindows(XMPDraft* draft)
      = 0;
      
   XMPVMethod void CloseWindows(XMPDraft* draft)
      = 0;
      
   XMPVMethod XMPUShort GetWindowCount()
      = 0;
   
   XMPVMethod XMPUShort GetRootWindowCount(XMPDraft* draft)
      = 0;
   
   XMPVMethod XMPUShort GetTotalRootWindowCount()
      = 0;

   XMPVMethod XMPBoolean IsXMPWindow(XMPPlatformWindow aWindow)
      = 0;
      
   XMPVMethod XMPWindow* GetXMPWindow(XMPPlatformWindow aWindow)
      = 0;
   
   XMPVMethod XMPWindowIterator* CreateWindowIterator()
      = 0;
      
   XMPVMethod XMPWindow* GetActiveWindow()
      = 0;
   
   XMPVMethod void SetBaseMenuBar(XMPMenuBar* theMenuBar)
      = 0;
   
   XMPVMethod XMPMenuBar* CopyBaseMenuBar()
      = 0;

   XMPVMethod void AdjustPartMenus()
      = 0;
};

#ifdef PLATFORM_MACINTOSH
#ifndef _WINSTATM_
#include "WinStatM.h"
#endif
#endif

#endif // _WINSTAT_
