/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    WinIter.h

   Contains:   Interface to XMPWindowIterator class.

   Written by: Richard Rodseth

*/

#ifndef _WINITER_
#define _WINITER_

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPWindowIterator;            // An iterator for all windows

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPWindowState;
class XMPWindow;
class LinkedListIterator;

//=====================================================================================
// Class XMPWindowIterator
//=====================================================================================

#define kXMPWindowIteratorID "appl:xmpwindowiterator$class,1.0.0"

class XMPWindowIterator
{
public:

   virtual ~XMPWindowIterator();
   
   XMPMethod XMPWindow* First();
      
   XMPMethod XMPWindow* Next();

   XMPMethod XMPWindow* Last();
      
   XMPMethod XMPWindow* Previous();
      
   XMPMethod XMPBoolean IsNotComplete();

public: // Private to UI subsystem

   XMPWindowIterator();
            
   XMPNVMethod void InitWindowIterator(XMPWindowState* windowState);

private:

   XMPWindowState* fWindowState;
   LinkedListIterator* fIterator;
};

#endif // _WINITER_
