/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    UndoM.h

   Contains:   Class definition for XMPMacUndo

   Written by: Nick Pilch

*/

#ifndef _UNDOM_
#define _UNDOM_

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPMacUndo;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPSystemUndo;
class XMPPart;

//==============================================================================
// XMPUndo
//==============================================================================

#define kXMPMacUndoID "appl:xmpmacundo$class,1.0.0"

class XMPMacUndo : public XMPAbsUndo
{
  public:

   XMPVMethod XMPSize Purge(XMPSize size);

   XMPVMethod void AddActionToHistory(XMPPart* whichPart, 
                           XMPActionData actionData,
                           XMPActionType actionType,
                           XMPName* undoActionLabel,
                           XMPName* redoActionLabel);

   XMPVMethod void Undo();

   XMPVMethod void Redo();

   XMPVMethod void MarkActionHistory();

   XMPVMethod void ClearActionHistory(XMPRespectMarksChoices respectMarks);

   XMPVMethod void ClearRedoHistory();

   XMPVMethod XMPBoolean PeekUndoHistory(XMPPart** part,
                        XMPActionData* actionData,
                        XMPActionType* actionType,
                        XMPName** actionLabel);
   
   XMPVMethod XMPBoolean PeekRedoHistory(XMPPart** part,
                        XMPActionData* actionData,
                        XMPActionType* actionType,
                        XMPName** actionLabel);
   
  public: // Private by convention

   XMPMacUndo();
   XMPVMethod ~XMPMacUndo();
   XMPNVMethod void InitUndo();
   
  private:

   XMPSystemUndo* fSystemUndo; // THIS MAY BE NULL!
};

#endif // _UNDO_
