/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    Undo.h

   Contains:   Class definition for XMPAbsUndo

   Written by: Vincent Lo, Nick Pilch

*/

#ifndef _UNDO_
#define _UNDO_

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//==============================================================================
// Constants
//==============================================================================

enum XMPRespectMarksChoices
{ 
   kXMPDontRespectMarks,
   kXMPRespectMarks 
};

enum XMPActionType
{
   kXMPSingleAction,
   kXMPBeginAction,
   kXMPEndAction
};

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPAbsUndo;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPPart;

//==============================================================================
// XMPUndo
//==============================================================================

class XMPAbsUndo : public XMPObject
{
  public:

   XMPAbsUndo() {}
   XMPVMethod ~XMPAbsUndo() {}
   
   XMPVMethod XMPSize Purge(XMPSize size)
      = 0;

   XMPVMethod void AddActionToHistory(XMPPart* whichPart, 
                           XMPActionData actionData,
                           XMPActionType actionType,
                           XMPName* undoActionLabel,
                           XMPName* redoActionLabel)
      = 0;

   XMPVMethod void Undo()
      = 0;

   XMPVMethod void Redo()
      = 0;

   XMPVMethod void MarkActionHistory()
      = 0;

   XMPVMethod void ClearActionHistory(XMPRespectMarksChoices respectMarks)
      = 0;

   XMPVMethod void ClearRedoHistory()
      = 0;

   XMPVMethod XMPBoolean PeekUndoHistory(XMPPart** part,
                        XMPActionData* actionData,
                        XMPActionType* actionType,
                        XMPName** actionLabel)
      = 0;
   
   XMPVMethod XMPBoolean PeekRedoHistory(XMPPart** part,
                        XMPActionData* actionData,
                        XMPActionType* actionType,
                        XMPName** actionLabel)
      = 0;
};

#ifdef PLATFORM_MACINTOSH
#ifndef _UNDOM_
#include "UndoM.h"
#endif
#endif

#endif // _UNDO_
