/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    TypeSet.h

   Contains:   Class definition for TypeSet.

   Written by: Vincent Lo

*/

#ifndef _TYPESET_
#define _TYPESET_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================
class XMPTypeSet;

//=====================================================================================
// Classes used by this interface
//=====================================================================================
//class LinkedList;
class OrderedCollection;

//=====================================================================================
// Class XMPTypeSet
//=====================================================================================

#define kXMPTypeSetID "appl:xmptypeset$class,1.0.0"

class XMPTypeSet
{
   friend class   XMPTypeSetIterator;

public:

   XMPTypeSet();
   XMPTypeSet(XMPHeap where);
   
   virtual ~XMPTypeSet();
   
   XMPMethod void Add(XMPType type);
   
      // Adds a type to the end of the set, creating a copy of the argument in the set.

   XMPMethod void Remove(XMPType type);
   
      // Removes a type from a set.  Does nothing if the argument type is not present.
   
   XMPMethod XMPBoolean Contains(XMPType type);
   
      // Returns true if the set contains the specified type.
      // Otherwise, returns false.

   XMPMethod XMPULong Count();
      
   XMPVMethod XMPTypeSetIterator* CreateTypeSetIterator();
   
      // Returns an iterator for the set, which can be used to retrieve types
      // from the set in order.

private:

   OrderedCollection*   fSet; 
   XMPHeap     fHeap;
};

#endif   // _TYPESET_
