/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    TrnsfrmM.h

  Contains:  Definition of class XMPMacTransform

  Written by:  Joshua Susser & Sepp Friedrich & Jens Alfke

*/

#ifndef _TRNSFRMM_
#define _TRNSFRMM_

#ifndef __MATRIX_H
#include "matrix.h"
#endif

#ifndef _TRNSFORM_
#include "Trnsform.h"
#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"      // base class
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif


              
//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPMacTransform;

//==============================================================================
// XMPMacTransform
//==============================================================================

#define kXMPMacTransformID "appl:xmpmactransform$class,1.0.0"

class XMPMacTransform : public XMPAbsTransform
{
  
public:

  //---------------------------------
  // overrides

  XMPVMethod XMPSize Purge(XMPSize size);    // override from XMPObject

  //---------------------------------
  // constructor/destructor
  
  XMPMacTransform( );

  XMPVMethod ~XMPMacTransform();
  
  //---------------------------------
  // getters/setters:

  XMPMethod XMPGraphicsSystem GetGraphicsSystem();

  XMPMethod XMPPlatformTransform GetPlatformTransform();
  
  XMPMethod void SetPlatformTransform(XMPGraphicsSystem graphicsSystem,
                       XMPPlatformTransform platformTransform);
    
  XMPMethod XMPPlatformTransform ConvertTransform(XMPGraphicsSystem graphicsSystem);

  //---------------------------------
  // input / output:
  
  XMPMethod void WritePlatformTransform( XMPStorageUnit* );
          
  XMPMethod void ReadPlatformTransform( XMPStorageUnit* );


  //---------------------------------
  // geometry operations with transforms

  XMPMethod XMPTransform*  Reset();

  XMPMethod XMPTransform*  Invert();
  
  XMPMethod XMPTransform*  CopyFrom(XMPTransform* sourceTransform);

  XMPMethod XMPBoolean IsSameAs(XMPTransform* compareTransform);

  XMPMethod XMPTransform*  PreCompose(XMPTransform* transform);

  XMPMethod XMPTransform*  PostCompose(XMPTransform* transform);

  XMPVMethod XMPTransform* MoveBy( XMPPoint );

  //---------------------------------
  // geometry operations with points

  XMPMethod XMPPoint TransformPoint( XMPPoint);

  XMPMethod XMPPoint InvertPoint( XMPPoint );
  
  //---------------------------------
  // Mac-specific API extensions:
  //JYS: 
    XMPVMethod POINTL GetQDOffset( );
 // XMPVMethod XMPMatrix* GetGXMapping( );          // Same as a gxMapping*
 // XMPVMethod void CopyGXMapping( XMPMatrix* );      // Same as a gxMapping*

 // XMPVMethod void SetPlatformTransform( Point p )
 //           {this->SetPlatformTransform(kXMPQuickDraw, *(XMPPlatformTransform*)&p);}
    XMPVMethod void SetPlatformTransform( XMPMatrix* m );
 //           {this->SetPlatformTransform(kXMPQuickDrawGX, (XMPPlatformTransform) m);}
//JYS: Added the following protected member function
protected:  
  XMPMethod XMPMatrix* ConvertTransform();


private:

  XMPMethod void      InitTransform( );
  XMPTransform*      Compose( XMPTransform*, XMPBoolean post );

  XMPGraphicsSystem    fGraphicsSystem;
//JYS: Commented out the following code
/*
  union{
    Point        fQDOffset;
    XMPMatrix*      fGXMatrix;
    void*        fPlatformTransform;  
  };
*/
  XMPOS2Matrix         *fPlatformTransform;
  XMPOS2Matrix         *fGXInverseMatrix;    // Cached inverse matrix, used with GX
};

#endif // _TRNSFRMM_