/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    Translat.h

  Contains:  Class definition for XMPAbsTranslation.

  Written by:  Vincent Lo

*/

#ifndef _TRANSLAT_
#define _TRANSLAT_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

//=====================================================================================
// Constants
//=====================================================================================
enum {
  kXMPCannotTranslate,
  kXMPCanTranslate,
  kXMPNative
};

typedef const enum {
  kXMPPlatformFileType,
  kXMPPlatformDataType
} XMPPlatformTypeSpace;

//=====================================================================================
// Scalar Types
//=====================================================================================
typedef XMPPtr    XMPTranslateMethod;
typedef XMPULong  XMPTranslateResult;

//=====================================================================================
// Classes defined in this interface
//=====================================================================================
class XMPTypeSetIterator;
class XMPPlatformTypeSet;
class XMPPlatformTypeSetIterator;
class XMPAbsTranslation;

//=====================================================================================
// Classes used by this interface
//=====================================================================================
class XMPStorageUnitView;
class XMPTypeSet;

//=====================================================================================
// Class XMPAbsTranslation
//=====================================================================================

class XMPAbsTranslation : public XMPObject
{
public:
  
  XMPAbsTranslation() : XMPObject() {}
    
  XMPVMethod ~XMPAbsTranslation() {}
  
  XMPVMethod void InitTranslation()
    = 0;

  XMPVMethod XMPSize Purge(XMPSize size)
    = 0;
  
  XMPVMethod XMPBoolean GetTranslateMethod(XMPTypeSet* givenTypes, 
                      XMPType nativeType,
                      XMPTranslateResult*  result,
                      XMPTranslateMethod* howToTranslate)
    = 0;

  XMPVMethod XMPTypeSet*  GetTranslationOf(XMPType fromType)
    = 0;
                      
  XMPVMethod void Translate(XMPStorageUnitView* fromView,
              XMPTranslateMethod howToTranslate,
              XMPStorageUnitView* toView)
    = 0;
    
  XMPVMethod void Translate(XMPPtr fromData, 
              XMPULong fromDataSize,
              XMPType givenType,
              XMPTranslateMethod howToTranslate,
              XMPPtr* toData,
              XMPULong* toDataSize)
    = 0;
    
  XMPVMethod XMPType GetISOTypeFromPlatformType(XMPPlatformType platformType,
                         XMPPlatformTypeSpace typeSpace)
    = 0;

  XMPVMethod XMPPlatformType GetPlatformTypeFromISOType(XMPType type)
    = 0;
};

#ifdef PLATFORM_MACINTOSH
#ifndef _TRANSLAM_
#include "TranslaM.h"
#endif
#endif

#endif // _TRANSLAT_