/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    TranslaM.h

  Contains:  Class definition for XMPMacTranslation.

*/

#ifndef _TRANSLAM_
#define _TRANSLAM_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _TRANSLAT_
#include "Translat.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================
class XMPMacTranslation;

//=====================================================================================
// Classes used by this interface
//=====================================================================================
class XMPTypeSet;
class XMPStorageUnitView;

//=====================================================================================
// Class XMPMacTranslation
//=====================================================================================

#define kXMPMacTranslationID "appl:xmpmactranslation$class,1.0.0"

class XMPMacTranslation : public XMPAbsTranslation
{
public:
  
  XMPMacTranslation();
    
  XMPVMethod ~XMPMacTranslation();
  
  XMPMethod void InitTranslation();

  XMPMethod XMPSize Purge(XMPSize size);
  
  XMPMethod XMPBoolean GetTranslateMethod(XMPTypeSet* givenTypes, 
                      XMPType nativeType,
                      XMPTranslateResult*  result,
                      XMPTranslateMethod* howToTranslate);

  XMPMethod XMPTypeSet*  GetTranslationOf(XMPType fromType);
                        
  XMPMethod void Translate(XMPStorageUnitView* fromView,
              XMPTranslateMethod howToTranslate,
              XMPStorageUnitView* toView);
        
  XMPMethod void Translate(XMPPtr fromData,
              XMPULong fromDataSize,
              XMPType givenType,
              XMPTranslateMethod howToTranslate,
              XMPPtr* toData,
              XMPULong* toDataSize);
    
  XMPMethod XMPType GetISOTypeFromPlatformType(XMPPlatformType platformType,
                         XMPPlatformTypeSpace typeSpace);

  XMPMethod XMPPlatformType GetPlatformTypeFromISOType(XMPType type);
    
private:

  XMPBoolean  fMEOExists;
};

#endif // _TRANSLAM_