/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    XMPToknTabl.h

   Contains:   The XMPTokenTable class.

   Written by: Nick Pilch

*/

#ifndef _XMPTOKNTABL_
#define _XMPTOKNTABL_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   This class keeps a table of XMPTypes and their corresponding unique tokens.
*/

//==============================================================================
// Scalar Types
//==============================================================================


//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPTokenTable;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPNameSpace;
class XMPNameSpaceManager;

//==============================================================================
// XMPClass
//==============================================================================

#define kXMPTokenTableID "appl:xmptokentable$class,1.0.0"

class XMPTokenTable
{
  public:

   XMPTokenTable(XMPNameSpaceManager* mgr);
   XMPVMethod void Initialize();
   virtual ~XMPTokenTable();

   XMPVMethod XMPTypeToken Tokenize(XMPType type);
      
      // Returns a unique token for type. If the type was previously
      // tokenized, the original token is returned. Throws kXMPErrOutOfMemory
      // if tokenization fails.
   
   XMPVMethod void         RemoveEntry(XMPType type);
      
      // Removes type from the table. If type was not
      // previously tokenized, no error is signalled.
   
   XMPVMethod XMPBoolean   GetType(XMPTypeToken token, XMPType* type);
      
      // Returns type, given token. If token does not exist in the table,
      // kXMPFalse is returned. Otherwise, kXMPTrue is returned.
   
  protected:

   XMPNameSpaceManager* fNameSpaceManager;
   XMPNameSpace*        fNameSpace;
   XMPULong          fNextUniqueID;
};


#endif // _XMPTOKNTABL_
