/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    TimrList.h

   Contains:   Interface to TimerInfo, TimerList and TimerListIterator classes.

   Written by: Richard Rodseth

*/

#ifndef _TIMRLIST_
#define _TIMRLIST_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _LIST_
#include "List.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

typedef XMPULong XMPTicks; 

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class TimerInfo; 
class TimerList;            
class TimerListIterator;          

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPFrame;
class XMPPart;

//=====================================================================================
// Global Variables
//=====================================================================================

//======================================================================================
// Class TimerInfo
//======================================================================================

class TimerInfo : public Link
{
public:
   TimerInfo(XMPPart* part, XMPFrame* frame, XMPTimerFrequency frequency);
   virtual ~TimerInfo();

   XMPBoolean NeedsTimer(XMPTicks ticks);
   XMPTicks NextTimer(XMPTicks ticks);
   
   XMPPart* GetPart() { return fPart; }
   XMPFrame* GetFrame() { return fFrame; }
   XMPTimerFrequency GetTimerFrequency() { return fTimerFrequency; }
   void SetTimerFrequency(XMPTimerFrequency frequency) { fTimerFrequency = frequency; }
   XMPTicks GetLastTimer() { return fLastTimer; }
   void SetLastTimer(XMPTicks lastTimer) { fLastTimer = lastTimer; }
   unsigned long GetTimerId() const { return fTimerId; }

private: 
   XMPPart*       fPart;
   XMPFrame*         fFrame;
   XMPTimerFrequency  fTimerFrequency;
   XMPSLong          fLastTimer;
   unsigned long              fTimerId;
   static unsigned long       nextTimerId;
};

//=====================================================================================
// TimerList
//=====================================================================================

class TimerList
{
   friend class TimerListIterator;
   
public:
   TimerList();
   virtual ~TimerList();
   
   unsigned long  AddTimer(XMPPart* part, XMPFrame* frame, XMPTimerFrequency frequency);
   
   unsigned long  RemoveTimer(XMPPart* part, XMPFrame* frame); 
   
   void SetTimerFrequency(XMPPart* part, XMPFrame* frame, XMPTimerFrequency frequency); 

private:
   LinkedList fImplementation;
};

//=====================================================================================
// TimerListIterator
//=====================================================================================

class TimerListIterator
{
public:

   TimerListIterator(TimerList* idleList);
   
      // Constructor
      
   XMPVMethod ~TimerListIterator();
   
      // Destructor
   
   XMPMethod TimerInfo* First();
   
      // Returns the first element of the set
      
   XMPMethod TimerInfo* Next();
   
      // Returns the next element in the set
      
   XMPMethod XMPBoolean IsNotComplete();
   
      // Returns TRUE as long as there are more elements in the set
   
private:
   
   LinkedListIterator fIterator;
   
};

#endif // _IDLELIST_
