/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
#ifndef _TBLOBJS_
#define _TBLOBJS_

#ifndef _AEHSHTBL_
#include "AEHshTbl.h"
#endif

/* The following class definitions are used by the IKeySet collection */
/* class in AEHshTbl.cpp.  These must be in a separate include file   */
/* for automatic generation of template functions.                    */

class HKey {
   XMPKeyPtr key;
   int size;
public:
   HKey(int keySize, XMPKeyPtr keyValue) { 
      size = keySize; 
      key = new char[size]; 
      memcpy(key, keyValue, size);
   }
   HKey(HKey const &e) { 
      size = e.size;
      key = new char[size]; 
      memcpy(key, e.key, size);
   }
   ~HKey() { delete[] key; }
   Value(XMPKeyPtr p) const { memcpy(p, key, size); }
   int operator ==(HKey const &e) const { return(memcmp(key, e.key, size)==0);}
   int operator < (HKey const &e) const { return(memcmp(key, e.key, size) <0);}
   int operator > (HKey const &e) const { return(memcmp(key, e.key, size) >0);}
};


class HEntry {
   HKey key;
   int  size;
   XMPEntryPtr entry;
public:
   HEntry(int entrySize, XMPEntryPtr entryData, int keySize, XMPKeyPtr keyData) 
                               : key(keySize, keyData) {
      size = entrySize;
      entry = new char[size];
      memcpy(entry, entryData, size);
   }
   HEntry(HEntry const &e) : key(e.key) {
      size = e.size;
      entry = new char[size];
      memcpy(entry, e.entry, size);
   }
   ~HEntry() { delete[] entry; }
   void Value(XMPEntryPtr p) const { memcpy(p, entry, size); }
   void KeyValue(XMPKeyPtr p) const { key.Value(p); } 
   friend HKey const &key(HEntry const &e) { return e.key; }
};
#endif
