/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    sysTrans.h

*/

#ifndef _SYSTRANS_
#define _SYSTRANS_


#define gestaltTranslationAttr        'xlat'    //  move into GestaltEqu.h
#define gestaltTranslationMgrExists      0      //  move into GestaltEqu.h

//#define gestaltStandardFileAttr      'stdf'    
//#define gestaltStandardFile58        0    
#define gestaltStandardFileTranslationAware  1      //  move into GestaltEqu.h
#define gestaltStandardFileHasColorIcons  2      //  move into GestaltEqu.h

//#define gestaltEditionMgrAttr        'edtn'    
//#define gestaltEditionMgrPresent      0
#define gestaltEditionMgrTranslationAware  1      //  move into GestaltEqu.h

#define gestaltScrapMgrAttr          'scra'    
#define gestaltScrapMgrTranslationAware    0      //  move into GestaltEqu.h

// Public Errors
#define noTranslationPathErr          -3030    //  move into Errors.h
#define badTranslationSpecErr          -3031    //  move into Errors.h
#define noPrefAppErr              -3032    //  move into Errors.h

// #define invalidTranslationPathErr      -3025    //  move into Errors.h (TranslationExtensions.h)
// #define couldNotParseSourceFileErr      -3026    //  move into Errors.h (TranslationExtensions.h)

#ifndef REZ

#define APPLEINCL_Types
#ifndef APPLEINCLUDED
   #include <Apple.h>
#endif

#ifndef __FILES__
#include <Files.h>
#endif

#ifndef __MEMORY__
#include <Memory.h>
#endif

#ifndef _SYSTRANS_
#include "SysTrans.h"
#endif

// block of data that describes how to translate
typedef long FileTranslationSpec[12];

// enumerated types on how a document can be opened
typedef short DocOpenMethod;
enum { domCannot, domNative, domTranslateFirst, domWildcard };


//////////////////////////////////////////////////////////////////////////////////////////////
//
//  GetFileTypesThatAppCanNativelyOpen
//
// This routine returns a list of all FileTypes that an application can open by itself
//
// Enter:  appVRefNumHint    volume where application resides (can be wrong, and if is, will be used as a starting point)
//      appSignature    signature (creator) of application
//      nativeTypes      pointer to a buffer to be filled with up to 64 FileTypes
//
// Exit:  nativeTypes      zero terminated array of FileTypes that can be opened by app
//
pascal OSErr GetFileTypesThatAppCanNativelyOpen(short     appVRefNumHint,
                        OSType     appSignature,
                        FileType*  nativeTypes)
   = {0x701C,0xABFC}; 


//////////////////////////////////////////////////////////////////////////////////////////////
//
// ExtendFileTypeList
//
// This routine makes a new list of file types that can be translated into a type in the given list
// Used by StandardFile
//
// Enter:  originalTypeList    pointer to list of file types that can be opened
//      numberOriginalTypes    number of file types in orgTypeList
//       extendedTypeList    pointer to a buffer to be filled with file types
//      numberExtendedTypes    max number of file types that can be put in extendedTypeList
//
// Exit:  extendedTypeList    buffer filled in with file types that can be translated
//      numberExtendedTypes    number of file types put in extendedTypeList
//
pascal OSErr ExtendFileTypeList(const FileType*  originalTypeList,
                    short   numberOriginalTypes,
                    FileType* extendedTypeList,
                    short*   numberExtendedTypes)
   = {0x7009,0xABFC}; 


////////////////////////////////////////////////////////////////////////////////////////////////
//
// This routine checks if a file can be opened by a particular application.
// If so, it returns if it needs to be translated first, and if so then how.
// The FileTypes that the app can open are specified by nativelyOpenableTypes,
// or if it is NULL, GetFileTypesThatAppCanNativelyOpen is called.
//
// Enter:  targetDocument    document to check if it can be opened
//      appVRefNumHint    vRefNum of application to open doc ( can be wrong, and if is, will be used as a starting point)
//      appSignature    signature (creator) of application to open doc
//      nativeTypes      zero terminated list of FileTypes app can open natively, or NULL to use default list
//      onlyNative      whether to consider if document can be translated before opening
//      howToOpen      pointer to buffer in which to put how the document can be opened
//      howToTranslate    pointer to buffer in which to put a FileTranslationSpec record
//
// Exit:  howToOpen      whether file needs to be translated to be read
//      howToTranslate    if file can be translated, buffer filled in with how to translate
//      returns        noErr, noPrefAppErr
//
pascal OSErr CanDocBeOpened(const FSSpec*        targetDocument, 
                  short         appVRefNumHint, 
                  OSType         appSignature,
              const FileType*        nativeTypes,
                  Boolean        onlyNative,
                  DocOpenMethod*     howToOpen,
                  FileTranslationSpec*  howToTranslate)
   = {0x701E,0xABFC}; 


//////////////////////////////////////////////////////////////////////////////////////////////
//
//  TranslateFile
//
// This routine reads a file of one format and writes it to another file in another format. 
// The information on how to translated is generated by the routine CanDocBeOpened.
// TranslateFile calls through to the TranslateFile Extension's DoTranslateFile routine.  
// The destination file must not exist.  It is created by this routine.  
//
// Enter:  sourceDocument      input file to translate
//      destinationDocument    output file of translation
//      howToTranslate      pointer to info on how to translate
// Exit:  returns          noErr, badTranslationSpecErr 
//
pascal OSErr  TranslateFile(const FSSpec*         sourceDocument,
                const FSSpec*         destinationDocument, 
              const FileTranslationSpec*   howToTranslate)
   = {0x700C,0xABFC}; 



#endif  // REZ
#endif  // _SYSTRANS_
