/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    SysTranP.h 

  Contains:  Private interfaces to the Translation Manager for use by the
        Finder, Document converters,  and Standard File allowing for
        high-level access  to translation services and user interfaces.
  
  Written by:  Dylan Ashe & Nick Kledzik

*/

#ifndef _SYSTRANP_
#define _SYSTRANP_

// Creator of the Desktop Translator Finder icon
#define kDesktopTranslatorCreator        'tran'

// strings that deal with kind strings
#define rKindStringsID              -16552
#define rKindStringsGenericIndex            1
#define rKindStringsBasedOnAppNameIndex         2
#define rKindStringsConvertedIndex           3
#define rKindStringsConvertedWithNumberIndex     4
#define rKindStringsUnknownIndex           5
#define rKindStringsPrefNameIndex           6
#define kKindStringsTempFolderNameIndex         7
#define kKindStringsStopButtonTextIndex         8
#define kKindStringsFinderNameIndex           9

// name in pop up for translation done by application 
#define rBuiltInTranslationString        -16101

#define kTranslationSignature          'xlat'
#define kTranslationPrefFileType        'xlpf'

#define kPreferedAppToOpenDocResType        'prfa'
#define kPreferedAppToOpenDocVersion        0

#define kPreferedTransPathForThisAppResType    'prat'
#define kPreferedTransPathForThisAppVersion    1

// resource types in which translation lists are stored in pref file
#define kFileTransListResType           'fxlt'
#define kScrapTransListResType           'sxlt'

// Build-in translation path
#define kBuiltInTranslationPath          'bltn'

#define kDesktopTranslatorPrefResourceType    'dflt'
#define kDesktoptranslatorPrefResourceID    0

// dialogs
#define rTranslationDialogID          -16549
#define rDesktopTranslatorDialogID        -16550
#define rErrorDialogID              -16551
#define rExtendedErrorDialogID          -16552
#define rSegLoadMemErrAlertID          -16553
#define rFileTranslationProgressDialogID    -16554
#define rScrapTranslationProgressDialogID    -16555
#define rMiscStrings              -16554  

// LDEF
#define kTranslationDialogsLDEF          -16549

// Control panel flags
#define translationManagerEnabledMask          0x01
#define translationManagerConfirmationDialogEnabledMask  0x02
#define translationManager16x16ColorIconsEnabledMask  0x04
#define  translationManagerRemoteAppSearchEnabledMask  0x08

#define translationManagerDefaultStatus          translationManagerEnabledMask+translationManagerConfirmationDialogEnabledMask+translationManager16x16ColorIconsEnabledMask+translationManagerRemoteAppSearchEnabledMask

// Icon lookup table
#define rSmallIconLookupTableResType        'slut'
#define rSmallIconLookupTableResID          -16549

// Magic Finder icons (maybe their resource id's will be changed and they'll be rolled into the system)
#define rGenericScriptSystemResourceCollectionIcon  -16569    // 'ifil'
#define rGenericSoundIcon              -16570    // 'sfil'
#define rGenericFontIcon              -16571    // 'ffil'
#define rGenericTrueTypeFontIcon          -16572    // 'tfil'
#define rGenericKeyboardLayoutIcon          -16573    // 'kfil'
#define rGenericFontSuitcaseIcon          -16574    // 'FFIL'
#define rGenericDASuitcaseIcon            -16575    // 'DFIL'

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  Barber pole information
//
#define kNumberBarberPoleFrames            4

#define rBarberPolePICT1              -16549
#define rBarberPolePICT2              -16550
#define rBarberPolePICT3              -16551
#define rBarberPolePICT4              -16552

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  Private errors
//
#define kDTNeedAnotherVolErr            -3035
#define kDTLockedErr                -3036
#define kFileTypeAndContentsMismatchErr        -3037
#define kNoTransSysInstalledErr            -3038
#define kPartialFolderDiskFullErr          -3039
#define kNoFolderDiskFullErr            -3040
#define kNoDesktopTransPreference          -3041
#define kResolvedAliasNotFileErr          -3042
#define kNoTranslatableDocsInFolderErr        -3043
#define kPartialFolderTranslationErr        -3044

#ifndef REZ

#define APPLEINCL_Types
#ifndef APPLEINCLUDED
   #include <Apple.h>
#endif

#ifndef _SYSTRANE_
#include "SysTranE.h"
#endif

#ifndef _SYSTRANS_
#include "SysTrans.h"
#endif

#ifndef __FILES__
#include <Files.h>
#endif

#ifndef __COMPONENTS__
// #include "Components.h"
#endif

#ifndef __CURSORCTL__
#include <CursorCtl.h>
#endif

#ifndef __DIALOGS__
#include <Dialogs.h>
#endif

// Progress dialog structures
enum AdState { asUndecided, asNoAdvert, asHasAdvert };

struct ProgressDialogInfo
{
  DialogRecord  theDialog;
  enum AdState  advertisementShown;
  short      percentDone;
  Rect      progressBarFill;
  Rect      progressBarFrame;
  Rect      advertismentBounds;
  PicHandle    advertisement;
  Handle      colorTable;
  RgnHandle    theClip;
  long      currentItem;
  long      totalItems;
  long      percentageForEachItem;
  float      percentage;
  Boolean      useBarberPole;
  short      currentFrame;
  PicHandle    barberPole[kNumberBarberPoleFrames];
  long      ticksAtWhereToUpdateBarberPoleNext;
};
typedef struct ProgressDialogInfo ProgressDialogInfo;
typedef struct ProgressDialogInfo *ProgressDialogInfoPtr;

// for use by standardfile to remember what folder to returned to after translation
struct StandardFileGlobals
{
  long  app[2];        // really a ProcessSerialNumber
  short  negVRefNum;
  long  dirID;
};
typedef struct StandardFileGlobals StandardFileGlobals;

// one of these for every Translation Extension installed
struct ExtensionEntry {
  OSType            componentSignature;    // from manufacture field of component info
  Component          theComponent;      // Component reference
  FileTranslationListHandle  fileTransList;      // purgable 
  ScrapTranslationListHandle  scrapTransList;      // purgable 
  short            transListResID;     // resource ID used to renew above lists
};
typedef struct ExtensionEntry ExtensionEntry;


struct C3POGlobals {
  Boolean            okToShowDialogs;      // for Finder patches
  Boolean            pluralDialogMessage;    // for Finder dialogs (so they know if they're plural or not)
  short            extensionLocalization;    // localization of "Easy Open" INIT
  Handle            standardDocKindStrings;    // cache of STR# with standard DocKinds
  long            scrapCacheID;        // EditionRefNum, kScrapIsCached, or NULL
  ScrapType          scrapCacheFormat;      // 'stxt', 'RTF ', etc
  Handle            scrapCacheData;        // purgable
  StandardFileGlobals      standardFileInfo;      // static globals for SF to use
  long            preferenceUseCount;      // # people using Translation Preferences file
  short            globalPrefResRefNum;    // Global reference # of preferences file
  long            controlPanelFlags;      // Flags used by control panel  
  unsigned long        extensionsLatestModDate;  // mod Date of latest extensions[].fileTransList
  unsigned long        extensionsSeed;        // ComponentMgr modDate of last component registered
  ExtensionEntry*        extensionsStart;      // pointer to table of extensions
  ExtensionEntry*        extensionsEnd;        // pointer to end of table of extensions
  acurHandle          watchCursors;        // Handle to watch cursors
  long            totalNumberDocuments;    // Total # documents to open
  ProgressDialogInfoPtr    progressDialog;        // Progress dialog pointer
  Boolean            barberPole;          // TRUE if show barbar pole, FALSE otherwise
  Boolean            hadPreviousTranslation;    // TRUE if in a mulitple translation sequence and a translation has already been done
  ProcPtr            progressUpdateProcGluePtr;  // pointer to segment 0 code that contains trap into progress segment
};
typedef struct C3POGlobals C3POGlobals;
typedef C3POGlobals *C3POGlobalsPtr;



struct FileInfoSpec
{
  FSSpec     spec;
  OSType     catInfoType;
  OSType     catInfoCreator;
};
typedef struct FileInfoSpec FileInfoSpec;


// 0L terminated array of OSTypes, or FileTypes
typedef OSType TypesBlock[64];
typedef OSType* TypesBlockPtr;


struct TypeAndHint      // this will go away
{
  unsigned long  format;
  long      hint;
};
typedef struct TypeAndHint TypeAndHint;

struct TranslationSpec
{
  OSType          componentSignature;
  const ExtensionEntry*  translationSystemInfo;
  FileTypeSpec      src;
  FileTypeSpec      dst;
};
typedef struct TranslationSpec TranslationSpec;
typedef TranslationSpec *TranslationSpecArrayPtr;


struct AppOpenSpec
{
  OSType      appSignature;  
  short      appVRefNum;
  short      appDTRefNum;
  DocOpenMethod  appOpenMethod;  
  TranslationSpec  transInfo;          // if domTranslateFirst, then info on how to translate
};
typedef struct AppOpenSpec AppOpenSpec;
typedef AppOpenSpec *AppOpenSpecArrayPtr;
typedef const AppOpenSpec *ConstAppOpenSpecArrayPtr;



//////////////////////////////////////////////////////////////////////////////////////////////
//
//  GetTranslatorMgrGlobalsLocation
//
// This is how globals are accessed
//
C3POGlobalsPtr *GetTranslatorMgrGlobalsLocation()
   = {0x7003,0xABFC}; 

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  WaitUntilFrontLayerProc
//
// This is the interface to the callback which notifies and waits until the Finder (or whatever
// is brought to front)
//
typedef pascal void (*WaitUntilFrontLayerProc)(void);

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  InitDialogSequence
//
// This routine initializes the dialog sequence for FindAlternateApplication and
// MakeDocThatAppCanOpen calls.  Each of those two routines can display the Substitute
// Confirmation dialog on their first use after a call to this routine.  Afterward, each
// call following will have the dialogs supressed - until another call to this routine is
// made.
//
// Enter:  numberInCluster    The number of documents in this cluster (group) of documents
//                trying to be opened.  This is used internally to figure out
//                if the dialogs need to be plural or not.
//
pascal OSErr InitDialogSequence(long numberInCluster)
   = {0x700F,0xABFC}; 

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  ResetDoubleClickFlag
//
// This routine resets the double-click dialog supression flag so dialog will appear again.
//
pascal OSErr ResetDoubleClickFlag(void)
   = {0x7032,0xABFC}; 

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  FindAlternateCreator
//
// This routine gets the creator of an application that can open a document.  It gets the
// creator by using a preference, letting the user confirm a preference, or choose a
// preference in a multiple choice dialog.
//
// Enter:  docVRefNum      Volume reference number of the volume the document resides on
//      docDirID      Directory id of the directory the document resides in
//      docName        Name of the document
//      docFileType      Type of document
//      docFileCreator    Creator of document
//      quiet        TRUE if you want dialogs supressed, FALSE otherwise
//      waitProc      Proc to execute (if specified) causing a wait until the
//                correct process is brought to front
//
// Exit:  alternateCreator  Signature of application to open document
//      returns        Any error that may occur
//      
pascal OSErr FindAlternateCreator(      short          docVRefNum,
                         long          docDirID,
                  const StringPtr        docName,
                       OSType          docFileType,
                      OSType          docFileCreator,
                         Boolean          quiet,
                    WaitUntilFrontLayerProc  waitProc,
                      long*          alternateCreator)
   = {0x7010,0xABFC}; 


//////////////////////////////////////////////////////////////////////////////////////////////
//
//  HandleOpenDocument
//
// This routine is called by the Finder at the final stages of launching, but does drastically
// different things depending on the situation.  Override this routine if you want to totally
// customize the way the Finder opens documents.
//
// Here's what this routine does today:
//
//     If the application is a "real" application, then the routine makes sure that the
//    document can be opened by it.  If it cannot, it tries to translate the documents into
//    something the application can read (no user interaction except for progress dialog).
//
//     If the application is a desktop translator, then this routines acts like a desktop
//    translator.  If no translator setting has been set, then it displays a dialog allowing
//    the user to choose a file format, then translates the file to it.  If a setting has
//    already been made, then the file is automatically translated to that format.  In
//    either case, the routine passes back to the caller that the entire open process was
//    completed here and to not do anything else with the documents or applications.
//
//    If no document is passed to the desktop translator (nil), it will display it's
//    configuration dialog.
//
// Enter:  theDocument            The document to be opened
//      theApplication          The application with which to open theDocument
//      applicationIsStationeryAware  TRUE if application is stationery aware, FALSE otherwise
//      typeList            Types the application can open (only used by Standard File)
//      quiet              Dialogs only if requires user interaction
//      waitProc            Proc to execute (if specified) causing a wait until the
//                      correct process is brought to front
//
// Exit:  theDocument            Possibly a new, translated document (see documentChanged)
//      documentChanged          TRUE if document translation was needed to open the document
//                      and that theDocument was changed to be the new document, FALSE
//                      if no change occurred to that field
//      openComplete          TRUE if the entire open process was completed by this routine and
//                      that the caller should ignore any remaining opening code and
//                      clean-up and get-out without any error message.
//
pascal OSErr HandleOpenDocument(    FileInfoSpec*        theDocument,
                const FileInfoSpec*        theApplication,
                      Boolean          applicationIsStationeryAware,
                    TypesBlockPtr       typeList,
                    Boolean*          documentChanged,
                    Boolean*          openComplete,
                    Boolean          quiet,
                    WaitUntilFrontLayerProc  waitProc)
   = {0x7011,0xABFC}; 


//////////////////////////////////////////////////////////////////////////////////////////////
//
//  IsOpenableTypeListValid
//
// This routine checks if the list of document types that can be dropped on an application
// is up to date.  It (potentially) is out of date, if the translation lists have changed
// or if there is a newer version of the application.  Desktop translators and document
// openers pass FileInfoSpec's of themselves here.
//
// Used by Finder for drop launching
//
// Enter:  appSignature  Application creator
//      listModDate    date returned by GetOpenableTypeList 
//
// Exit:  returns      True if the typeList is still valid, false implies 
//              Finder should call GetOpenableTypeList
//
pascal Boolean IsOpenableTypeListValid(OSType      appSignature,
                     unsigned long  listModDate)
   = {0x7012,0xABFC}; 



//////////////////////////////////////////////////////////////////////////////////////////////
//
//  __GetOpenableTypeList
//
// This routine returns a list of all document types that can be dropped on an application.
// Also returned is a timestamp for the list.  The Finder can use this timestamp to later
// determine if the list is still valid (using IsOpenableTypeListValid).  Desktop translators
// and document opers pass FileInfoSpec's of themselves here.
//
// The list is a TypesBlock - a zero terminated array of FileTypes.  
// 
// Used by Finder for drop launching
//
// Enter:  vRefNum                Volume application resides on
//      parID                Directory application resides in
//      name                Name of application
//      type                Application type
//      creator                Application creator
//      listModDate              pointer to where to return the timestamp
//      typeList              pointer to where to return the list of file types
//
// Exit:  listModDate              filled with a timestamp for the list
//      typeList              0L terminated list of file types (max 64)
//
pascal OSErr GetOpenableTypeList(     short      appVRefNum,
                     long        appDirID,
                 const StringPtr    appName,
                        OSType      appFileType,
                     OSType      appSignature,
                     unsigned long*  listModDate,
                     TypesBlockPtr  typeList)
   = {0x7013,0xABFC}; 

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  BeginTranslate
//
// This routine tells Gremlin how many documents to expect to have to translate as well as
// if it should use the barber pole in the progress dialog.
//
// Enter:  numberDocumentsToTranslate  Total number documents to translate
//      useBarberPole        TRUE to display barber pole, FALSE otherwise (you should
//                    check to see if one of the documents going to be passed
//                    to HandleOpenDocument() is a folder, and if so, set this
//                    to TRUE, since we don't know how long the translation
//                    will take)
//
// Exit:  returns            Any errors that might occur
//
pascal OSErr BeginTranslate(long  numberDocumentsToTranslate,
                 Boolean  useBarberPole)
  = {0x7033, 0xABFC};

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  EndTranslate
//
// This routine tells Gremlin that the group of file translations are complete and disposes
// of any visable progress dialog
//
// Exit:  returns            Any errors that might occur
//
pascal OSErr EndTranslate(void)
  = {0x7034, 0xABFC};
  
//////////////////////////////////////////////////////////////////////////////////////////////
//
//  ExecuteTranslation
//
// This routine allows the developer to execute something very close to a desktop translation.
//
// Enter:  theDocument      If theDocument is not specified, this routine will display and
//                run the Desktop Translator dialog (storing the setting in the
//                preference file (described next).  If it is specified, then
//                theDocument will be translated into the format specified in
//                the preference file.  The new document will be created in the
//                same director as this one.
//      thePreferenceFile  An FSSpec describing where and what the name of the preference
//                file.  The file should already been created (and have a resource
//                fork) prior to making this call.  It's also important that the
//                preference file is closed prior to this call.
//
// Exit:  returns        Any errors that might occur
//
pascal OSErr ExecuteTranslation(const FSSpec*  theDocument,
                 const FSSpec*  thePreferencesFile)
   = {0x7028,0xABFC}; 


//////////////////////////////////////////////////////////////////////////////////////////////
//
// ImplicitTranslateFile
//
// This routine reads a file of one format and writes it to another file in another format. 
// The output file is put in the temporary folder and its name is based on the source file name.
//
// Enter:  srcDoc          File to translate
//      appIsStarioneryAware  Whether to mark the output file as stationery
//      howToTranslate      File type to translate to, and other hints to speed finding translators
//      translatedFileToOpen  Pointer to buffer to store location and name of translated output file
//
// Exit:  translatedFileToOpen  Set to the FSSpec of the translated output file
//
//
pascal OSErr ImplicitTranslateFile(const FSSpec* srcDoc, const TranslationSpec* howToTranslate,
                  Boolean appIsStarioneryAware, FSSpec* translatedFileToOpen)
   = {0x7004,0xABFC}; 

//////////////////////////////////////////////////////////////////////////////////////////////
//
// TranslateMultipleFiles
//
// This routine reads a file of one format and writes it to another file in another format. 
// It calls through to the TranslateFile Extensions' TranslateFile.  It is similar to
// TranslateFile, except that it handles multiple files
//
// Enter:  srcDoc          Input file to translate
//      dstDoc          Output file of translation
//      howToTranslate      Pointer to FileType to translate to, and other hints to speed finding translators
//
// Exit:  
//
pascal OSErr TranslateMultipleFiles(const FSSpec* srcDoc, const FSSpec* dstDoc, 
                    const FileTranslationSpec* howToTranslate)
   = {0x7035,0xABFC}; 

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  GetDocumentKindString
//
// This routine returns the string the Finder should show for the "kind" of a document
// in the GetInfo window and in the kind column of a list view.  
//
// Enter:  docVRefNum    The volume containing the document
//      docType      The catInfo.fdType of the document
//      docCreator    The catInfo.fdCreator of the document
//      kindString    pointer to where to return the string
//
// Exit:  kindString    pascal string.  Ex: "\pSurfCalc spreadsheet"
//      returns      noErr, or afpItemNoFound if kind could not be determined
//
pascal OSErr GetDocumentKindString(short docVRefNum, OSType docType, OSType docCreator, Str63 kindString)
   = {0x7016,0xABFC}; 


//////////////////////////////////////////////////////////////////////////////////////////////
//
//  InstallDesktopResources
//
// This routine installs the 'open', 'kind', (and soon 'FREF') resources into the desktop database.  
// It assumes that the current resource file is the file from which to extract the resources.
//
// Enter:  desktopFileRefNum  Reference number of the desktop file into which to install 
//
pascal OSErr InstallDesktopResources(short desktopFileRefNum)
   = {0x7017,0xABFC}; 


//////////////////////////////////////////////////////////////////////////////////////////////
//
//  RebuildAllTranslationLists
//
// This routine queries all translation extensions to get the latest translation lists
//
pascal OSErr  RebuildAllTranslationLists()
   = {0x700D,0xABFC}; 


//////////////////////////////////////////////////////////////////////////////////////////////
//
//  LeaveOurMarkOnTheTree
//
// This routine (like a dog) leaves the mark of C3PO on the desktop db b-tree.  That way we
// know we're installed.
//
// Enter:  desktopRefNum    Desktop database to mark
//
// Exit:  returns        Any errors that might occur
//
pascal OSErr LeaveOurMarkOnTheTree(short desktopRefNum)
   = {0x702F,0xABFC};

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  WeveBeenToThisTreeBefore
//
// This routine (like a dog) checks to see if we've been to this tree before
//
// Enter:  desktopRefNum    Desktop database to mark
//
// Exit:  returns        No error if we've been here, an error if we haven't
//
pascal OSErr WeveBeenToThisTreeBefore(short desktopRefNum)
   = {0x7030,0xABFC};

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  __PreflightPaulIconInstall   rename to InstallOpenableTypesBasedOnFREF
//
// This routine checks to see if the Finder should not install this 'paul' icon 
// (derived from the FREF resources) because an 'open' resource has
// already installed a better 'paul' icon.
//
// Enter:  pb      Parameter block for PBDTAddIcon
//
// Exit:  returns    true -> asm patch should continue and install 'paul' icon
//
pascal Boolean PreflightPaulIconInstall(DTPBPtr pb)
   = {0x702B,0xABFC};


//////////////////////////////////////////////////////////////////////////////////////////////
//
// GetScrapDataProcPtr
//
// This is a prototype for the function you must supply to TranslateScrap. It is called to 
// get the data to be translated.  The first call TranslateScrap will make to this is to
// ask for the 'fmts' data.  That is a special.   You should resize and fill in the handle
// with a list all the formats that you have available to be translated, and the length of each.
// (See I.M. VI 4-23 for details of 'fmts').  It will then be called again asking for one of  
// the formats that 'fmts' list said was available.
//
// Enter:  requestedFormat      Format of data that TranslateScrap needs.
//      dataH          Handle in which to put the requested data
//      srcDataGetterRefCon    Extra parameter for you passed to TranslateScrap
//      
// Exit:  dataH          Handle is resized and filled with data in requested format
//
typedef pascal OSErr (*GetScrapDataProcPtr)(ScrapType   requestedFormat,
                      Handle     dataH,
                      void*     srcDataGetterRefCon);

//////////////////////////////////////////////////////////////////////////////////////////////
//
// TranslateScrap
//
// This routine resizes the destination handle and fills it with data of the requested format.
// The data is generated by translated one or more source formats of data supplied by
// the procedure srcDataGetter.  
// This routine is automatically called by GetScrap and ReadEdition.  You only need to call
// this if you need to translated scrap style data, but are not using the ScrapMgr or EditionMgr.
//
// Enter:  sourceDataGetter      Pointer to routine that can get src data
//      sourceDataGetterRefCon    Extra parameter for dataGetter
//      destinationFormat      Format of data desired
//      destinationData        Handle in which to store translated data
//      
// Exit:  dstData            Handle is resized and filled with data in requested format
//
pascal OSErr TranslateScrap(GetScrapDataProcPtr sourceDataGetter,
              void*        sourceDataGetterRefCon,
              ScrapType       destinationFormat,
              Handle        destinationData,
              short        progressDialogID)
   = {0x700E,0xABFC}; 
              


#if INITVERSION
//////////////////////////////////////////////////////////////////////////////////////////////
//
//  FUNCTION GetInitResFile: Integer;
//
//    This gets the resource fork refnum of the "Translation Extension" file.
//    You will probably never need this.  The only resources in the file that
//    need to override the system resources are PACK 3 and 11.  
//
pascal short GetInitResFile(void)
   = {0x7029,0xABFC}; 
#endif



#endif  // REZ
#endif  // _SYSTRANP_
