/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    SysTranE.h

*/

/*
  File:    TranslationExtensions.h 

  Contains:  Interface definitions for translation extension writers.

  Copyright:   1992 by Apple Computer, Inc., all rights reserved.
*/


#ifndef _SYSTRANE_
#define _SYSTRANE_

#define kSupportsFileTranslation   1
#define kSupportsScrapTranslation   2

// special error codes that DoTranslateFile can return
//    userCanceledErr        -128    // user hit cancel button in progress dialog, or error handled by extension
#define invalidTranslationPathErr  -3025    // srcType to dstType is not a valid path      move into Errors.h
#define couldNotParseSourceFileErr  -3026    // the source document does not contain srcType   move into Errors.h

#ifndef REZ

#include <Memory.h>
#include <Files.h>

#define APPLEINCL_QuickDraw
#ifndef APPLEINCLUDED
   #include <Apple.h>
#endif
// #include "Components.h"

// better names for 4-char codes
typedef  OSType  FileType;
typedef  ResType  ScrapType;


typedef unsigned long TranslationAttributes;
#define taDstDocNeedsResourceFork  1
#define taDstIsAppTranslation    2


struct FileTypeSpec
{
  FileType        format;
  long          hint;
  TranslationAttributes  flags;        // taDstDocNeedsResourceFork, taDstIsAppTranslation
  OSType          catInfoType;
  OSType          catInfoCreator;
};
typedef struct FileTypeSpec FileTypeSpec;

struct FileTranslationList
{
  unsigned long    modDate;
  unsigned long    groupCount;
  //   unsigned long  group1SrcCount;
  //   unsigned long  group1SrcEntrySize = sizeof(FileTypeSpec);
  //  FileTypeSpec  group1SrcTypes[group1SrcCount]
  //  unsigned long  group1DstCount;
  //  unsigned long  group1DstEntrySize = sizeof(FileTypeSpec);
  //  FileTypeSpec  group1DstTypes[group1DstCount]
};
typedef struct FileTranslationList FileTranslationList;
typedef FileTranslationList *FileTranslationListPtr, **FileTranslationListHandle;



struct ScrapTypeSpec
{
  ScrapType  format;
  long    hint;
};
typedef struct ScrapTypeSpec ScrapTypeSpec;

struct ScrapTranslationList
{
  unsigned long      modDate;
  unsigned long      groupCount;
  //   unsigned long    group1SrcCount;
  //   unsigned long    group1SrcEntrySize = sizeof(ScrapTypeSpec);
  //  ScrapTypeSpec    group1SrcTypes[group1SrcCount]
  //  unsigned long    group1DstCount;
  //   unsigned long    group1DstEntrySize = sizeof(ScrapTypeSpec);
  //  ScrapTypeSpec    group1DstTypes[group1DstCount]
};
typedef struct ScrapTranslationList ScrapTranslationList;
typedef ScrapTranslationList *ScrapTranslationListPtr, **ScrapTranslationListHandle;



// definition of callbacks to update progress dialog
typedef long TranslationRefNum;


//////////////////////////////////////////////////////////////////////////////////////////////
//
// This routine sets the advertisement in the top half of the progress dialog.
// It is called once at the beginning of your DoTranslateFile routine.
//
// Enter:  refNum      Translation reference supplied to DoTranslateFile.
//      advertisement  A handle to the picture to display.  This must be non-purgable.
//              Before returning from DoTranslateFile, you should dispose
//              of the memory.  (Normally, it is in the temp translation heap
//              so it is cleaned up for you.)
//
// Exit:  returns      noErr, paramErr, or memFullErr
//
pascal OSErr SetTranslationAdvertisement(TranslationRefNum   refNum,
                     PicHandle       advertisement)
   = {0x7002,0xABFC}; 


//////////////////////////////////////////////////////////////////////////////////////////////
//
// This routine updates the progress bar in the progress dialog.
// It is called repeatedly from within your DoTranslateFile routine.
// It should be called often, so that the user will get feedback if he tries to cancel.
//
// Enter:  refNum    translation reference supplied to DoTranslateFile.
//      progress  percent complete (0-100)
//
// Exit:  canceled  TRUE if the user clicked the Cancel button, FALSE otherwise
//      returns    noErr, paramErr, or memFullErr
//
pascal OSErr UpdateTranslationProgress(TranslationRefNum  refNum,
                    short         percentDone,
                    Boolean*         canceled)
   = {0x7001,0xABFC}; 



// ComponentMgr selectors for routines
enum {
  kTranslateGetFileTranslationList = 0,    // component selectors
  kTranslateIdentifyFile,
  kTranslateTranslateFile,
  kTranslateGetScrapTranslationList = 10,    // skip to scrap routines
  kTranslateIdentifyScrap,
  kTranslateTranslateScrap
};


// implement these if you are writing a File Translation Extension
pascal ComponentResult DoGetFileTranslationList(ComponentInstance self, FileTranslationListHandle translationList);
pascal ComponentResult DoIdentifyFile(ComponentInstance self, const FSSpec* theDoc, FileType* docKind);
pascal ComponentResult DoTranslateFile(ComponentInstance self, TranslationRefNum refNum,
                      const FSSpec* srcDoc, FileType srcType, long srcTypeHint, 
                      const FSSpec* dstDoc, FileType dstType, long dstTypeHint);



// implement these if you are writing a Scrap Translation Extension
pascal ComponentResult DoGetScrapTranslationList(ComponentInstance self, ScrapTranslationListHandle list);
pascal ComponentResult DoIdentifyScrap(ComponentInstance self, const void* dataPtr, Size dataLength, ScrapType* dataFormat);
pascal ComponentResult DoTranslateScrap(ComponentInstance self, TranslationRefNum refNum,
                    const void* srcDataPtr, Size srcDataLength, ScrapType srcType, long srcTypeHint,
                    Handle dstData, ScrapType dstType, long dstTypeHint);


#endif  //  REZ


#endif  // _SYSTRANE_
