/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    SysSessM.h

   Contains:   XMPMacSystemSession class definition

   Written by: Vincent Lo


*/

#ifndef _SYSSESSM_
#define _SYSSESSM_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _BASESESS_
#include "BaseSess.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

//==============================================================================
// Constants
//==============================================================================

extern char* const kXMPSystemSessionName; // = "OpenDoc:SystemSession";

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPMacSystemSession;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPStorageSystem;
class XMPBaseSession;
class XMPBinding;

//==============================================================================
// XMPMacSystemSession
//==============================================================================

#define kXMPMacSystemSessionID "appl:XMPMacSystemSession$class,1.0.0"

class XMPMacSystemSession : public XMPBaseSession
{
public:

   XMPMethod void                Close();

   XMPMethod XMPSize             Purge(XMPSize size);

   XMPVMethod XMPBinding*           GetBinding();

private:

   XMPHeap*          fHeap;
   
public: // Private by convention

   XMPMacSystemSession();
   XMPNVMethod void  InitSession();
   XMPVMethod ~XMPMacSystemSession();

  protected:

   XMPBinding*          fBinding;
};


#endif // _SYSSESSM_
