/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    SUView.h

  Contains:  definition of XMPStorageUnitView

  Written by: Vincent Lo, Joshua Susser

*/

#ifndef _SUVIEW_
#define _SUVIEW_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _STORAGEU_
#include "StorageU.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================

class  XMPStorageUnitView;

//==============================================================================
// Classes used by this interface
//==============================================================================

class  XMPStorageUnit;
class  XMPStorageUnitCursor;

//==============================================================================
// XMPStorageUnitView
//==============================================================================

#define kXMPStorageUnitViewID "appl:xmpstorageunitview$class,1.0.0"

class XMPStorageUnitView : public XMPObject
{
public:

  XMPStorageUnitView();
  
  XMPVMethod  ~XMPStorageUnitView();
  
  XMPNVMethod  void InitStorageUnitView(XMPStorageUnit* storageUnit, XMPStorageUnitCursor* cursor);
  
  XMPVMethod  XMPSize  Purge(XMPSize sizeNeeded);

  XMPMethod  XMPStorageUnit* GetStorageUnit();

  XMPMethod  XMPStorageUnitCursor* GetCursor();

  XMPMethod  XMPStorageUnitView*  Externalize();  
    
  XMPMethod  XMPStorageUnitView*  Internalize();  
    
  XMPMethod  XMPID GetID();      

  XMPMethod  XMPStorageUnitName GetName();    
    
  XMPMethod  void SetName(XMPStorageUnitName name);

  XMPMethod  XMPStorageUnitView* AddProperty(XMPPropertyName propertyName);      
    
  XMPMethod  XMPStorageUnitView* AddValue(XMPValueType type);
    
  XMPMethod   XMPStorageUnitView* Remove();

  XMPMethod  void CopyTo(XMPStorageUnit* toSU);
    
  XMPMethod  XMPStorageUnit* CloneTo(XMPDraftKey key, XMPDraft* destDraft, XMPStorageUnit* initiatingFrameSU);

  XMPMethod  void CloneInto(XMPDraftKey key, XMPStorageUnit* destStorageUnit, XMPStorageUnit* initiatingFrameSU);

  XMPMethod XMPPropertyName  GetProperty();

  XMPMethod XMPValueType  GetType();
  XMPMethod void      SetType(XMPValueType valueType);

  XMPMethod void      SetOffset(XMPULong offset);
  XMPMethod XMPULong    GetOffset();
  
  XMPMethod XMPULong    GetValue(XMPULong length, XMPValue value);
  XMPMethod void      SetValue(XMPULong length, XMPValue value);
  XMPMethod void      InsertValue(XMPULong length, XMPValue value);
  XMPMethod void      DeleteValue(XMPULong length);

  XMPMethod XMPULong    GetSize();
  
  XMPMethod XMPStorageUnitRef    GetStrongStorageUnitRef(XMPStorageUnit* embeddedSU);
  XMPMethod XMPStorageUnitRef    GetWeakStorageUnitRef(XMPStorageUnit* embeddedSU);
  XMPMethod XMPBoolean      IsStrongStorageUnitRef(XMPStorageUnitRef ref);
  XMPMethod XMPBoolean      IsWeakStorageUnitRef(XMPStorageUnitRef ref);
  XMPMethod XMPStorageUnitView*  RemoveStorageUnitRef(XMPStorageUnitRef aRef);
  XMPMethod XMPStorageUnitID  GetIDFromStorageUnitRef(XMPStorageUnitRef aRef);

  XMPMethod XMPStorageUnitRefIterator* GetStorageUnitRefIterator();


  XMPMethod  XMPULong  GetGenerationNumber();
  XMPMethod  XMPULong  IncrementGenerationNumber();
  
  XMPMethod  XMPBoolean  IsPromiseValue();
  XMPMethod  void    SetPromiseValue(XMPValueType valueType,
                                            XMPULong offset,
                      XMPULong length, 
                      XMPValue value,
                      XMPPart *sourcePart);
  XMPMethod  XMPULong  GetPromiseValue(XMPValueType valueType,
                      XMPULong offset,
                      XMPULong length,
                      XMPValue value,
                      XMPPart **sourcePart);
private:

  XMPMethod  void    Lock();
  XMPMethod  void    Unlock();

  XMPStorageUnit*      fSU;
  XMPStorageUnitCursor*  fCursor;
  XMPULong        fOffset;
  
  XMPStorageUnitKey    fKey;
};

#endif  // _SUVIEW_
