/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    SURefItr.h

  Contains:  definition of XMPStorageUnitRefIterator

  Written by: Vincent Lo

*/

#ifndef _SUREFITR_
#define _SUREFITR_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef __CM_API__
#include "CMAPI.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================
class  XMPStorageUnitRefIterator;

//==============================================================================
// Classes used by this interface
//==============================================================================
class  XMPStorageUnit;

//==============================================================================
// XMPStorageUnitRefIterator
//==============================================================================

#define kXMPStorageUnitRefIteratorID "appl:xmpstorageunitrefiterator$class,1.0.0"

class XMPStorageUnitRefIterator
{
public:

  XMPStorageUnitRefIterator(XMPStorageUnit* storageUnit);
  ~XMPStorageUnitRefIterator();
  
  XMPStorageUnitRef  First();
  XMPStorageUnitRef  Next();
  XMPBoolean      IsNotComplete();
  
private:

  XMPBoolean      fNotComplete;
  CMReference      fReference;
  CMValue        fValue;
};

#endif  // _SUREFITR_