/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    StorPriv.h

  Contains:  Private Definition for XMPStorageSystem

  Written by:  Vincent Lo

  Copyright:   1992-1994 by Apple Computer, Inc., all rights reserved.

  Change History (most recent first):
  
     <4>    2/8/94  VL    Got rid of friends.
     <3>    2/4/94  VL    Containr.h -> XMPCtr.h.
     <2>  11/23/93  VL    Added fHeap, GetHeap() and Initialize() to
                  the classes.
     <1>   6/15/93  VL    first checked in

  To Do:
*/

#ifndef _STORPRIV_
#define _STORPRIV_

#ifndef _LIST_
#include "List.h"
#endif

#ifndef _XMPCTR_
#include "XMPCtr.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================

class ContainerLink;
class ContainerList;
class ContainerListIterator;

//==============================================================================
// ContainerLink
//==============================================================================

class ContainerLink : public Link {

public:
  
  ContainerLink(XMPContainerID id, XMPContainer* container)
  {
    fContainerID = id;
    fContainer = container;
  }
  ~ContainerLink() {;};
  
  XMPContainerID  fContainerID;
  XMPContainer*  fContainer;
};

//==============================================================================
// ContainerList
//==============================================================================

class ContainerList
{  

public:

  ContainerList();
  
  XMPVMethod  ~ContainerList();
  
  XMPMethod  void Initialize();
  
  XMPMethod void Add(XMPContainerID containerID, XMPContainer* container);
  
  XMPMethod void Remove(XMPContainerID containerID);
  
  XMPMethod XMPContainer* Get(XMPContainerID containerID);

private:

  XMPMethod ContainerLink*  GetLink(XMPContainerID containerID);

  LinkedList* fLinkedList;
  XMPHeap    fHeap;
  
public:  // private by convention
  
  XMPMethod  XMPHeap      GetHeap();
  XMPMethod  LinkedList*    GetLinkedList();
};

//==============================================================================
// ContainerListIterator
//==============================================================================

class ContainerListIterator
{

public:

  ContainerListIterator(ContainerList* containerList);
  
  XMPVMethod  ~ContainerListIterator();
  
  XMPMethod  void      Initialize();
  XMPMethod  XMPContainer*  Last();
  XMPMethod  XMPContainer*  Previous();
  XMPMethod  XMPBoolean    IsNotComplete();
  
private:

  LinkedListIterator* fIterator;
  ContainerList*    fContainerList;
};
  
#endif  // _STORPRIV_
