/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    Storage.h

  Contains:  Defintion of XMPMacStorageSystem

  Written by:  Vincent Lo, Tantek I. Celik, Paul Hartenstine

*/

#ifndef _STORAGEM_
#define _STORAGEM_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _STORAGE_
#include "Storage.h"
#endif

#ifndef _XMPCTR_
#include "XMPCtr.h"      // included for XMPContainerID
#endif

#ifndef __CM_API__
#include "CMAPI.h"
#endif

//==============================================================================
// Classes used in this interface
//==============================================================================
class  XMPBaseSession;
class  XMPContainer;
class  ContainerList;

//==============================================================================
// Classes defined in this interface
//==============================================================================
class  XMPMacStorageSystem;

//==============================================================================
// XMPMacStorageSystem
//==============================================================================

#define kXMPMacStorageSystemID "appl:xmpmacstoragesystem$class,1.0.0"

class XMPMacStorageSystem : public  XMPAbsStorageSystem   {

public:

  XMPMacStorageSystem();
  XMPVMethod  ~XMPMacStorageSystem();
  
  XMPNVMethod  void InitStorageSystem(XMPBaseSession* session, XMPHeap heap);

  XMPMethod  XMPBaseSession*  GetSession();
  
  XMPMethod  XMPContainer*  GetContainer(XMPContainerType containerType,
                        XMPContainerID id);
                        
  XMPMethod  XMPContainer*  CreateContainer(XMPContainerType containerType,
                        XMPContainerID id);
                      
  XMPMethod void NeedSpace(XMPSize memSize, XMPBoolean doPurge);

private:

  XMPMethod XMPContainerSuite GetContainerSuite(XMPContainerType containerType);
      
  XMPMethod XMPSize Purge(XMPSize size);    
      
  XMPMethod void GrowHeap(XMPSize memSize);

  XMPBaseSession*    fSession;
  XMPHeap        fHeap;
  ContainerList*    fContainers;

  CMSession      fCMSession;

  
public: // private by convention

  XMPMethod  XMPAbsStorageSystem*  ReleaseContainer(XMPContainer* container);
  XMPMethod  XMPHeap          GetHeap();
  
  XMPMethod  CMSession  GetCMSession();
  XMPMethod  void    SetCMSession(CMSession session);
};


#endif  // _STORAGEM_