/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    Storage.h

  Contains:  Defintion of XMPAbsStorageSystem

  Written by:  Vincent Lo, Tantek I. Celik

*/

#ifndef _STORAGE_
#define _STORAGE_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _XMPCTR_
#include "XMPCtr.h"
#endif

//==============================================================================
// Classes used in this interface
//==============================================================================
class  XMPBaseSession;
class  XMPContainer;

//==============================================================================
// Classes defined in this interface
//==============================================================================
class  XMPAbsStorageSystem;

//==============================================================================
// XMPAbsStorageSystem
//==============================================================================

class XMPAbsStorageSystem : public  XMPObject {

public:

  XMPAbsStorageSystem() {}
  
  XMPVMethod ~XMPAbsStorageSystem() {}

  XMPVMethod  void InitStorageSystem(XMPBaseSession* session, XMPHeap heap)
    = 0;
    
  XMPVMethod  XMPBaseSession*    GetSession()
    = 0;
    
  XMPVMethod  XMPContainer*  GetContainer(XMPContainerType containerType,
                        XMPContainerID id)
    = 0;
    
  XMPVMethod  XMPContainer*  CreateContainer(XMPContainerType containerType,
                        XMPContainerID id)
    = 0;
                      
  XMPVMethod void NeedSpace(XMPSize memSize, XMPBoolean doPurge)
    = 0;


private:

  XMPVMethod XMPSize Purge(XMPSize size)
    = 0;
      
  XMPVMethod void GrowHeap(XMPSize memSize)
    = 0;
    
public: // private by convention

  XMPVMethod XMPAbsStorageSystem* ReleaseContainer(XMPContainer* container)
    = 0;
};

#ifdef PLATFORM_MACINTOSH
#ifndef _STORAGEM_
#include "StorageM.h"
#endif
#endif

#endif  // _STORAGE_