/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    StdTypes.h

   Contains:   Standard Types

   Written by: OpenDoc Engineering

*/

#ifndef _STDTYPES_
#define _STDTYPES_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   This file is used to store all the standard types.
*/

//==============================================================================
// Constants
//==============================================================================

// Universal Types
const XMPValueType   kXMPBoolean    = "OpenDoc:Type:Boolean";
const XMPValueType   kXMPValue      = "OpenDoc:Type:Bytes";
const    XMPValueType   kXMPUShort     = "OpenDoc:Type:UShort";
const    XMPValueType   kXMPSShort     = "OpenDoc:Type:SShort";
const XMPValueType   kXMPULong      = "OpenDoc:Type:ULong";
const XMPValueType   kXMPSLong      = "OpenDoc:Type:SLong";
const XMPValueType   kXMPULongs     = "OpenDoc:Type:ULongs";

const XMPValueType   kXMPISOStr     = "OpenDoc:Type:ISOStr";

const XMPValueType   kXMPIntlText   = "OpenDoc:Type:IntlText";
const XMPValueType   kXMPName    = "OpenDoc:Type:Name";
const XMPValueType   kXMPNames      = "OpenDoc:Type:Names";
const XMPValueType   kXMPStr32      = "OpenDoc:Type:Str32";
const XMPValueType   kXMPStr255     = "OpenDoc:Type:Str255";

const XMPValueType   kXMPDate    = "OpenDoc:Type:Date";
const XMPValueType   kXMPTime_T     = "OpenDoc:Type:Time_T";

const XMPValueType   kXMPID         = "OpenDoc:Type:ID";
const XMPValueType   kXMPIDs        = "OpenDoc:Type:IDs";

const XMPValueType   kXMPPoint      = "OpenDoc:Type:Point";
const XMPValueType   kXMPRect    = "OpenDoc:Type:Rect";
const XMPValueType   kXMPPolygon    = "OpenDoc:Type:Polygon";
const XMPValueType   kXMPIconFamily = "OpenDoc:Type:IconFamily";

const XMPValueType   kXMPPartInfo   = "OpenDoc:Type:InfoType";
const XMPValueType   kXMPTransform  = "OpenDoc:Type:Transform";

const XMPValueType   kXMPVersionList = "OpenDoc:Type:VersionList";

const XMPValueType   kXMPHighlight  = "OpenDoc:Type:Highlight";

const XMPValueType   kXMPEditor     = "OpenDoc:Type:Editor";

// Window
const XMPValueType   kXMPWindowRect = (XMPValueType) kXMPRect;
const XMPValueType   kXMPSourceFrame   = "OpenDoc:Type:SourceFrame";


// Layout
const XMPValueType   kXMPFrameTree  = "OpenDoc:Type:FrameTree";


const XMPType        kXMPFrame               = "OpenDoc:Type:Frame";
const XMPType        kXMPPart             = "OpenDoc:Type:Part";
const XMPType        kXMPLink             = "OpenDoc:Type:Link";
const XMPType        kXMPLinkSource          = "OpenDoc:Type:LinkSource";
const XMPType        kXMPLinkContent            = "OpenDoc:Type:LinkContent";
const XMPType        kXMPStorageUnit            = "OpenDoc:Type:StorageUnit";
const XMPType        kXMPStrongStorageUnitRef   = "OpenDoc:Type:StorageUnitRef";
const XMPType        kXMPWeakStorageUnitRef     = "OpenDoc:Type:StorageUnitRef";
const XMPType        kXMPWindow              = "OpenDoc:Type:Window";
const XMPType        kXMPLayout              = "OpenDoc:Type:Layout";
const XMPType        kXMPDragDropStorageUnit    = "OpenDoc:Type:DragDropStorageUnit";

const XMPValueType   kXMPLinkSpec            = "OpenDoc:Type:LinkSpec";
const XMPValueType   kXMPChangeID            = "OpenDoc:Type:ChangeID";

// Drag & Drop and Clipboard

const XMPValueType   kXMPKindStandInFrame    = "OpenDoc:Type:StandInFrame";

// Platform Specific Types

// ISOString equivalents for Apple scrap types
const XMPValueType   kXMPApplePart  = "Apple:OSType:Scrap:odcn";  // OpenDoc Container
const XMPValueType   kXMPAppleTEXT  = "Apple:OSType:Scrap:TEXT";
const XMPValueType   kXMPApplestyl  = "Apple:OSType:Scrap:styl";
const XMPValueType   kXMPApplePICT  = "Apple:OSType:Scrap:PICT";
const XMPValueType   kXMPApplehfs   = "Apple:OSType:Scrap:hfs ";
const XMPValueType   kXMPApplesnd   = "Apple:OSType:Scrap:snd";
const XMPValueType   kXMPApplealis  = "Apple:OSType:Scrap:alis";
const XMPValueType   kXMPApplesect  = "Apple:OSType:Scrap:sect";

//Categories
// - moved to StdDefs.h -
//#define kXMPCategoryText    "OpenDoc:Category:Text"
//#define kXMPCategoryGraphics   "OpenDoc:Category:Graphics"
//#define kXMPCategoryTime    "OpenDoc:Category:Time"

/*
old type constants:

const XMPValueType   kXMPWindowListType = "OpenDoc:Type:IDList";
// use kXMPIDs

const XMPValueType   kXMPValID = "XMPID"; 
// use kXMPID

const XMPValueType   kXMPValGraphicsSystem = "XMPUShort";   
// use kXMPUShort

const XMPValueType   kXMPValTransform = "XMPTransform";
// use kXMPTransform

const XMPValueType   kXMPValPartInfo = "XMPInfoType";
// use kXMPPartInfo

const XMPValueType   kXMPValFrameGroup = "XMPULong";
// use kXMPULong

const XMPValueType   kXMPFrameTree  = "XMPID";
const XMPValueType   kXMPSourceFrame = "XMPID";
*/

#endif   // _STDTYPES_
