/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    StdProps.h

   Contains:   Standard Properties

   Written by: OpenDoc Engineering

*/

#ifndef _STDPROPS_
#define _STDPROPS_

#ifndef _STORAGEU_
#include "StorageU.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   This file is used to store all the standard properties.
*/

//==============================================================================
// Constants
//==============================================================================

// Storage
const XMPPropertyName kXMPPropVersionList       = "OpenDoc:Property:DraftList";
const XMPPropertyName kXMPPropDraftProperties   = "OpenDoc:Property:DraftProperties";
const XMPPropertyName kXMPPropRootSU            = "OpenDoc:Property:Draft:RootStorageUnit";

const    XMPPropertyName   kXMPPropStorageUnitType    = "OpenDoc:Property:StorageUnit:Type";
const XMPPropertyName kXMPPropStorageUnitName   = "OpenDoc:Property:StorageUnitName";
const XMPPropertyName   kXMPPropCurrentSURef       = "OpenDoc:Property:StorageUnit:CurrentSURef";
const XMPPropertyName kXMPPropDocumentName      = "OpenDoc:Property:DocumentName";
const XMPPropertyName kXMPPropDraftName         = "OpenDoc:Property:DraftName";

const XMPPropertyName   kXMPPropValueProperty      = "OpenDoc:Property:Property";

// Persistent Object
const XMPPropertyName kXMPPropName           = "OpenDoc:Property:Name";
const XMPPropertyName kXMPPropComments       = "OpenDoc:Property:Comments";
const XMPPropertyName   kXMPPropCreateDate         = "OpenDoc:Property:CreationDate";
const XMPPropertyName   kXMPPropModDate         = "OpenDoc:Property:ModifiedDate";
const XMPPropertyName   kXMPPropModUser         = "OpenDoc:Property:ModifiedUser";

// WindowState
const XMPPropertyName kXMPPropWindowList        = "OpenDoc:Property:WindowList";

// Window
const XMPPropertyName kXMPPropWindow            = "OpenDoc:Property:Window";
const XMPPropertyName kXMPPropWindowRect        = "OpenDoc:Property:WindowRect";
const XMPPropertyName kXMPPropWindowTitle       = "OpenDoc:Property:WindowTitle";
const XMPPropertyName kXMPPropWindowProcID      = "OpenDoc:Property:WindowProcID";
const XMPPropertyName kXMPPropWindowIsVisible      = "OpenDoc:Property:WindowVisible";
const XMPPropertyName kXMPPropWindowHasCloseBox = "OpenDoc:Property:WindowHasCloseBox";
const XMPPropertyName kXMPPropWindowHasZoomBox  = "OpenDoc:Property:WindowHasZoomBox";
const XMPPropertyName kXMPPropWindowIsResizable = "OpenDoc:Property:WindowIsResizable";
const XMPPropertyName kXMPPropWindowIsRootWindow   = "OpenDoc:Property:WindowIsRootWindow";
const XMPPropertyName kXMPPropWindowIsFloating  = "OpenDoc:Property:WindowIsFloating";
const XMPPropertyName kXMPPropWindowHasMailer      = "OpenDoc:Property:WindowHasMailer";
const XMPPropertyName kXMPPropWindowIsMailerAware  = "OpenDoc:Property:WindowIsMailerAware";
const XMPPropertyName kXMPPropWindowRefCon      = "OpenDoc:Property:WindowRefCon";
const XMPPropertyName kXMPPropRootFrame         = "OpenDoc:Property:RootFrame";
const XMPPropertyName kXMPPropSourceFrame       = "OpenDoc:Property:SourceFrame";
const XMPPropertyName kXMPPropShouldShowLinks      = "OpenDoc:Property:ShouldShowLinks";

// Frame
const XMPPropertyName kXMPPropContainingFrame   = "OpenDoc:Property:ContainingFrame";
const XMPPropertyName kXMPPropGraphicsSystem       = "OpenDoc:Property:GraphicsSystem";
const XMPPropertyName kXMPPropFrameShape        = "OpenDoc:Property:FrameShape";
const XMPPropertyName kXMPPropFrameRegion       = "OpenDoc:Property:FrameRegion";
const XMPPropertyName kXMPPropUsedRegion        = "OpenDoc:Property:UsedRegion";
const XMPPropertyName   kXMPPropInternalTransform  = "OpenDoc:Property:InternalTransform";
const XMPPropertyName kXMPPropPart           = "OpenDoc:Property:Part";
const XMPPropertyName kXMPPropPartInfo       = "OpenDoc:Property:PartInfo";
const XMPPropertyName kXMPPropViewType       = "OpenDoc:Property:ViewType";
const XMPPropertyName kXMPPropPresentation      = "OpenDoc:Property:Presentation";
const XMPPropertyName kXMPPropFrameGroup        = "OpenDoc:Property:FrameGroup";
const XMPPropertyName kXMPPropIsRoot            = "OpenDoc:Property:IsRoot";
const XMPPropertyName kXMPPropIsSubframe        = "OpenDoc:Property:IsSubFrame";
const XMPPropertyName kXMPPropIsOverlaid        = "OpenDoc:Property:IsOverlaid";
const XMPPropertyName kXMPPropIsFrozen       = "OpenDoc:Property:IsFrozen";
const XMPPropertyName kXMPPropUsesCachedImage      = "OpenDoc:Property:UsesCachedImage";
const XMPPropertyName kXMPPropDoesPropagateEvents = "OpenDoc:Property:DoesPropagateEvents";

// Draft
const XMPPropertyName   kXMPPropDraftNumber     = "OpenDoc:Property:Draft:Number";
const XMPPropertyName   kXMPPropDraftComment       = "OpenDoc:Property:Draft:Comment";

// Link
const XMPPropertyName kXMPPropLink           = "OpenDoc:Property:Link";
const XMPPropertyName kXMPPropLinkSource        = "OpenDoc:Property:LinkSource";
const XMPPropertyName   kXMPPropLinkSpec        = "OpenDoc:Property:LinkSpec";
const XMPPropertyName kXMPPropSourcePart        = "OpenDoc:Property:SourcePart";
const XMPPropertyName kXMPPropEditionAlias      = "OpenDoc:Property:EditionAlias";
const XMPPropertyName kXMPPropLinkSection       = "OpenDoc:Property:LinkSection";
const XMPPropertyName kXMPPropLinkContentSU     = "OpenDoc:Property:LinkContentSU";
const XMPPropertyName kXMPPropAutoExport        = "OpenDoc:Property:AutoExport";
const XMPPropertyName kXMPPropChangeID       = "OpenDoc:Property:ChangeID";
const XMPPropertyName kXMPPropOriginalID        = "OpenDoc:Property:OriginalID";
const XMPPropertyName kXMPPropOriginalDraft     = "OpenDoc:Property:OriginalDraft";
const XMPPropertyName kXMPPropOriginalCloneKind = "OpenDoc:Property:OriginalCloneKind";

// Drag&Drop + Clipboard
const XMPPropertyName   kXMPPropContents        = "OpenDoc:Property:Contents";
const XMPPropertyName   kXMPPropExternalTransform  = "OpenDoc:Property:ExternalTransform";
const XMPPropertyName kXMPPropStandInFrame      = "OpenDoc:Property:StandInFrame";

// Document Properties
const XMPPropertyName kXMPPropEditionID         = "OpenDoc:Property:Document:EditionID";
const XMPPropertyName kXMPPropSectionID         = "OpenDoc:Property:Document:SectionID";

// Part
// annotations
const XMPPropertyName kXMPPropIconFamily        = "OpenDoc:Property:IconFamily";
const XMPPropertyName kXMPPropIsStationery      = "OpenDoc:Property:IsStationery";
const XMPPropertyName   kXMPPropPreferredEditor    = "OpenDoc:Property:PreferredEditor";
const XMPPropertyName   kXMPPropPartsBin        = "OpenDoc:Property:PartsBin";

// content
const XMPPropertyName kXMPPropDisplayFrames     = "OpenDoc:Property:DisplayFrames";
const XMPPropertyName kXMPPropEmbeddedFrames       = "OpenDoc:Property:EmbeddedFrames";
const XMPPropertyName kXMPPropPrintingInfo      = "OpenDoc:Property:PrintingInfo";

#endif   // _STDPROPS_
