/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    StdDefs.h

   Contains:   Defs to be used for name binding resources

   Written by: Caia Grisar

*/

#ifndef _STDDEFS_
#define _STDDEFS_

// NameSpaces

#define     kXMPContainerSuite         "ContainerSuite"
#define     kXMPKind             "KindCategories"
#define     kXMPEditorKinds            "EditorKinds"
#define     kXMPViewer              "Viewers"
#define     kXMPKindOldMacOSType    "KindOldMacOSType"

#define     kXMPSysPrefEditorKinds     "SysPrefEditorKinds"
#define     kXMPSysPrefEditorCategories   "SysPrefEditorCategories"

#define     kXMPEditorUserString    "EditorUserString"
#define     kXMPKindUserString         "KindUserString"
#define     kXMPCategoryUserString     "CategoryUserString"

#define     kNameMappings        'NMAP'
#define     kNMAPid           127

// Categories

#define kXMPCategoryText      "OpenDoc:Category:Text"
#define kXMPCategoryGraphics  "OpenDoc:Category:Graphics"
#define kXMPCategoryTime      "OpenDoc:Category:Time"
#define kXMPCategoryControl      "OpenDoc:Category:Control"
#define kXMPCategoryVideo     "OpenDoc:Category:Video"
#define kXMPCategorySound     "OpenDoc:Category:Sound"
#define kXMPCategoryPartsBin  "OpenDoc:Category:PartsBin"

// Resource types

#define kXMPIsMacOSTypeID           1        /* Mac OSType */
#define  kXMPIsINTLTextID           2        /* International text */
#define  kXMPIsAnISOStringID           3        /* ISOString */
#define  kXMPIsAnISOStringListID       4        /* ISOString List*/

#define kXMPPaletteWDEFID           128         /* Windoid WDEF */

// Script System constants (copied out of enums in Script.h)

#define  kXMPsmSystemScript            -1       /*designates system script.*/
#define  kXMPsmScriptLang           28       /*Current language for script*/

// View Type Sizes

#define     kXMPTinyIconSize     12 // 12x12 pixels
#define  kXMPSmallIconSize    16 // 16x16 pixels
#define     kXMPLargeIconSize    32 // 32x32 pixels
#define     kXMPThumbnailSize    64 // 64x64 pixels

#endif // _STDDEFS_
