/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    ShPrpAcc.h

   Contains:   Interfaces to property accessor classes used with Object
            Support Library

   Written by: Nick Pilch

*/

#ifndef _SHPRPACC_
#define _SHPRPACC_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _PROPACSR_
#include "PropAcsr.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   These classes aid with the getting and setting of properties for
   the callback routines for the Object Support Library. They encapulate the
   information necessary to represent a property and to get and set the
   property's value.
*/

//==============================================================================
// Classes defined in this interface
//==============================================================================

class ShellWinPropAccessor;

//==============================================================================
// Classes used by this interface
//==============================================================================

class PropAccessor;
class XMPShell;
class XMPWindow;

//==============================================================================
// ShellWinPropAccessor
//==============================================================================

class ShellPropAccessor : public PropAccessor
{
   public:
      ShellPropAccessor( DescType property, XMPShell* shell ) ;

      virtual void GetPropertyData( AEDesc* result ) = 0;
      virtual void SetPropertyData( AEDesc* data ) = 0;

      DescType GetProperty();

protected :
   DescType fProperty;

  private:

   XMPShell*   fShell;
} ;

class ShellSelfPropAccessor : public ShellPropAccessor
{
   public:
      ShellSelfPropAccessor( DescType property, XMPShell* shell ) ;

      void GetPropertyData( AEDesc* result ) ;
      void SetPropertyData( AEDesc* data ) ;
} ;

class ShellPartPropAccessor : public ShellPropAccessor
{
   public:
      ShellPartPropAccessor( DescType property, XMPShell* shell,
            XMPFrame* frame) ;

      void GetPropertyData( AEDesc* result ) ;
      void SetPropertyData( AEDesc* data ) ;

  private:
   XMPFrame* fFrame ;
} ;

#ifdef TO_BE_DELETED
class ShellFramePropAccessor : public ShellPropAccessor
{
   public:
      ShellFramePropAccessor( DescType property, XMPShell* shell,
            XMPFrame* frame) ;

      void GetPropertyData( AEDesc* result ) ;
      void SetPropertyData( AEDesc* data ) ;

  private:
   XMPFrame* fFrame ;
} ;
#endif // TO_BE_DELETED

class ShellDraftPropAccessor : public ShellPropAccessor
{
   public:
      ShellDraftPropAccessor( DescType property, XMPShell* shell,
            XMPDraft* draft ) ;

      void GetPropertyData( AEDesc* result ) ;
      void SetPropertyData( AEDesc* data ) ;

  private:
   XMPDraft* fDraft ;
} ;

class ShellWinPropAccessor : public ShellPropAccessor
{
  public:

   ShellWinPropAccessor(DescType property, XMPShell* shell, XMPWindow* window);

   void GetName(StringPtr name);
      // Caller must allocate storage

   void GetPropertyData( AEDesc* result ) ;
   void SetPropertyData( AEDesc* data ) ;

  private:
   XMPWindow*  fWindow;
};

#endif // _SHPRPACC_
