/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    Shape.h

  Contains:  Definition of class XMPAbsShape

  Written by:  Joshua Susser & Sepp Friedrich & Jens Alfke

*/

#ifndef _SHAPE_
#define _SHAPE_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"      // base class
#endif

//==============================================================================
// Classes used in this interface
//==============================================================================

class XMPTransform;
class XMPShape;
struct XMPRect;
struct XMPPolygon;
class XMPStorageUnit;

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPAbsShape;

//==============================================================================
// Enumeration defined in this interface
//==============================================================================

enum {
  kXMPLoseGeometry,      // Toss out geometric info to save time or space.
  kXMPPreserveGeometry,    // Preserve geometric info as long as possible
  kXMPNeedsGeometry      // Must keep geometric info.
};
typedef short XMPGeometryMode;

//==============================================================================
// XMPShape
//==============================================================================

class XMPAbsShape : public XMPObject
{

public:

  //---------------------------------
  // overrides

//  XMPVMethod XMPSize Purge(XMPSize size);    // override from XMPObject

  //---------------------------------
  // constructor/destructor

  XMPAbsShape( )        { }
  
  XMPVMethod ~XMPAbsShape()  { }
  
  XMPVMethod void InitShape( )
    = 0;

  //---------------------------------
  // getters/setters
  
  XMPMethod void SetGeometryMode( XMPGeometryMode mode )
    = 0;
  XMPMethod XMPGeometryMode GetGeometryMode( )
    = 0;
  XMPMethod void GetBoundingBox( XMPRect *bounds )
    = 0;
  XMPMethod XMPShape* SetRectangle( XMPRect *rect )
    = 0;
  XMPMethod XMPPolygon* CopyPolygon( )
    = 0;
  XMPMethod XMPShape* SetPolygon( XMPPolygon* )
    = 0;
  XMPMethod XMPPlatformShape GetPlatformShape( XMPGraphicsSystem )
    = 0;
  XMPMethod void SetPlatformShape( XMPGraphicsSystem, XMPPlatformShape )
    = 0;

  //---------------------------------
  // input / output:
  
  XMPMethod void WriteShape( XMPStorageUnit* )
    = 0;
  XMPMethod XMPShape* ReadShape( XMPStorageUnit* )
    = 0;

  //---------------------------------
  // comparison/testing functions

  XMPMethod XMPBoolean IsSameAs(XMPShape* compareShape)
    = 0;
  XMPMethod XMPBoolean IsEmpty( )
    = 0;
  XMPMethod XMPBoolean ContainsPoint(XMPPoint point)
    = 0;
  XMPMethod XMPBoolean IsRectangular( )
    = 0;
  XMPMethod XMPBoolean HasGeometry( )
    = 0;

  XMPVMethod void DumpToDebugDisk( const char * prompt )
    = 0;

  //---------------------------------
  // geometry operations
  
  XMPMethod XMPShape* Copy( )
    = 0;
  XMPMethod void CopyFrom(XMPShape* sourceShape)
    = 0;
  XMPMethod XMPShape* Transform(XMPTransform* transform)
    = 0;
  XMPMethod XMPShape* InverseTransform(XMPTransform* transform)
    = 0;
  XMPMethod XMPShape* Subtract(XMPShape* diffShape)
    = 0;
  XMPMethod XMPShape* Intersect(XMPShape* sectShape)
    = 0;
  XMPMethod XMPShape* Union(XMPShape* unionShape)
    = 0;
};

//#if PLATFORM_MACINTOSH

//#ifdef PLATFORM_OS2
#ifndef _SHAPEM_
#include "ShapeM.h"
#endif
//#endif

#endif // _SHAPE_
