/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    SEUtils.h

   Contains:   Interface to Semantic Events Utility Functions

   Written by: Nick Pilch

*/

#ifndef _SEUTILS_
#define _SEUTILS_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _SEMTINTF_
#include "SemtIntf.h"
#endif

const Boolean kNotSysHandler = false;
const Boolean kIsSysHandler = true;

XMPBoolean MissingParams(const AppleEvent* message);
pascal OSErr Pathname2FSSpec(DescType     /*typeCode*/,
                        Ptr         dataPtr,
                        Size     dataSize,
                        DescType /*toType*/,
                        long     /*handlerRefCon*/,
                        AEDesc*     result);
OSErr DecodeOrdinal(AEDesc ordData, long count, long* index,
               Boolean* allFlag, Boolean* zeroFlag);
void ReallocAndStuff2nd4Bytes(XMPOSLToken* token, XMPULong value);
XMPULong GetSecondFourBytesFromDataHandle(const XMPOSLToken* token);
XMPSLong GetSLongAttr(AppleEvent* ae, AEKeyword keyword);

// does an in-place coercion!
void ThrowIfCantCoerce( AEDesc* data, DescType desiredType ) ;
void ThrowIfNotAbsent( OSErr err ) ;

#endif // _SEUTILS_
