/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    SessHdr.h

  Contains:  Definition for session-related Bento Handlers.

  Written by:  Vincent Lo

*/


#ifndef _SESSHDR_
#define _SESSHDR_

#ifndef __CM_API__
#include "CMAPI.h"
#endif

#ifndef _PLFMTYPE_
#include "PlfmType.h"
#endif

//==============================================================================
// Classes used by this interface
//==============================================================================
class XMPContainer;

//==============================================================================
// Scalar Types
//==============================================================================

typedef struct XMPSessionRefCon XMPSessionRefCon;
struct XMPSessionRefCon {
  XMPContainer*  container;
  XMPHeap      heap;
};

//==============================================================================
// sessionRoutinesMetahandler
//==============================================================================

  CM_CFUNCTION
  
CMHandlerAddr CM_FIXEDARGS sessionRoutinesMetahandler(CMType targetType, CMconst_CMGlobalName operationType);

  // Metahandler proc for determining the addresses of the session handler operation routines.
  // Pass the address of this routine to a CMStartSession() call.

  CM_END_CFUNCTIONS


#endif  // _SESSHDR_
