/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    SemtIntM.h

   Contains:   Mac implementation of SemanticInterface class

   Written by: Caia Grisar

*/

#ifndef _SEMTINTM_
#define _SEMTINTM_


#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _EXTENSN_
#include "Extensn.h"
#endif

#ifndef _AEHSHTBL_
#include "AEHshTbl.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPMacSemanticInterface;
class XMPAEHashTable;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPPart;
class XMPMessageInterface;

//==============================================================================
// XMPMacSemanticInterface
//==============================================================================

#define kXMPMacSemanticInterfaceID "appl:xmpmacsemanticinterface$class,1.0.0"

class XMPMacSemanticInterface : public XMPAbsSemanticInterface
{
  public:

   XMPMacSemanticInterface();
   XMPVMethod ~XMPMacSemanticInterface();
   XMPNVMethod void InitSemanticInterface(XMPObject* base); // base is XMPPart*

   //--------------------------------------------------------------------------
   // Extension Interface
   //--------------------------------------------------------------------------

   XMPVMethod void Release();

   //--------------------------------------------------------------------------
   // Content Model
   //--------------------------------------------------------------------------

   // object accessor management
      
   XMPVMethod void      InstallObjectAccessor(DescType            desiredClass,
                                    DescType       containerType,
                                    XMPAccessorProcPtr   theAccessor,
                                    XMPSLong       accessorRefcon);

   XMPVMethod void      GetObjectAccessor(DescType          desiredClass,
                                 DescType          containerType,
                                 XMPAccessorProcPtr*  theAccessor,      // return parameter
                                 XMPSLong*         accessorRefcon);  // return parameter

   XMPVMethod void         RemoveObjectAccessor(DescType       desiredClass,
                                   DescType           containerType,
                                   XMPAccessorProcPtr theAccessor);

   // callback management

   XMPVMethod void InstallCompareProc(XMPCompareProcPtr  compareProc,
                                 XMPSLong    refCon);

   XMPVMethod void InstallCountProc(XMPCountProcPtr   countProc,
                                 XMPSLong refCon);

   XMPVMethod void InstallDisposeTokenProc(XMPDisposeTokenProcPtr disposeTokenProc,
                                 XMPSLong             refCon);

   XMPVMethod void InstallGetMarkTokenProc(XMPGetMarkTokenProcPtr getMarkTokenProc,
                                    XMPSLong          refCon);

   XMPVMethod void InstallMarkProc(XMPMarkProcPtr  markProc,
                                 XMPSLong refCon);

   XMPVMethod void InstallAdjustMarksProc(XMPAdjustMarksProcPtr   adjustMarksProc,
                                 XMPSLong          refCon);

   XMPVMethod void InstallGetErrDescProc(XMPGetErrDescProcPtr  errorDescProc,
                                 XMPSLong       refCon);

   XMPVMethod void InstallTokenInquiryProc(XMPTokenInquiryProcPtr tokenInquiryProc,
                                 XMPSLong       refCon);

   //--------------------------------------------------------------------------
   // Semantic Events
   //--------------------------------------------------------------------------

   XMPVMethod void   InstallEventHandler(AEEventClass          theAEEventClass,
                                 AEEventID            theAEEventID,
                                 XMPEventHandlerProcPtr  handler,
                                 XMPSLong             handlerRefcon);
   
   XMPVMethod void   RemoveEventHandler(AEEventClass              theAEEventClass,
                                AEEventID             theAEEventID,
                                XMPEventHandlerProcPtr   handler);
   
   XMPVMethod void   GetEventHandler(AEEventClass           theAEEventClass,
                              AEEventID            theAEEventID,
                              XMPEventHandlerProcPtr* handler,
                              XMPSLong*            handlerRefcon);
   
   XMPVMethod void   InstallCoercionHandler(DescType              fromType,
                                   DescType           toType,
                                   XMPCoercionHandler handler,
                                   XMPSLong           handlerRefcon,
                                   XMPBoolean         fromTypeIsDesc);
   
   XMPVMethod void   RemoveCoercionHandler(DescType            fromType,
                                  DescType         toType,
                                  XMPCoercionHandler  handler);
   
   XMPVMethod void   GetCoercionHandler(DescType               fromType,
                                DescType           toType,
                                XMPCoercionHandler*   handler,
                                XMPSLong*          handlerRefcon,
                                XMPBoolean*        fromTypeIsDesc);
   
   XMPVMethod void   InstallSpecialHandler(AEKeyword              functionClass,
                                    XMPSpecialHandlerPtr handler,
                                    XMPSLong          refCon);
   
   XMPVMethod void   RemoveSpecialHandler(AEKeyword               functionClass,
                                    XMPSpecialHandlerPtr handler);
   
   XMPVMethod void   GetSpecialHandler(AEKeyword               functionClass,
                                 XMPSpecialHandlerPtr*   handler,
                                 XMPSLong*            refCon);

   XMPVMethod void      SetOSLSupportFlags(short flags);

   XMPVMethod short  GetOSLSupportFlags();

  public: // Private by convention

   XMPBoolean  LookupEventHandler(AEEventClass           eventClass,
                           AEEventID            eventID,
                           XMPEventHandlerProcPtr* handler,
                           XMPSLong*            handlerRefcon);

   XMPBoolean  LookupCoercionHandler(DescType            fromType,
                              DescType          toType,
                              XMPCoercionHandler*  handler,
                              XMPSLong*         handlerRefcon,
                              XMPBoolean*       fromTypeIsDesc);

   XMPBoolean  LookupObjectAccessor(DescType          desiredClass,
                              DescType          containerType,
                              XMPAccessorProcPtr*  theAccessor,
                              XMPSLong*         accessorRefcon);

   OSLContext* GetOSLContext();

   XMPPart* CallTokenInquiryProc(XMPOSLToken*   token);

  private:

   void     ThrowProcNotFound(XMPAEHashTable* table);
   void     AddToTable(DescType key1, DescType key2, ProcPtr handler,
                        XMPSLong handlerRefCon,
                        XMPBoolean fromTypeIsDesc,
                        XMPAEHashTable* table);
   void     RetrieveFromTable(DescType key1, DescType key2,
                                 ProcPtr* handler,
                                 XMPSLong* handlerRefCon,
                                 XMPBoolean* fromTypeIsDesc,
                                 XMPAEHashTable* table);
   void     RemoveFromTable(DescType key1, DescType key2, ProcPtr handler,
                           XMPAEHashTable* table);
   XMPBoolean  HandlerLookup(
                        DescType    key1,
                        DescType    key2,
                        XMPAEHashTable*   theAEHashTable,
                        XMPEntryPtr    theValue);


   struct SIGenericKey
   {
      DescType    key1;
      DescType    key2;
   };
   
   struct SIGenericValue
   {
      ProcPtr        handler;
      XMPSLong    refCon;
      XMPBoolean     fromTypeIsDesc;
   };
   
   struct SIEventHandlerKey
   {
      AEEventClass   eventClass;
      AEEventID      eventID;
   };
   
   struct SIEventHandlerValue
   {
      XMPEventHandlerProcPtr  handler;
      XMPSLong          refCon;
   };
   
   struct SIObjectAccessorKey
   {
      DescType    desiredClass;
      DescType    containerType;
   };
   
   struct SIObjectAccessorValue
   {
      XMPAccessorProcPtr   accessor;
      XMPSLong       refCon;
   };
   
   struct SICoercionHandlerKey
   {
      DescType    fromType;
      DescType    toType;
   };

   struct SICoercionHandlerValue
   {
      XMPCoercionHandler   handler;
      XMPSLong       refCon;
      XMPBoolean        fromTypeIsDesc;
   };


   XMPAEHashTable*   fEventHandlerTable;
   XMPAEHashTable*   fObjectAccessorTable;
   XMPAEHashTable*   fCoercionHandlerTable;

      // Special Handler procs   
   XMPCountProcPtr      fCountProcPtr;
   XMPSLong          fCountProcPtrRefCon;
   XMPCompareProcPtr    fCompareProcPtr;
   XMPSLong          fCompareProcPtrRefCon;
   XMPDisposeTokenProcPtr  fDisposeTokenProcPtr;
   XMPSLong          fDisposeTokenProcPtrRefCon;
   XMPGetErrDescProcPtr fErrDescProcPtr;
   XMPSLong          fErrDescProcPtrRefCon;
   XMPGetMarkTokenProcPtr  fGetMarkTokenProcPtr;
   XMPSLong          fGetMarkTokenProcPtrRefCon;
   XMPMarkProcPtr          fMarkProcPtr;
   XMPSLong          fMarkProcPtrRefCon;
   XMPAdjustMarksProcPtr   fAdjustMarksProcPtr;
   XMPSLong          fAdjustMarksProcPtrRefCon;
   XMPTokenInquiryProcPtr  fTokenInquiryProc;
   XMPSLong          fTokenInquiryProcRefCon;

   short             fOSLSupportFlags;
};


#endif // _SEMTINTM_
