/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    ProtoApp.h

*/

#ifndef _PROTOAPP_
#define _PROTOAPP_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _SEMTINTF_
#include "SemtIntf.h"
#endif

class XMPApplication;
class XMPSession;
class XMPDispatcher;
class XMPWindowState;
class XMPArbitrator;
class XMPDraft;

extern XMPApplication* gApplication;
extern XMPSession* gExemplar;

class XMPApplication 
{
public:

  XMPApplication(XMPSession* session);        // Constructor
  virtual  ~XMPApplication();    // Destructor

  virtual void Initialize();
                  
  virtual  void Run();
  
  virtual void MainEventLoop();

  virtual XMPBoolean ContinueEventLoop();
  
  virtual void Open();
  
  virtual void InstallMenuBar();
  
  virtual void CreateDocument();
  
  virtual  void Close();

  virtual void SaveDraft(XMPDraft* draft);

  virtual void CloseDraft(XMPDraft* draft);
  
  virtual void HandleEvent(XMPEventData event);
  
  virtual void HandleNullEvent(XMPEventData event);
  
  virtual  void HandleMouseDownEvent(XMPEventData event);

  virtual void HandleMouseDownInMenuBar(XMPEventData event);

  virtual void HandleMouseDownInCloseBox(WindowPtr window, XMPEventData event);

  virtual void HandleMouseDownInDragRegion(WindowPtr window, XMPEventData event);

  virtual void HandleMouseDownInGrowBox(WindowPtr window, XMPEventData event);

  virtual void HandleMouseDownInZoomBox(WindowPtr window, short partcode, XMPEventData event);

  virtual void HandleMenuCommand(short menu, short item, XMPEventData event);
  
  virtual  void HandleMouseUpEvent(XMPEventData event);
    
  virtual  void HandleKeyDownEvent(XMPEventData event);
  
  virtual  void HandleKeyUpEvent(XMPEventData event);
  
  virtual  void HandleUpdateEvent(XMPEventData event);
  
  virtual  void HandleActivateEvent(XMPEventData event);

  virtual  void HandleOSEvent(XMPEventData event);

  virtual  void HandleHighLevelEvent(XMPEventData event);

  virtual RgnHandle XMPApplication::ComputeSleepRegion();

  typedef void (XMPApplication::*ProcessDocFunc)(AppleEvent* message,
                            AppleEvent* reply,
                            FSSpec* theFile);

  static void HandleOpenAppEvent(XMPPart*  thePart,
              AppleEvent* message,
              AppleEvent* reply,
              XMPSLong   refCon);
              
  static void HandleOpenDocsEvent(  XMPPart*  thePart,
                AppleEvent* message,
                AppleEvent* reply,
                XMPSLong   refCon);
                      
  static void HandlePrintDocsEvent(  XMPPart*  thePart,
                AppleEvent* message,
                AppleEvent* reply,
                XMPSLong   refCon);
                        
  static void HandleQuitEvent(  XMPPart*  thePart,
              AppleEvent* message,
              AppleEvent* reply,
              XMPSLong   refCon);
                    
  static void HandleGetTerminology(  XMPPart*  thePart,
                AppleEvent*  message,
                AppleEvent*  reply,
                XMPSLong  refCon);
                        
  static void Pathname2FSSpec(  XMPPart* thePart, 
                  DescType typeCode, 
                  Ptr dataPtr,
                  Size dataSize, 
                  DescType  toType, 
                  long handlerRefCon,
                  AEDesc*   result);

  void  OpenDoc(AppleEvent* message, AppleEvent* reply,
                  FSSpec* theFile);
  void  PrintDoc(AppleEvent* message, AppleEvent* reply,
                  FSSpec* theFile);

  
  protected:

  XMPSession* fSession;
  XMPDispatcher* fDispatcher;
  XMPWindowState* fWindowState;
  XMPArbitrator* fArbitrator;
  XMPBoolean fWasOpened; // Received an OApp or ODoc event
  XMPRgnHandle fSleepRegion;

  public:  // Private by convention

  XMPSession*  GetSession() {return fSession;}

  private:

  void  ProcessDocList(AppleEvent* message, AppleEvent* reply,
                      ProcessDocFunc theDocFunc);
  void  InstallObjectAccessors();
};  

#endif // _PROTOAPP_
