/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    PropAcsr.h

   Contains:   Abstract class for Apple Event object model property accessing
            class.

   Written by: Nick Pilch

*/

#ifndef _PROPACSR_
#define _PROPACSR_

#define APPLEINCL_AppleEvents
#ifndef APPLEINCLUDED
   #include <Apple.h>
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   This a simple abstract class to aid in the processing of Apple Events that
   are requests to get or set properties. Since OpenDoc does the resolution
   first, the object accessor routines can allocate one of these classes
   according to the property for which they have been asked to create a token.
   When passed back to the event handler, the event handler need only call the
   the appropriate member function of this class, GetData or SetData, to
   process the event. The event handler must then delete the object.
*/

//==============================================================================
// Constants
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// Classes defined in this interface
//==============================================================================

class PropAccessor;

//==============================================================================
// Classes used by this interface
//==============================================================================

//==============================================================================
// PropAccessor
//==============================================================================

//#define kPropAccessorID "appl:propaccessor$class,1.0.0"

class PropAccessor
{
  public:

   PropAccessor();
//    = 0;
// XMPVMethod void Initialize()
//    = 0;
//    virtual ~PropAccessor()
//    = 0;

   XMPVMethod void SetData(AppleEvent* message);
//    = 0;
      
      // Call this function inside a SetData event handler.
   
   XMPVMethod void GetData(AppleEvent* reply);
//    = 0;
      
      // Call this function inside a GetData event handler.
};

#endif // _PROPACSR_
