/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    Polygon.h

   Contains:   OpenDoc polygon data structure

   Written by: Jens Alfke

*/


#ifndef _POLYGON_
#define _POLYGON_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//==============================================================================
// XMPContour
//==============================================================================

struct XMPContour {
   XMPSLong nVertices;              // Variable-size struct:
   XMPPoint vertex[1];              // Array size is actually nVertices
};

//==============================================================================
// XMPPolygon
//==============================================================================

struct XMPPolygon {
   XMPSLong nContours;              // Variable-size struct:
   XMPContour  firstContour;           // Rest of contours follow after first
};

#endif //_POLYGON_
