/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    PlfmDef.h

  Contains:  Platform specific definitions

  Written by:  Vincent Lo

*/

#ifndef _PLFMDEF_
#define _PLFMDEF_

//==============================================================================
// Configuration
//==============================================================================

#define PLATFORM_MACINTOSH 1  /* This is the Mac implementation */  //feb, was 1
#ifndef PLATFORM_OS2
   #define PLATFORM_OS2 1
#endif

// The QuickDraw GX headers want this symbol to be defined if the universal
// interfaces are being used.
#ifndef ppcinterfaces     //feb
#define ppcinterfaces 1   //feb
#endif                    //feb

//==============================================================================
// Macros
//==============================================================================

#define  XMPMethod  virtual  
#define XMPVMethod  virtual
#define XMPNVMethod
#define XMPPascal  pascal
#define XMPStatic  static

// JYS: Added the following Macros
#define GetQDRegion     GetRegion
#define SetQDRegion     SetRegion
#define CopyQDRegion   CopyRegion
//------------------------------------------------------------------------------
//
// XMPUnused is for parameters not used in a function. It is similar to 
// #pragma unused. As a matter of fact, XMPUnused can be a pragma statement
// when it functions correctly in C++. For the time being, we have this little 
// macro to get rid of the compiler warnings. Please use this macro instead of
// commenting out the parameter name.

#define XMPUnused(x)  ((void) &x)

#define XMPDispatcher       XMPMacDispatcher
#define XMPWindow         XMPMacWindow
#define XMPMenuBar         XMPMacMenuBar
#define XMPDragAndDrop       XMPMacDragAndDrop
#define XMPTranslation       XMPMacTranslation
#define XMPClipboard       XMPMacClipboard
#define XMPStorageSystem    XMPMacStorageSystem
#define XMPWindowState       XMPMacWindowState
#define XMPLink         XMPMacLink
#define XMPLinkSource       XMPMacLinkSource  //feb
#define XMPLinkSpec       XMPMacLinkSpec
#define XMPNameSpace       XMPMacNameSpace
#define XMPNameSpaceManager   XMPMacNameSpaceManager
#define XMPValueIterator     XMPMacValueIterator
#define XMPSemanticInterface  XMPMacSemanticInterface
#define XMPMessageInterface    XMPMacMessageInterface
#define XMPNameResolver      XMPMacNameResolver
#define XMPCanvas        XMPMacCanvas
#define XMPShape        XMPMacShape
#define XMPTransform      XMPMacTransform
#define XMPFacet        XMPMacFacet
#define XMPUndo          XMPMacUndo

#endif  // _PLFMDEF_