/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    PfTypSt.h

   Contains:   Class definition for XMPPlatformTypeSet.

   Written by: Vincent Lo


*/

#ifndef _PFTYPST_
#define _PFTYPST_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================
class XMPPlatformTypeSet;

//=====================================================================================
// Classes used by this interface
//=====================================================================================
class OrderedCollection;

//=====================================================================================
// Class XMPPlatformTypeSet
//=====================================================================================

#define kXMPPlatformTypeSetID "appl:xmpplatformtypeset$class,1.0.0"

class XMPPlatformTypeSet
{
   friend class XMPPlatformTypeSetIterator;
   
public:

   XMPPlatformTypeSet();
   
   virtual ~XMPPlatformTypeSet();
      
   XMPMethod void Add(XMPPlatformType type);
   
   XMPMethod void Union(XMPPlatformTypeSet* typeSet);

   XMPMethod void Remove(XMPPlatformType type);
      
   XMPMethod void Difference(XMPPlatformTypeSet* typeSet);
   
   XMPMethod XMPBoolean Contains(XMPPlatformType type);
   
   XMPMethod XMPULong Count();
      
   XMPVMethod XMPPlatformTypeSetIterator* CreatePlatformTypeSetIterator();

private:

   OrderedCollection*   fSet;

};

#endif   // _PFTYPST_
