/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    PfTSItr.h

   Contains:   Class definition for XMPPlatformTypeSetIterator.

   Written by: Vincent Lo


*/

#ifndef _PFTSITR_
#define _PFTSITR_

#ifndef _PLFMTYPE_
#include "PlfmType.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================
class XMPPlatformTypeSetIterator;

//=====================================================================================
// Classes used by this interface
//=====================================================================================
class XMPPlatformTypeSet;
class OrderedCollectionIterator;

//=====================================================================================
// Class XMPPlatformTypeSetIterator
//=====================================================================================

#define kXMPPlatformTypeSetIteratorID "appl:xmpplatformtypesetiterator$class,1.0.0"

class XMPPlatformTypeSetIterator
{
public:

   XMPPlatformTypeSetIterator(XMPPlatformTypeSet* typeSet);

   virtual ~XMPPlatformTypeSetIterator();

   XMPMethod XMPBoolean    IsNotComplete();
   XMPMethod XMPPlatformType  First();
   XMPMethod XMPPlatformType  Next();
      
private:

   XMPPlatformTypeSet*        fPlatformTypeSet;
   OrderedCollectionIterator* fIterator;
};


#endif   // _PFTSITR_
