/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    XMPPartTypes.h

   Contains:   constants for bogus part-type registry class names

   Written by: Joshua Susser

   Copyright:   1993 by Apple Computer, Inc., all rights reserved.

   Change History (most recent first):

*/

#ifndef _PARTTYPE_
#define _PARTTYPE_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _DRAWDEF_
//#include "DrawDef.h"
#endif

#ifndef _CLOCKDEF_
//#include "ClockDef.h"
#endif

//#ifndef _DRAGDEF_
//#include "DragDef.h"
//#endif

//#ifndef _PARTBNDF_
//#include "PartBnDf.h"
//#endif


#ifdef NOT_YET
   const XMPType kXMPPartDrawPart          = kXMPKindTestDraw;
   const XMPType kXMPPartClockPart         = kXMPKindTestClock;
   const XMPType kXMPPartContainingPartRCR = "ContainingPartRCR";
   const XMPType kXMPPartParentPartRCR     = "ParentPartRCR";
   const XMPType kXMPPartTogglePart        = "TogglePart";
   const XMPType kXMPPartButtonPart        = "ButtonPart";
   const XMPType kXMPPartTextPart          = "TextPart";
   const XMPType kXMPPartMoviePart         = "MoviePart";
   const XMPType kXMPPartStylPart          = "StylPart";
   const XMPType kXMPPartTestPart          = "TestPart";
   const XMPType kXMPPartDragPart          = kXMPKindTestDrag;
   const XMPType kXMPPartPartsBin          = kXMPKindPartsBin;
#else
   // I'm not including the proper files yet to include the above.
#endif

const XMPType kQDPicturePart           = "Appl:Quickdraw Picture Viewer";

// These need to be the same value as the Kind constants for the part. Don't want to include
// the part headers from the framework samples here.

const XMPType kQuickTimePart           = "Apple:Kind:Framework:Sample:Movie";
const XMPType kQDrawPart               = "Apple:Kind:Framework:Sample:QDraw";
const XMPType kAnalogClockPart            = "Apple:Kind:Framework:Sample:Clock";
const XMPType kButtonPart              = "Apple:Kind:Framework:Sample:Button";
const XMPType kTextPart                = "Apple:Kind:Framework:Sample:Textension";


#endif // _PARTTYPE_
