/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    Node.h

  Contains:  Tree node class

  Written by:  Richard Rodseth

*/

#ifndef _NODE_
#define _NODE_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _LIST_
#include "List.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class Node;
class NodeTraverser;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class Link;
class LinkedList;

//=====================================================================================
// Class Node
//=====================================================================================

#define kNodeID "appl:node$class,1.0.0"

class  Node : private Link, private LinkedList
{
  public:
    Node();
    ~Node();

    XMPULong Size();
    
    Node* GetParent();
    Node* GetFirstChild();
    Node* GetLastChild();
    Node* GetNextSibling();
    Node* GetPreviousSibling();
      
    void SetParent(Node* parent);
    
    void AddChildFirst(Node* node);
    void AddChildLast(Node* node);
    void AddChildBefore(Node& existing, Node* node);
    void AddChildAfter(Node& existing, Node* node);
    void RemoveChild(Node& node);
    Node* GetChildAfter(Node* node);
    Node* GetChildBefore(Node* node);

    Node* FirstTopDown();
    Node* NextTopDown(XMPSiblingOrder siblingOrder);
    Node* GetNextAunt(XMPSiblingOrder siblingOrder);
    
    Node* FirstBottomUp(XMPSiblingOrder siblingOrder);
    Node* NextBottomUp(XMPSiblingOrder siblingOrder);

  private:
    Node*    fParent;
};

//=====================================================================================
// Class NodeTraverser
//=====================================================================================


#define kNodeTraverserID "appl:nodetraverser$class,1.0.0"

class NodeTraverser 
{
  
public:

  NodeTraverser(Node* root, 
          XMPTraversalType traversalType, 
          XMPSiblingOrder siblingOrder);
  ~NodeTraverser();

  Node*    First();
  Node*    Next();
  void    SkipChildren();
  XMPBoolean  IsNotComplete();

protected:  

  Node* FirstTopDown(Node* node);
  Node* NextTopDown(Node* node, XMPSiblingOrder siblingOrder);
  Node* GetNextAunt(Node* node, XMPSiblingOrder siblingOrder);
  Node* FirstBottomUp(Node* node, XMPSiblingOrder siblingOrder);
  Node* NextBottomUp(Node* node, XMPSiblingOrder siblingOrder);
  
private:
    Node*       fRoot;
   Node*       fCurrent;
   XMPTraversalType fTraversalType;
   XMPSiblingOrder  fSiblingOrder;
};

#endif // _NODE_